/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.documents;

import ch.elexis.core.data.interfaces.events.MessageEvent;
import ch.elexis.core.documents.Messages;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.model.ICategory;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.model.ITag;
import ch.elexis.core.services.IDocumentStore;
import ch.elexis.core.utils.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={DocumentStore.class})
public class DocumentStore {
    private static final String DEFAULT_STORE_ID = "ch.elexis.data.store.omnivore";
    public static final String ID_WITH_STOREID_SPLIT = ":-:-:";
    final ConcurrentMap<String, IDocumentStore> services = new ConcurrentHashMap<String, IDocumentStore>();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    void addDocumentStore(IDocumentStore store) {
        this.services.put(store.getId(), store);
    }

    void removeDocumentStore(IDocumentStore store) {
        this.services.remove(store.getId());
    }

    public List<IDocument> getDocuments(String patientId, String authorId, ICategory category, List<ITag> tag) {
        ArrayList<IDocument> documents = new ArrayList<IDocument>();
        this.services.values().forEach(service -> {
            boolean bl = documents.addAll(service.getDocuments(patientId, authorId, category, tag));
        });
        return documents;
    }

    public Map<ICategory, List<IDocument>> getDocumentsByPatientId(String patientId) {
        HashMap<ICategory, List<IDocument>> map = new HashMap<ICategory, List<IDocument>>();
        List<IDocument> documents = this.getDocuments(patientId, null, null, null);
        for (IDocument iDocument : documents) {
            ArrayList<IDocument> categoryDocuments = (ArrayList<IDocument>)map.get(iDocument.getCategory());
            if (categoryDocuments == null) {
                categoryDocuments = new ArrayList<IDocument>();
            }
            categoryDocuments.add(iDocument);
            map.put(iDocument.getCategory(), categoryDocuments);
        }
        return map;
    }

    public List<IDocument> getDocumentsByCategory(String patientId, ICategory iCategory) {
        return this.getDocuments(patientId, null, iCategory, null);
    }

    public Optional<IDocument> loadDocument(String id, String storeId) {
        return this.getService(storeId).loadDocument(id);
    }

    public Optional<InputStream> loadContent(IDocument document) {
        return this.getService(document.getStoreId()).loadContent(document);
    }

    public String saveContentToFile(IDocument document, String filePath) throws ElexisException {
        Optional in = this.getService(document.getStoreId()).loadContent(document);
        if (in.isPresent()) {
            try {
                File file = new File(filePath);
                FileUtils.copyInputStreamToFile((InputStream)((InputStream)in.get()), (File)file);
                return file.getAbsolutePath();
            }
            catch (IOException e) {
                throw new ElexisException("cannot save content", (Throwable)e);
            }
        }
        return null;
    }

    public String saveContentToTempFile(IDocument document, String tempFilePrefix, String tempFileSuffix, boolean deleteOnExit) throws ElexisException {
        Optional in = this.getService(document.getStoreId()).loadContent(document);
        if (in.isPresent()) {
            try {
                if (StringUtils.isEmpty((CharSequence)tempFilePrefix)) {
                    tempFilePrefix = "export";
                }
                if (StringUtils.isEmpty((CharSequence)tempFileSuffix)) {
                    tempFileSuffix = "tmp";
                }
                File tmpFile = new File(FileUtils.getTempDirectory(), String.valueOf(FileUtil.removeInvalidChars((String)tempFilePrefix)) + "." + tempFileSuffix);
                FileUtils.copyInputStreamToFile((InputStream)((InputStream)in.get()), (File)tmpFile);
                if (deleteOnExit) {
                    tmpFile.deleteOnExit();
                }
                return tmpFile.getAbsolutePath();
            }
            catch (IOException e) {
                throw new ElexisException("cannot save content", (Throwable)e);
            }
        }
        return null;
    }

    public IDocument saveDocument(IDocument document) throws ElexisException {
        return this.getService(document.getStoreId()).saveDocument(document);
    }

    public IDocument saveDocument(IDocument document, InputStream content) throws ElexisException {
        return this.getService(document.getStoreId()).saveDocument(document, content);
    }

    public void removeDocument(IDocument document) {
        this.getService(document.getStoreId()).removeDocument(document);
    }

    public IDocument createDocument(String storeId, String patientId, String path, String categoryName) {
        String title = FilenameUtils.getName((String)path);
        String mimeType = FilenameUtils.getExtension((String)path);
        IDocument iDocument = this.getService(storeId != null ? storeId : DEFAULT_STORE_ID).createDocument(patientId, title, categoryName);
        if (iDocument != null) {
            iDocument.setMimeType(mimeType);
            iDocument.setExtension(mimeType);
            return iDocument;
        }
        return null;
    }

    public List<ICategory> getCategories(IDocument iDocument) {
        ArrayList<ICategory> results = new ArrayList<ICategory>();
        HashSet<String> checkNames = new HashSet<String>();
        IDocumentStore service = this.getService(iDocument.getStoreId());
        List categories = service.getCategories();
        for (ICategory category : categories) {
            if (!checkNames.add(category.getName())) continue;
            results.add(category);
        }
        Collections.sort(results, new Comparator<ICategory>(){

            @Override
            public int compare(ICategory o1, ICategory o2) {
                if (o1 != null && o2 != null) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
                return o1 != null ? -1 : (o2 != null ? 1 : 0);
            }
        });
        return results;
    }

    public ICategory getDefaultCategory(IDocument iDocument) {
        return this.getService(iDocument.getStoreId()).getCategoryDefault();
    }

    public ICategory createCategory(IDocument iDocument, String name) {
        return this.getService(iDocument.getStoreId()).createCategory(name);
    }

    public ICategory renameCategory(IDocument iDocument, String newCategory) {
        ICategory oldCategory = iDocument.getCategory();
        this.getService(iDocument.getStoreId()).renameCategory(oldCategory, newCategory);
        return this.getService(iDocument.getStoreId()).createCategory(newCategory);
    }

    public ICategory removeCategory(IDocument iDocument, String newCategory) throws ElexisException {
        ICategory oldCategory = iDocument.getCategory();
        try {
            this.getService(iDocument.getStoreId()).removeCategory(iDocument, newCategory);
        }
        catch (IllegalStateException e) {
            throw new ElexisException("category references exists", (Throwable)e);
        }
        return this.getService(iDocument.getStoreId()).createCategory(newCategory);
    }

    public List<ITag> getTags() {
        return Collections.emptyList();
    }

    private IDocumentStore getService(String storeId) {
        IDocumentStore iDocumentStore = (IDocumentStore)this.services.get(storeId);
        if (iDocumentStore != null) {
            return iDocumentStore;
        }
        MessageEvent.fireError((String)Messages.DocumentStore_storeError, (String)(String.valueOf(Messages.DocumentStore_storeErrorText) + " " + storeId));
        return new EmptyDocumentStore();
    }

    public boolean isAllowed(IDocument document, IDocumentStore.Capability restricted) {
        if (document != null) {
            return this.getService(document.getStoreId()).isAllowed(restricted);
        }
        return false;
    }

    public Optional<IPersistentObject> getPersistenceObject(IDocument document) {
        return this.getService(document.getStoreId()).getPersistenceObject(document);
    }

    public IDocumentStore getDefaultDocumentStore() {
        return this.getService(DEFAULT_STORE_ID);
    }

    private class EmptyDocumentStore
    implements IDocumentStore {
        private EmptyDocumentStore() {
        }

        public String getId() {
            return "empty";
        }

        public String getName() {
            return "empty";
        }

        public List<IDocument> getDocuments(String patientId, String authorId, ICategory category, List<ITag> tag) {
            return Collections.emptyList();
        }

        public Optional<IDocument> loadDocument(String id) {
            return Optional.empty();
        }

        public Optional<InputStream> loadContent(IDocument document) {
            return Optional.empty();
        }

        public IDocument createDocument(String patientId, String title, String categoryName) {
            return null;
        }

        public IDocument saveDocument(IDocument document) throws ElexisException {
            return null;
        }

        public IDocument saveDocument(IDocument document, InputStream content) throws ElexisException {
            return null;
        }

        public void removeDocument(IDocument document) {
        }

        public List<ICategory> getCategories() {
            return Collections.emptyList();
        }

        public ICategory getCategoryDefault() {
            return null;
        }

        public ICategory createCategory(String name) {
            return null;
        }

        public void removeCategory(IDocument iDocument, String newCategory) throws IllegalStateException {
        }

        public void renameCategory(ICategory category, String newCategory) {
        }

        public Optional<IPersistentObject> getPersistenceObject(IDocument iDocument) {
            return Optional.empty();
        }
    }
}

