/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data.dto;

import ch.elexis.core.data.interfaces.IFall;
import ch.elexis.core.model.IXid;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Patient;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class FallDTO
implements IFall {
    private final IFall iFall;
    private String abrechnungsSystem;
    private String grund;
    private String beginnDatum;
    private String endDatum;
    private TimeTool billingDate;
    private Kontakt garant;
    private Map extInfo = new HashMap();
    private boolean copyForPatient;
    private String bezeichnung;
    private List<IFallChanged> fallChanges = new ArrayList<IFallChanged>();
    private boolean changed = false;

    public FallDTO(IFall fall) {
        this.iFall = fall;
        this.fallChanges.clear();
        this.abrechnungsSystem = this.iFall.getAbrechnungsSystem();
        this.grund = this.iFall.getGrund();
        this.beginnDatum = this.iFall.getBeginnDatum();
        this.endDatum = this.iFall.getEndDatum();
        this.billingDate = this.iFall.getBillingDate();
        this.garant = this.iFall.getGarant();
        this.copyForPatient = this.iFall.getCopyForPatient();
        this.extInfo = this.iFall.getMap("ExtInfo");
        this.bezeichnung = this.iFall.getBezeichnung();
    }

    @Override
    public void setAbrechnungsSystem(String abrechnungsSystem) {
        if (!StringUtils.equals((String)this.abrechnungsSystem, (String)abrechnungsSystem)) {
            this.abrechnungsSystem = abrechnungsSystem;
            this.informChanged(true);
        }
    }

    @Override
    public String getAbrechnungsSystem() {
        return this.abrechnungsSystem;
    }

    @Override
    public String getGrund() {
        return this.grund;
    }

    @Override
    public void setGrund(String grund) {
        if (!StringUtils.equals((String)this.grund, (String)grund)) {
            this.informChanged(false);
        }
        this.grund = grund;
    }

    @Override
    public String getBeginnDatum() {
        return this.beginnDatum;
    }

    @Override
    public void setBeginnDatum(String beginnDatum) {
        if (!StringUtils.equals((String)this.beginnDatum, (String)beginnDatum)) {
            this.informChanged(false);
        }
        this.beginnDatum = beginnDatum;
    }

    @Override
    public String getEndDatum() {
        return this.endDatum;
    }

    @Override
    public void setEndDatum(String endDatum) {
        if (!StringUtils.equals((String)this.endDatum, (String)endDatum)) {
            this.informChanged(false);
        }
        this.endDatum = endDatum;
    }

    @Override
    public TimeTool getBillingDate() {
        return this.billingDate;
    }

    @Override
    public void setBillingDate(TimeTool billingDate) {
        this.billingDate = billingDate;
        this.informChanged(false);
    }

    @Override
    public void setGarant(Kontakt garant) {
        this.garant = garant;
        this.informChanged(false);
    }

    @Override
    public Kontakt getGarant() {
        return this.garant;
    }

    @Override
    public void setMap(String string, Map<Object, Object> ht) {
        if ("ExtInfo".equals(string)) {
            this.extInfo = ht;
            this.informChanged(false);
        }
    }

    @Override
    public Map getMap(String fldExtinfo) {
        return this.extInfo;
    }

    @Override
    public String getInfoString(String key) {
        Object value = this.extInfo.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        return "";
    }

    @Override
    public void setInfoString(String key, String value) {
        this.extInfo.put(key, value);
        this.informChanged(false);
    }

    @Override
    public void setCopyForPatient(boolean copyForPatient) {
        this.copyForPatient = copyForPatient;
        this.informChanged(false);
    }

    @Override
    public void setBezeichnung(String bezeichnung) {
        if (!StringUtils.equals((String)this.bezeichnung, (String)bezeichnung)) {
            this.informChanged(false);
        }
        this.bezeichnung = bezeichnung;
    }

    @Override
    public String getBezeichnung() {
        return this.bezeichnung;
    }

    @Override
    public boolean getCopyForPatient() {
        return this.copyForPatient;
    }

    public String getId() {
        return this.iFall.getId();
    }

    public IXid getXid() {
        return this.iFall.getXid();
    }

    public List<IXid> getXids() {
        return this.iFall.getXids();
    }

    public long getLastUpdate() {
        return this.iFall.getLastUpdate();
    }

    public boolean isValid() {
        return this.iFall.isValid();
    }

    public int state() {
        return this.iFall.state();
    }

    public boolean exists() {
        return this.iFall.exists();
    }

    public boolean isAvailable() {
        return this.iFall.isAvailable();
    }

    public String getXid(String domain) {
        return this.iFall.getXid(domain);
    }

    public boolean get(String[] fields, String[] values) {
        return this.iFall.get(fields, values);
    }

    public String get(String field) {
        return this.iFall.get(field);
    }

    public String getLabel() {
        return this.iFall.getLabel();
    }

    @Override
    public Patient getPatient() {
        return this.iFall.getPatient();
    }

    @Override
    public Konsultation[] getBehandlungen(boolean b) {
        return this.iFall.getBehandlungen(b);
    }

    @Override
    public String getOptionals() {
        return this.iFall.getOptionals();
    }

    @Override
    public String getUnused() {
        return this.iFall.getUnused();
    }

    @Override
    public void setCostBearer(Kontakt costBearer) {
        this.iFall.setCostBearer(costBearer);
    }

    @Override
    public Kontakt getCostBearer() {
        return this.iFall.getCostBearer();
    }

    public String storeToString() {
        return this.iFall.storeToString();
    }

    public boolean set(String field, String value) {
        if (StringUtils.equals((String)field, (String)"Bezeichnung")) {
            this.setBezeichnung(value);
        }
        this.informChanged(false);
        return false;
    }

    @Override
    public void setRequiredContact(String kostentraeger, Kontakt k) {
        this.informChanged(false);
    }

    @Override
    public void setRequiredString(String versicherungsnummer, String vnOld) {
        this.informChanged(false);
    }

    public boolean addXid(String domain, String domain_id, boolean updateIfExists) {
        this.informChanged(false);
        return false;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void register(IFallChanged fallChanged) {
        this.fallChanges.add(fallChanged);
    }

    private void informChanged(boolean triggersRecalc) {
        for (IFallChanged iFallChanged : this.fallChanges) {
            iFallChanged.changed(this, triggersRecalc);
        }
        this.changed = true;
    }

    public static interface IFallChanged {
        public void changed(FallDTO var1, boolean var2);
    }
}

