/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.model.IXid;
import ch.elexis.data.DBLog;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Organisation;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Person;
import ch.elexis.data.Query;
import ch.rgw.tools.Log;
import ch.rgw.tools.VersionInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class Xid
extends PersistentObject
implements IXid {
    public static final String FLD_OBJECT = "object";
    public static final String FLD_ID_IN_DOMAIN = "domain_id";
    public static final String FLD_DOMAIN = "domain";
    public static final String FLD_QUALITY = "quality";
    public static final String FLD_TYPE = "type";
    private static final String VERSION = "1.0.0";
    private static final String TABLENAME = "XID";
    private static Log log = Log.get((String)"XID");
    public static final int ASSIGNMENT_LOCAL = 1;
    public static final int ASSIGNMENT_REGIONAL = 2;
    public static final int ASSIGNMENT_GLOBAL = 3;
    public static final int QUALITY_GUID = 4;
    private static HashMap<String, XIDDomain> domains;
    private static HashMap<String, String> domainMap;

    static {
        Xid.addMapping(TABLENAME, FLD_TYPE, FLD_OBJECT, FLD_DOMAIN, FLD_ID_IN_DOMAIN, FLD_QUALITY);
        domains = new HashMap();
        domainMap = new HashMap();
        String storedDomains = CoreHub.globalCfg.get("LocalXIDDomains", null);
        if (storedDomains == null) {
            domains.put("www.elexis.ch/xid", new XIDDomain("www.elexis.ch/xid", "UUID", 5, PersistentObject.class.getCanonicalName()));
            domains.put("www.ahv.ch/xid", new XIDDomain("www.ahv.ch/xid", "AHV", 2, Person.class.getCanonicalName()));
            domains.put("www.xid.ch/id/oid", new XIDDomain("www.xid.ch/id/oid", "OID", 7, PersistentObject.class.getCanonicalName()));
            domains.put("www.xid.ch/id/ean", new XIDDomain("www.xid.ch/id/ean", "EAN", 2, Kontakt.class.getCanonicalName()));
            Xid.storeDomains();
        } else {
            String[] stringArray = storedDomains.split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String dom = stringArray[n2];
                String[] spl = dom.split("#");
                if (spl.length < 2) {
                    log.log("Fehler in XID-Domain " + dom, 2);
                }
                String simpleName = "";
                if (spl.length >= 3) {
                    simpleName = spl[2];
                }
                String displayOptions = "Kontakt";
                if (spl.length >= 4) {
                    displayOptions = spl[3];
                }
                domains.put(spl[0], new XIDDomain(spl[0], simpleName, Integer.parseInt(spl[1]), displayOptions));
                domainMap.put(simpleName, spl[0]);
                ++n2;
            }
        }
        VersionInfo vv = new VersionInfo(CoreHub.Version);
        if (vv.isOlder("1.3.2")) {
            XIDDomain xd = domains.get("www.xid.ch/id/ean");
            xd.addDisplayOption(Person.class);
            xd.addDisplayOption(Organisation.class);
            xd = domains.get("www.ahv.ch/xid");
            xd.addDisplayOption(Person.class);
        }
    }

    public Xid(PersistentObject o, String domain, String domain_id) throws XIDException {
        Xid xid;
        XIDDomain dom = domains.get(domain);
        if (dom == null) {
            throw new XIDException("Domain not registered: " + domain);
        }
        Integer val = dom.quality;
        if (val == null) {
            throw new XIDException("XID Domain " + domain + " is not registered");
        }
        if (val > 9) {
            val = (val & 7) + 4;
        }
        if ((xid = Xid.findXID(domain, domain_id)) != null) {
            if (xid.get(FLD_OBJECT).equals(o.getId())) {
                return;
            }
            throw new XIDException("XID " + domain + ":" + domain_id + " is not unique");
        }
        xid = Xid.findXID(o, domain);
        if (xid != null) {
            throw new XIDException("XID " + domain + ": " + domain_id + " was already assigned");
        }
        this.create(null);
        this.set(new String[]{FLD_TYPE, FLD_OBJECT, FLD_DOMAIN, FLD_ID_IN_DOMAIN, FLD_QUALITY}, o.getClass().getName(), o.getId(), domain, domain_id, Integer.toString(val));
    }

    public int getQuality() {
        return Xid.checkZero(this.get(FLD_QUALITY));
    }

    public boolean isGUID() {
        return (this.getQuality() & 4) != 0;
    }

    public String getDomain() {
        return this.get(FLD_DOMAIN);
    }

    public String getDomainId() {
        return this.get(FLD_ID_IN_DOMAIN);
    }

    public IPersistentObject getObject() {
        PersistentObject po = CoreHub.poFactory.createFromString(String.valueOf(this.get(FLD_TYPE)) + "::" + this.get(FLD_OBJECT));
        return po;
    }

    @Override
    public String getLabel() {
        IPersistentObject po = this.getObject();
        String text = "unknown object";
        if (po != null) {
            text = po.getLabel();
        }
        StringBuilder ret = new StringBuilder();
        ret.append(text).append(": ").append(this.get(FLD_DOMAIN)).append("->").append(this.get(FLD_ID_IN_DOMAIN));
        return ret.toString();
    }

    public static Xid load(String id) {
        return new Xid(id);
    }

    public static Xid findXID(String domain, String id) {
        String dom = domainMap.get(domain);
        if (dom != null) {
            domain = dom;
        }
        Query qbe = new Query(Xid.class);
        qbe.add(FLD_DOMAIN, "=", domain);
        qbe.add(FLD_ID_IN_DOMAIN, "=", id);
        List ret = qbe.execute();
        if (ret.size() == 1) {
            Xid result = (Xid)ret.get(0);
            IPersistentObject po = result.getObject();
            if (po != null && po.exists()) {
                return result;
            }
            result.delete();
        }
        return null;
    }

    public static IPersistentObject findObject(String domain, String id) {
        Xid xid = Xid.findXID(domain, id);
        if (xid != null) {
            return xid.getObject();
        }
        return null;
    }

    public static Xid findXID(PersistentObject o, String domain) {
        String dom = domainMap.get(domain);
        if (dom != null) {
            domain = dom;
        }
        Query qbe = new Query(Xid.class);
        qbe.add(FLD_DOMAIN, "=", domain);
        qbe.add(FLD_OBJECT, "=", o.getId());
        List ret = qbe.execute();
        if (ret.size() == 1) {
            return (Xid)ret.get(0);
        }
        return null;
    }

    public static boolean localRegisterXIDDomain(String domain, String simpleName, int quality) {
        if (domains.containsKey(domain)) {
            log.log("XID Domain " + domain + " bereits registriert", 2);
        } else if (domain.matches(".*[;#].*")) {
            log.log("XID Domain " + domain + " ung\u00fcltig", 2);
        } else {
            domains.put(domain, new XIDDomain(domain, simpleName == null ? "" : simpleName, quality, "Kontakt"));
            if (simpleName != null) {
                domainMap.put(simpleName, domain);
            }
            Xid.storeDomains();
            return true;
        }
        return false;
    }

    public static boolean localRegisterXIDDomainIfNotExists(String domain, String simpleName, int quality) {
        if (domains.get(domain) != null) {
            return true;
        }
        return Xid.localRegisterXIDDomain(domain, simpleName, quality);
    }

    public static Integer getXIDDomainQuality(String xidDomain) {
        XIDDomain xd = domains.get(xidDomain);
        if (xd == null) {
            return null;
        }
        return xd.getQuality();
    }

    public static String getSimpleNameForXIDDomain(String domain) {
        XIDDomain xd = domains.get(domain);
        if (xd == null) {
            return domain;
        }
        return xd.simple_name;
    }

    public static XIDDomain getDomain(String name) {
        String dom = domainMap.get(name);
        if (dom != null) {
            name = dom;
        }
        return domains.get(name);
    }

    protected Xid(String id) {
        super(id);
    }

    protected Xid() {
    }

    @Override
    protected String getTableName() {
        return TABLENAME;
    }

    private static void storeDomains() {
        StringBuilder sb = new StringBuilder();
        for (String k : domains.keySet()) {
            XIDDomain xd = domains.get(k);
            sb.append(k).append("#").append(xd.getQuality()).append("#").append(xd.getSimpleName()).append("#").append(xd.getDisplayOptions()).append(";");
        }
        CoreHub.globalCfg.set("LocalXIDDomains", sb.toString());
    }

    public static Set<String> getXIDDomains() {
        return domains.keySet();
    }

    @Override
    public boolean undelete() {
        new DBLog(this, DBLog.TYP.UNDELETE);
        return this.set("deleted", "0");
    }

    public static class XIDDomain {
        String domain_name;
        String simple_name;
        int quality;
        ArrayList<Class<? extends PersistentObject>> displayOptions = new ArrayList();

        public XIDDomain(String dname, String simplename, int quality, String options) {
            this.domain_name = dname;
            this.simple_name = simplename;
            this.quality = quality;
            String[] stringArray = options.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String op = stringArray[n2];
                try {
                    Class<?> clazz = Class.forName(op);
                    this.displayOptions.add(clazz);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
        }

        public String getSimpleName() {
            return this.simple_name;
        }

        public void setSimpleName(String simple_name) {
            this.simple_name = simple_name;
            Xid.storeDomains();
        }

        public String getDomainName() {
            return this.domain_name;
        }

        public int getQuality() {
            return this.quality;
        }

        public void addDisplayOption(Class<? extends PersistentObject> clazz) {
            if (!this.displayOptions.contains(clazz)) {
                this.displayOptions.add(clazz);
                Xid.storeDomains();
            }
        }

        public void removeDisplayOption(Class<? extends PersistentObject> clazz) {
            this.displayOptions.remove(clazz);
            Xid.storeDomains();
        }

        public boolean isDisplayedFor(Class<? extends PersistentObject> clazz) {
            return this.displayOptions.contains(clazz);
        }

        String getDisplayOptions() {
            StringBuilder r = new StringBuilder();
            for (Class<? extends PersistentObject> clazz : this.displayOptions) {
                r.append(clazz.getName()).append(",");
            }
            return r.toString();
        }
    }

    public static class XIDException
    extends Exception {
        public XIDException(String reason) {
            super(reason);
        }
    }
}

