/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Query;
import ch.elexis.data.Rechnung;
import ch.elexis.data.Verrechnet;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.Money;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.VersionInfo;
import java.util.ArrayList;
import java.util.List;

public class VerrechnetCopy
extends Verrechnet {
    public static final String RECHNUNGID = "RechnungId";
    public static final String BEHANDLUNGID = "BehandlungId";
    public static final String VERSIONID = "VERSION";
    private static final String TABLENAME = "VERRECHNETCOPY";
    public static final String VERSION = "1.0.0";
    static final String create = "CREATE TABLE VERRECHNETCOPY (ID VARCHAR(25) primary key, lastupdate BIGINT,deleted CHAR(1) default '0',RechnungId VARCHAR(25), BehandlungId VARCHAR(25), Leistg_txt VARCHAR(255),Leistg_code VARCHAR(25),Klasse VARCHAR(80),Zahl CHAR(3),EK_Kosten CHAR(8),VK_TP CHAR(8),VK_Scale CHAR(8),VK_Preis CHAR(8),Scale CHAR(4) DEFAULT '100',Scale2 CHAR(4) DEFAULT '100',userID VARCHAR(25),Detail BLOB);CREATE INDEX verrechnetcopy1 ON VERRECHNETCOPY (RechnungId);CREATE INDEX verrechnetcopy2 ON VERRECHNETCOPY (BehandlungId);INSERT INTO VERRECHNETCOPY (ID,RechnungId) VALUES (" + JdbcLink.wrap((String)"VERSION") + "," + JdbcLink.wrap((String)"1.0.0") + ");";

    static {
        VerrechnetCopy.addMapping(TABLENAME, RECHNUNGID, BEHANDLUNGID, "Leistg_txt", "Leistg_code", "Klasse", "Zahl", "EK_Kosten", "VK_TP", "VK_Scale", "VK_Preis", "Scale", "Scale2", "ExtInfo=Detail", "userID");
        if (!VerrechnetCopy.tableExists(TABLENAME)) {
            VerrechnetCopy.createOrModifyTable(create);
        } else {
            VerrechnetCopy version = VerrechnetCopy.load(VERSIONID);
            VersionInfo vi = new VersionInfo(version.get(RECHNUNGID));
            vi.isOlder(VERSION);
        }
    }

    public VerrechnetCopy() {
    }

    public VerrechnetCopy(String id) {
        super(id);
    }

    public static VerrechnetCopy load(String id) {
        return new VerrechnetCopy(id);
    }

    @Override
    protected String getTableName() {
        return TABLENAME;
    }

    public VerrechnetCopy(Verrechnet verrechnet, Rechnung bill) {
        this.create(null);
        this.set(new String[]{RECHNUNGID, BEHANDLUNGID, "Leistg_txt", "Leistg_code", "Klasse", "Zahl", "EK_Kosten", "VK_TP", "VK_Scale", "VK_Preis", "Scale", "Scale2", "userID"}, bill.getId(), verrechnet.getKons().getId(), verrechnet.get("Leistg_txt"), verrechnet.get("Leistg_code"), verrechnet.get("Klasse"), verrechnet.get("Zahl"), verrechnet.get("EK_Kosten"), verrechnet.get("VK_TP"), verrechnet.get("VK_Scale"), verrechnet.get("VK_Preis"), verrechnet.get("Scale"), verrechnet.get("Scale2"), verrechnet.get("userID"));
        this.setDetail("vat_scale", verrechnet.getDetail("vat_scale"));
    }

    public static List<Verrechnet> getVerrechnetByBill(Rechnung bill) {
        ArrayList<Verrechnet> ret = new ArrayList<Verrechnet>();
        Query vcQuery = new Query(VerrechnetCopy.class);
        vcQuery.add(RECHNUNGID, "=", bill.getId());
        List res = vcQuery.execute();
        ret.addAll(res);
        return ret;
    }

    public static List<VerrechnetCopy> getVerrechnetCopyByConsultation(Konsultation consultation) {
        Query vcQuery = new Query(VerrechnetCopy.class);
        vcQuery.add(BEHANDLUNGID, "=", consultation.getId());
        return vcQuery.execute();
    }

    @Override
    public Money getBruttoPreis() {
        int tp = VerrechnetCopy.checkZero(this.get("VK_TP"));
        TimeTool date = new TimeTool(this.getLastUpdate());
        Konsultation k = Konsultation.load(this.get(BEHANDLUNGID));
        Fall fall = k.getFall();
        IVerrechenbar v = this.getVerrechenbar();
        double tpw = 1.0;
        if (v != null) {
            tpw = v.getFactor(date, fall);
        }
        return new Money((int)Math.round(tpw * (double)tp));
    }

    @Override
    public Konsultation getKons() {
        return Konsultation.load(this.get(BEHANDLUNGID));
    }
}

