/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.admin.ACE;
import ch.elexis.core.jdt.NonNull;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.JdbcLink;
import java.util.Locale;

public class Right
extends PersistentObject {
    public static final String TABLENAME = "RIGHT_";
    public static final String FLD_NAME = "NAME";
    public static final String FLD_I18N_NAME = "I18N_NAME";
    public static final String FLD_PARENTID = "PARENTID";
    public static final String FLD_TREEPATH = "TREEPATH";
    public static final String FLD_EXT_I18N_LABEL = "LAB_" + Locale.getDefault().getLanguage();

    static {
        Right.addMapping(TABLENAME, FLD_NAME, FLD_PARENTID, FLD_TREEPATH, FLD_I18N_NAME);
    }

    protected Right() {
    }

    protected Right(String id) {
        super(id);
    }

    protected Right(ACE ace) {
        this.create(ace.getUniqueHashFromACE());
        this.set(FLD_NAME, ace.getName());
        Right parentRight = Right.getOrCreateRightByACE(ace.getParent());
        this.set(FLD_PARENTID, parentRight.getId());
        this.setTranslatedLabel(ace.getLocalizedName());
    }

    public static Right load(String id) {
        return new Right(id);
    }

    @NonNull
    public static Right getOrCreateRightByACE(ACE ace) {
        Right right = Right.load(ace.getUniqueHashFromACE());
        if (right.exists()) {
            return right;
        }
        return new Right(ace);
    }

    public static void resetTable() {
        JdbcLink.Stm stm = Right.getConnection().getStatement();
        stm.exec("DELETE FROM RIGHT_ WHERE ID NOT EQUALS 'root'");
        Right.getConnection().releaseStatement(stm);
    }

    @Override
    public String getLabel() {
        return this.getId();
    }

    @Override
    protected String getTableName() {
        return TABLENAME;
    }

    public String getTranslatedLabel() {
        return this.get(FLD_I18N_NAME);
    }

    public void setTranslatedLabel(String translatedLabel) {
        this.set(FLD_I18N_NAME, translatedLabel);
    }
}

