/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.jdt.NonNull;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.model.issue.Priority;
import ch.elexis.core.model.issue.ProcessStatus;
import ch.elexis.core.model.issue.Type;
import ch.elexis.core.model.issue.Visibility;
import ch.elexis.data.Anwender;
import ch.elexis.data.DBConnection;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.TimeTool;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class Reminder
extends PersistentObject
implements Comparable<Reminder> {
    public static final String TABLENAME = "REMINDERS";
    public static final String FLD_MESSAGE = "Message";
    public static final String FLD_VISIBILITY = "Typ";
    public static final String FLD_STATUS = "Status";
    public static final String FLD_DUE = "Due";
    public static final String FLD_CREATOR = "Creator";
    public static final String FLD_KONTAKT_ID = "IdentID";
    public static final String FLD_RESPONSIBLE = "Responsible";
    public static final String FLD_PRIORITY = "priority";
    public static final String FLD_ACTION_TYPE = "actionType";
    public static final String FLD_SUBJECT = "subject";
    public static final String FLD_PARAMS = "Params";
    public static final String FLD_JOINT_RESPONSIBLES = "Responsibles";
    public static final Cache<String, Boolean> cachedAttributeKeys = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();
    public static final String ALL_RESPONSIBLE = "ALL";
    private static String PS_REMINDERS_RESPONSIBLE;
    private static String PS_REMINDERS_BASE;

    static {
        Reminder.addMapping(TABLENAME, FLD_KONTAKT_ID, "Creator=OriginID", "Due=S:D:DateDue", FLD_STATUS, FLD_VISIBILITY, FLD_PARAMS, FLD_MESSAGE, FLD_RESPONSIBLE, "Responsibles=JOINT:ResponsibleID:ReminderID:REMINDERS_RESPONSIBLE_LINK", FLD_PRIORITY, FLD_ACTION_TYPE, FLD_SUBJECT);
        PS_REMINDERS_RESPONSIBLE = "SELECT r.ID, r.SUBJECT, r.DateDue, r.IdentID, r.OriginID FROM REMINDERS r LEFT JOIN REMINDERS_RESPONSIBLE_LINK rrl ON (r.id = rrl.ReminderId) WHERE (rrl.ResponsibleID = ? OR r.Responsible = 'ALL') AND r.deleted = '0'";
        PS_REMINDERS_BASE = "SELECT r.ID, r.SUBJECT, r.DateDue, r.IdentID, r.OriginID FROM REMINDERS r LEFT JOIN REMINDERS_RESPONSIBLE_LINK rrl ON (r.id = rrl.ReminderId) WHERE (rrl.ResponsibleID = ? OR r.Responsible = 'ALL') AND r.deleted = '0' AND r.Status != '3'";
    }

    @Override
    protected String getTableName() {
        return TABLENAME;
    }

    Reminder() {
    }

    private Reminder(String id) {
        super(id);
    }

    @Override
    public void clearCachedAttributes() {
        Iterator iterator = cachedAttributeKeys.asMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry key = iterator.next();
            if (((String)key.getKey()).contains(this.getId())) {
                Reminder.getDefaultConnection().getCache().remove((String)key.getKey());
            }
            iterator.remove();
        }
    }

    @Override
    public String getKey(String field) {
        String key = super.getKey(field);
        cachedAttributeKeys.put((Object)key, (Object)true);
        return key;
    }

    public Reminder(Kontakt ident, String due, Visibility visibility, String params, String msg2) {
        this.create(null);
        if (ident == null) {
            ident = CoreHub.actUser;
        }
        this.set(new String[]{FLD_KONTAKT_ID, FLD_CREATOR, FLD_DUE, FLD_STATUS, FLD_VISIBILITY, FLD_PARAMS, FLD_MESSAGE}, ident.getId(), CoreHub.actUser.getId(), due, Byte.toString((byte)Visibility.ALWAYS.numericValue()), Byte.toString((byte)visibility.numericValue()), params, msg2);
    }

    public void addResponsible(Anwender a) {
        List<Anwender> responsibles = this.getResponsibles();
        if (responsibles == null) {
            responsibles = new ArrayList<Anwender>();
        }
        responsibles.add(a);
        this.setResponsible(responsibles);
    }

    public static Reminder load(String id) {
        return new Reminder(id);
    }

    @Override
    public String getLabel() {
        String[] vals = this.get(true, FLD_KONTAKT_ID, FLD_DUE, FLD_MESSAGE, FLD_SUBJECT, FLD_CREATOR);
        Kontakt k = Kontakt.load(vals[0]);
        boolean isPatientRelatedReminder = this.isPatientRelatedReminder(vals[4], vals[0]);
        StringBuilder sb = new StringBuilder();
        if (vals[1].length() > 0) {
            sb.append(String.valueOf(vals[1]) + " ");
        }
        sb.append("(" + this.getConfiguredKontaktLabel(k, isPatientRelatedReminder) + "): ");
        sb.append(vals[3].length() > 1 ? vals[3] : vals[2]);
        return sb.toString();
    }

    private String getConfiguredKontaktLabel(Kontakt k, boolean isPatientRelatedReminder) {
        if (isPatientRelatedReminder) {
            StringBuilder sb = new StringBuilder();
            String[] configLabel = CoreHub.userCfg.get("reminder/patientlabel/choosen", LabelFields.LASTNAME.toString()).split(",");
            String[] values = k.get(true, configLabel);
            int i = 0;
            while (i < values.length) {
                sb.append(values[i]);
                if (i != values.length - 1) {
                    sb.append(", ");
                }
                ++i;
            }
            return sb.toString();
        }
        return k.get("Bezeichnung3");
    }

    public static ProcessStatus determineCurrentStatus(ProcessStatus givenStatus, TimeTool dueDate) {
        if (ProcessStatus.CLOSED == givenStatus || ProcessStatus.ON_HOLD == givenStatus) {
            return givenStatus;
        }
        if (dueDate == null) {
            return givenStatus;
        }
        int compare = TimeTool.compare((TimeTool)new TimeTool(), (TimeTool)dueDate);
        if (compare == 0) {
            return ProcessStatus.DUE;
        }
        if (compare == -1) {
            return ProcessStatus.OVERDUE;
        }
        return givenStatus;
    }

    public ProcessStatus getProcessStatus() {
        return ProcessStatus.byNumericSafe((String)this.get(FLD_STATUS));
    }

    public void setProcessStatus(ProcessStatus processStatus) {
        this.set(FLD_STATUS, Byte.toString((byte)processStatus.ordinal()));
    }

    public ProcessStatus getStatus() {
        ProcessStatus ps = ProcessStatus.byNumericSafe((String)this.get(FLD_STATUS));
        return Reminder.determineCurrentStatus(ps, this.getDateDue());
    }

    public String getMessage() {
        return Reminder.checkNull(this.get(FLD_MESSAGE));
    }

    public void setStatus(ProcessStatus s) {
        this.setProcessStatus(s);
    }

    @Nullable
    public TimeTool getDateDue() {
        String string = this.get(FLD_DUE);
        if (string == null || "" == string) {
            return null;
        }
        TimeTool ret = new TimeTool(this.get(FLD_DUE));
        ret.chop(3);
        return ret;
    }

    public int getDueState() {
        return Reminder.determineDueState(this.getDateDue());
    }

    public static int determineDueState(TimeTool dueDate) {
        if (dueDate != null) {
            TimeTool now = new TimeTool();
            if (dueDate.isBefore(now)) {
                return 2;
            }
            if (dueDate.isEqual(now)) {
                return 1;
            }
        }
        return 0;
    }

    public void setResponsible(List<Anwender> responsibles) {
        this.removeFromList(FLD_JOINT_RESPONSIBLES);
        if (responsibles == null) {
            this.set(FLD_RESPONSIBLE, ALL_RESPONSIBLE);
        } else {
            this.set(FLD_RESPONSIBLE, null);
            this.addAllToList(FLD_JOINT_RESPONSIBLES, responsibles.stream().map((? super T a) -> a.getId()).collect(Collectors.toList()), null);
        }
    }

    public List<Anwender> getResponsibles() {
        if (ALL_RESPONSIBLE.equals(this.get(FLD_RESPONSIBLE))) {
            return null;
        }
        List<String[]> lResp = this.getList(FLD_JOINT_RESPONSIBLES, new String[0]);
        ArrayList<Anwender> ret = new ArrayList<Anwender>(lResp.size());
        for (String[] r : lResp) {
            ret.add(Anwender.load(r[0]));
        }
        return ret;
    }

    public Anwender getCreator() {
        return Anwender.load(Reminder.checkNull(this.get(FLD_CREATOR)));
    }

    public boolean isPatientRelated() {
        String[] vals = this.get(true, FLD_KONTAKT_ID, FLD_CREATOR);
        return this.isPatientRelatedReminder(vals[0], vals[1]);
    }

    private boolean isPatientRelatedReminder(String creatorId, String contactId) {
        return !Objects.equals(creatorId, contactId);
    }

    public static List<Reminder> findAllUserIsResponsibleFor(Anwender anwender, boolean showOnlyDueReminders) {
        HashSet<Reminder> ret = new HashSet<Reminder>();
        DBConnection dbConnection = Reminder.getDefaultConnection();
        PreparedStatement ps = showOnlyDueReminders ? dbConnection.getPreparedStatement(String.valueOf(PS_REMINDERS_RESPONSIBLE) + " AND r.DateDue != '' AND r.DateDue <= ?") : dbConnection.getPreparedStatement(PS_REMINDERS_RESPONSIBLE);
        try {
            try {
                ps.setString(1, anwender.getId());
                if (showOnlyDueReminders) {
                    ps.setString(2, new TimeTool().toString(9));
                }
                ResultSet res = ps.executeQuery();
                while (res.next()) {
                    Reminder reminder = Reminder.load(res.getString(1));
                    reminder.putInCache(FLD_SUBJECT, res.getString(2));
                    String decode = reminder.decode(FLD_DUE, res);
                    reminder.putInCache(FLD_DUE, decode);
                    reminder.putInCache("IdentId", res.getString(4));
                    reminder.putInCache("OriginId", res.getString(5));
                    reminder.setDBConnection(dbConnection);
                    ret.add(reminder);
                }
                res.close();
            }
            catch (Exception ex) {
                ExHandler.handle((Throwable)ex);
                ArrayList<Reminder> arrayList = new ArrayList<Reminder>(ret);
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                dbConnection.releasePreparedStatement(ps);
                return arrayList;
            }
        }
        finally {
            try {
                ps.close();
            }
            catch (SQLException sQLException) {}
            dbConnection.releasePreparedStatement(ps);
        }
        return new ArrayList<Reminder>(ret);
    }

    public static List<Reminder> findForToday() {
        Query qbe = new Query(Reminder.class);
        qbe.add(FLD_DUE, "<=", new TimeTool().toString(9));
        qbe.add(FLD_STATUS, "<>", Integer.toString(ProcessStatus.CLOSED.numericValue()));
        List<Reminder> ret = qbe.execute();
        return ret;
    }

    public static List<Reminder> findForPatient(Patient p, Kontakt responsible) {
        Query qbe = new Query(Reminder.class);
        qbe.add(FLD_KONTAKT_ID, "=", p.getId());
        qbe.add(FLD_STATUS, "<>", Integer.toString(ProcessStatus.CLOSED.numericValue()));
        qbe.add(FLD_DUE, "<=", new TimeTool().toString(9));
        if (responsible != null) {
            qbe.startGroup();
            qbe.add(FLD_RESPONSIBLE, "=", responsible.getId());
            qbe.or();
            qbe.add(FLD_RESPONSIBLE, "", null);
            qbe.endGroup();
        }
        return qbe.execute();
    }

    public static List<Reminder> findToShowOnStartup(Anwender a) {
        Query qbe = new Query(Reminder.class);
        qbe.add(FLD_DUE, "<=", new TimeTool().toString(9));
        qbe.add(FLD_STATUS, "<>", Integer.toString(ProcessStatus.CLOSED.numericValue()));
        qbe.add(FLD_VISIBILITY, "=", Integer.toString(Visibility.POPUP_ON_LOGIN.numericValue()));
        return qbe.execute();
    }

    public static List<Reminder> findOpenRemindersResponsibleFor(@NonNull Anwender anwender, boolean onlyDue, Patient patient, boolean onlyPopup) {
        return Reminder.findOpenRemindersResponsibleFor(anwender, onlyDue, -1, patient, onlyPopup);
    }

    public static List<Reminder> findOpenRemindersResponsibleFor(@NonNull Anwender anwender, boolean onlyDue, int dueDays, Patient patient, boolean onlyPopup) {
        if (anwender == null) {
            anwender = CoreHub.actUser;
        }
        HashSet<Reminder> ret = new HashSet<Reminder>();
        DBConnection dbConnection = Reminder.getDefaultConnection();
        StringBuilder query = new StringBuilder(PS_REMINDERS_BASE);
        if (dueDays > 0) {
            TimeTool dueDaysDate = new TimeTool();
            dueDaysDate.addDays(dueDays);
            query.append(" AND r.DateDue != '' AND r.DateDue <= " + JdbcLink.wrap((String)dueDaysDate.toString(9)));
        } else if (onlyDue) {
            query.append(" AND r.DateDue != '' AND r.DateDue <= " + JdbcLink.wrap((String)new TimeTool().toString(9)));
        }
        if (patient != null) {
            query.append(" AND r.IdentID = " + patient.getWrappedId());
        }
        PreparedStatement ps = dbConnection.getPreparedStatement(query.toString());
        try {
            try {
                if (anwender != null) {
                    ps.setString(1, anwender.getId());
                    ResultSet res = ps.executeQuery();
                    while (res.next()) {
                        Reminder reminder = Reminder.load(res.getString(1));
                        reminder.putInCache(FLD_SUBJECT, res.getString(2));
                        String decode = reminder.decode(FLD_DUE, res);
                        reminder.putInCache(FLD_DUE, decode);
                        reminder.putInCache("IdentId", res.getString(4));
                        reminder.putInCache("OriginID", res.getString(5));
                        reminder.setDBConnection(dbConnection);
                        if (onlyPopup && reminder.getVisibility() != Visibility.POPUP_ON_PATIENT_SELECTION) continue;
                        ret.add(reminder);
                    }
                    res.close();
                }
            }
            catch (Exception ex) {
                ExHandler.handle((Throwable)ex);
                ArrayList<Reminder> arrayList = new ArrayList<Reminder>(ret);
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                dbConnection.releasePreparedStatement(ps);
                return arrayList;
            }
        }
        finally {
            try {
                ps.close();
            }
            catch (SQLException sQLException) {}
            dbConnection.releasePreparedStatement(ps);
        }
        return new ArrayList<Reminder>(ret);
    }

    public static List<Reminder> findRemindersDueFor(Patient p, Anwender a, boolean bOnlyPopup) {
        return Reminder.findOpenRemindersResponsibleFor(a, true, p, bOnlyPopup);
    }

    public Patient getKontakt() {
        Patient ret = Patient.load(this.get(FLD_KONTAKT_ID));
        if (ret.exists()) {
            return ret;
        }
        return null;
    }

    @Override
    public int compareTo(Reminder r) {
        int i = TimeTool.compare((TimeTool)this.getDateDue(), (TimeTool)r.getDateDue());
        if (i == 0) {
            return this.getId().compareTo(r.getId());
        }
        return i;
    }

    @Override
    public boolean delete() {
        Reminder.getConnection().exec("DELETE FROM REMINDERS_RESPONSIBLE_LINK WHERE ReminderID=" + this.getWrappedId());
        return super.delete();
    }

    public Visibility getVisibility() {
        return Visibility.byNumericSafe((String)this.get(FLD_VISIBILITY));
    }

    public void setVisibility(Visibility visibility) {
        this.set(FLD_VISIBILITY, Integer.toString(visibility.numericValue()));
    }

    public Priority getPriority() {
        String priority = this.get(FLD_PRIORITY);
        return Priority.byNumericSafe((String)priority);
    }

    public void setPriority(Priority priority) {
        this.set(FLD_PRIORITY, Integer.toString(priority.numericValue()));
    }

    public Type getActionType() {
        String actionType = this.get(FLD_ACTION_TYPE);
        return Type.byNumericSafe((String)actionType);
    }

    public void setActionType(Type at) {
        this.set(FLD_ACTION_TYPE, Integer.toString(at.numericValue()));
    }

    public String getSubject() {
        return this.get(FLD_SUBJECT);
    }

    public void setSubject(String subject) {
        this.set(FLD_SUBJECT, subject);
    }

    public static enum LabelFields {
        PAT_ID("PatientNr"),
        FIRSTNAME("Vorname"),
        LASTNAME("Name"),
        BIRTHDAY("Geburtsdatum");

        private final String text;

        private LabelFields(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }

        public String getKontaktEquivalent() {
            if (this.text.equals(FIRSTNAME.toString())) {
                return "Bezeichnung2";
            }
            if (this.text.equals(LASTNAME.toString())) {
                return "Bezeichnung1";
            }
            return "";
        }
    }
}

