/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.interfaces.scripting.Interpreter;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.model.ILabItem;
import ch.elexis.core.model.ILabResult;
import ch.elexis.core.types.LabItemTyp;
import ch.elexis.data.Kontakt;
import ch.elexis.data.LabResult;
import ch.elexis.data.Labor;
import ch.elexis.data.Messages;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.data.Script;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LabItem
extends PersistentObject
implements Comparable<LabItem>,
ILabItem {
    public static final String REF_MALE = "RefMann";
    public static final String REF_FEMALE_OR_TEXT = "RefFrauOrTx";
    public static final String PRIO = "prio";
    public static final String GROUP = "Gruppe";
    public static final String TYPE = "Typ";
    public static final String UNIT = "Einheit";
    public static final String LAB_ID = "LaborID";
    public static final String TITLE = "titel";
    public static final String SHORTNAME = "kuerzel";
    public static final String EXPORT = "export";
    public static final String FORMULA = "formula";
    public static final String DIGITS = "digits";
    public static final String VISIBLE = "visible";
    public static final String BILLINGCODE = "billingcode";
    public static final String LOINCCODE = "loinccode";
    static final String LABITEMS = "LABORITEMS";
    private static final Pattern varPattern = Pattern.compile("\\[[*]?[-a-zA-Z\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00e9\u00e0\u00e8_ ]+\\.[-a-zA-Z0-9\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00e9\u00e0\u00e8_ ]+\\]");
    public static final String REFVAL_INCONCLUSIVE = "inconclusive";

    static {
        LabItem.addMapping(LABITEMS, SHORTNAME, TITLE, LAB_ID, REF_MALE, REF_FEMALE_OR_TEXT, UNIT, TYPE, GROUP, PRIO, EXPORT, FORMULA, DIGITS, VISIBLE, BILLINGCODE, LOINCCODE);
    }

    @Override
    protected String getTableName() {
        return LABITEMS;
    }

    public LabItem(String code, String title, Kontakt labor, String RefMann, String RefFrau, String Unit, LabItemTyp type, String grp, String seq) {
        this(code, title, labor != null ? labor.getId() : null, RefMann, RefFrau, Unit, type, grp, seq);
    }

    public LabItem(String code, String title, String laborId, String RefMann, String RefFrau, String Unit, LabItemTyp type, String grp, String seq) {
        Query qbe;
        String labid;
        String tp = "1";
        if (type == LabItemTyp.NUMERIC) {
            tp = "0";
        } else if (type == LabItemTyp.ABSOLUTE) {
            tp = "2";
        } else if (type == LabItemTyp.FORMULA) {
            tp = "3";
        } else if (type == LabItemTyp.DOCUMENT) {
            tp = "4";
        }
        this.create(null);
        if (StringTool.isNothing((Object)seq)) {
            seq = title.substring(0, 1);
        }
        if (StringTool.isNothing((Object)grp)) {
            grp = Messages.LabItem_defaultGroup;
        }
        if (laborId == null && (labid = (qbe = new Query(Kontakt.class)).findSingle("istLabor", "=", "1")) == null) {
            laborId = new Labor(Messages.LabItem_shortOwnLab, Messages.LabItem_longOwnLab).getId();
        }
        this.set(new String[]{SHORTNAME, TITLE, LAB_ID, REF_MALE, REF_FEMALE_OR_TEXT, UNIT, TYPE, GROUP, PRIO, VISIBLE}, code, title, laborId, RefMann, RefFrau, Unit, tp, grp, seq, "1");
    }

    protected LabItem() {
    }

    protected LabItem(String id) {
        super(id);
    }

    public static LabItem load(String id) {
        return new LabItem(id);
    }

    public String toString() {
        return this.getLabel();
    }

    public String getEinheit() {
        return LabItem.checkNull(this.get(UNIT));
    }

    public void setEinheit(String unit) {
        this.set(UNIT, unit);
    }

    public String getGroup() {
        return LabItem.checkNull(this.get(GROUP));
    }

    public void setGroup(String group) {
        this.set(GROUP, group);
    }

    public String getPrio() {
        return LabItem.checkNull(this.get(PRIO));
    }

    public void setPrio(String prio) {
        this.set(PRIO, prio);
    }

    public String getKuerzel() {
        return LabItem.checkNull(this.get(SHORTNAME));
    }

    public void setKuerzel(String shortname) {
        this.set(SHORTNAME, shortname);
    }

    public String getName() {
        return LabItem.checkNull(this.get(TITLE));
    }

    public void setName(String title) {
        this.set(TITLE, title);
    }

    public Labor getLabor() {
        return Labor.load(this.get(LAB_ID));
    }

    public String getExport() {
        return LabItem.checkNull(this.get(EXPORT));
    }

    public void setExport(String export) {
        this.set(EXPORT, export);
    }

    public void setTyp(LabItemTyp typ) {
        this.set(TYPE, Integer.toString(typ.getType()));
    }

    public LabItemTyp getTyp() {
        LabItemTyp type = LabItemTyp.fromType((String)this.get(TYPE));
        if (type != null) {
            return type;
        }
        return LabItemTyp.TEXT;
    }

    public String evaluateNew(Patient pat, TimeTool date, List<ILabResult> results) {
        String formel = this.getFormula();
        formel = formel.substring("SCRIPT:".length());
        results = this.sortResultsDescending(results);
        for (ILabResult result : results) {
            String var = ((LabItem)result.getItem()).makeVarName();
            if (formel.indexOf(var) == -1) continue;
            formel = formel.replaceAll(var, result.getResult());
        }
        try {
            return Script.executeScript(formel, pat).toString();
        }
        catch (ElexisException e) {
            return "?formel?";
        }
    }

    public String evaluate(Patient pat, List<ILabResult> results) throws ElexisException {
        String var;
        if (!this.getTyp().equals((Object)LabItemTyp.FORMULA)) {
            return null;
        }
        String formel = this.getFormula();
        if (formel.startsWith("SCRIPT:")) {
            return this.evaluateNew(pat, null, results);
        }
        boolean bMatched = false;
        results = this.sortResultsDescending(results);
        for (ILabResult result : results) {
            var = ((LabItem)result.getItem()).makeVarName();
            if (formel.indexOf(var) == -1 || result.getResult() == null || result.getResult().isEmpty() || result.getResult().equals("?")) continue;
            formel = formel.replaceAll(var, result.getResult());
            bMatched = true;
        }
        Matcher matcher = varPattern.matcher(formel);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            var = matcher.group();
            String[] fields = var.split("\\.");
            if (fields.length <= 1) continue;
            String repl = "\"" + pat.get(fields[1].replaceFirst("\\]", "")) + "\"";
            matcher.appendReplacement(sb, repl);
            bMatched = true;
        }
        matcher.appendTail(sb);
        if (!bMatched) {
            return null;
        }
        Interpreter scripter = Script.getInterpreterFor(formel);
        try {
            String result = scripter.run(sb.toString(), false).toString();
            return result;
        }
        catch (ElexisException e) {
            return "?formel?";
        }
    }

    private List<ILabResult> sortResultsDescending(List<ILabResult> results) {
        Collections.sort(results, new Comparator<ILabResult>(){

            @Override
            public int compare(ILabResult lr1, ILabResult lr2) {
                int var2Length;
                int var1Length = ((LabItem)lr1.getItem()).makeVarName().length();
                if (var1Length < (var2Length = ((LabItem)lr2.getItem()).makeVarName().length())) {
                    return 1;
                }
                if (var1Length > var2Length) {
                    return -1;
                }
                return 0;
            }
        });
        return results;
    }

    public String evaluate(Patient pat, TimeTool date) throws ElexisException {
        if (!this.getTyp().equals((Object)LabItemTyp.FORMULA)) {
            return null;
        }
        Query qbe = new Query(LabResult.class);
        qbe.add("PatientID", "=", pat.getId());
        qbe.add("Datum", "=", date.toString(9));
        List<ILabResult> results = qbe.execute();
        return this.evaluate(pat, results);
    }

    public String makeVarName() {
        String[] group = this.getGroup().split(" ", 2);
        String num = this.getPrio().trim();
        return String.valueOf(group[0]) + "_" + num;
    }

    public int getDigits() {
        String digits = LabItem.checkNull(this.get(DIGITS));
        if (digits.isEmpty()) {
            return 0;
        }
        return Integer.parseInt(digits);
    }

    public void setDigits(int digits) {
        this.set(DIGITS, Integer.toString(digits));
    }

    public boolean isVisible() {
        String visible = this.get(VISIBLE);
        if (visible == null || visible.isEmpty()) {
            this.setVisible(true);
            return true;
        }
        return visible.equals("1");
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.set(VISIBLE, "1");
        } else {
            this.set(VISIBLE, "0");
        }
    }

    public String getRefW() {
        String ret = LabItem.checkNull(this.get(REF_FEMALE_OR_TEXT)).split("##")[0];
        return ret;
    }

    public String getRefM() {
        return LabItem.checkNull(this.get(REF_MALE));
    }

    public void setRefW(String r) {
        this.set(REF_FEMALE_OR_TEXT, r);
    }

    public void setRefM(String r) {
        this.set(REF_MALE, r);
    }

    public void setFormula(String f) {
        this.set(FORMULA, f);
    }

    public String getFormula() {
        String formula = this.get(FORMULA);
        if (formula == null || formula.isEmpty()) {
            String[] refWEntry = this.get(REF_FEMALE_OR_TEXT).split("##");
            String string = formula = refWEntry.length > 1 ? refWEntry[1] : "";
            if (formula != null && !formula.isEmpty()) {
                this.setFormula(formula);
            }
        }
        return formula;
    }

    public String getLoincCode() {
        return LabItem.checkNull(this.get(LOINCCODE));
    }

    public void setLoincCode(String code) {
        this.set(LOINCCODE, code);
    }

    public String getBillingCode() {
        return LabItem.checkNull(this.get(BILLINGCODE));
    }

    public void setBillingCode(String code) {
        this.set(BILLINGCODE, code);
    }

    @Override
    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        String[] fields = new String[]{SHORTNAME, TITLE, REF_MALE, REF_FEMALE_OR_TEXT, UNIT, TYPE, GROUP, PRIO};
        String[] vals = new String[fields.length];
        this.get(fields, vals);
        sb.append(vals[0]).append(", ").append(vals[1]);
        if ("0".equals(vals[5])) {
            sb.append(" (").append(vals[2]).append("/").append(this.getRefW()).append(" ").append(vals[4]).append(")");
        } else {
            sb.append(" (").append(this.getRefW()).append(")");
        }
        sb.append("[").append(vals[6]).append(", ").append(vals[7]).append("]");
        return sb.toString();
    }

    public String getShortLabel() {
        StringBuilder sb = new StringBuilder();
        String[] fields = new String[]{TITLE, UNIT, LAB_ID};
        String[] vals = new String[fields.length];
        this.get(fields, vals);
        Labor lab = Labor.load(vals[2]);
        String labName = "Labor?";
        if (lab != null) {
            labName = lab.get("Bezeichnung1");
        }
        sb.append(vals[0]).append(" (").append(vals[1]).append("; ").append(labName).append(")");
        return sb.toString();
    }

    @Override
    public int compareTo(LabItem other) {
        String otherGroup;
        if (other == null) {
            return -1;
        }
        String mineGroup = this.getGroup();
        if (!mineGroup.equals(otherGroup = other.getGroup())) {
            return mineGroup.compareTo(otherGroup);
        }
        String mine = this.getPrio().trim();
        String others = other.getPrio().trim();
        if (mine.matches("[0-9]+") && others.matches("[0-9]+")) {
            Integer iMine = Integer.parseInt(mine);
            Integer iOthers = Integer.parseInt(others);
            return iMine.compareTo(iOthers);
        }
        return mine.compareTo(others);
    }

    public static List<LabItem> getLabItems() {
        Query qbe = new Query(LabItem.class, LABITEMS, false, new String[]{TITLE, SHORTNAME, LOINCCODE, UNIT, REF_MALE, REF_FEMALE_OR_TEXT, GROUP, PRIO});
        return qbe.execute();
    }

    public static List<LabItem> getLabItems(String laborId, String shortDesc, String refM, String refW, String unit) {
        Query qbe = new Query(LabItem.class);
        if (laborId != null && laborId.length() > 0) {
            qbe.add(LAB_ID, "=", laborId);
        }
        if (shortDesc != null && shortDesc.length() > 0) {
            qbe.add(SHORTNAME, "=", shortDesc, true);
        }
        if (refM != null && refM.length() > 0) {
            qbe.add(REF_MALE, "=", refM, true);
        }
        if (refW != null && refW.length() > 0) {
            qbe.add(REF_FEMALE_OR_TEXT, "=", refW, true);
        }
        if (unit != null && unit.length() > 0) {
            qbe.add(UNIT, "=", unit, true);
        }
        return qbe.execute();
    }

    public void mergeWith(LabItem source) {
        Query qsr = new Query(LabResult.class);
        qsr.add("ItemID", "=", source.getId());
        List sourceResults = qsr.execute();
        for (LabResult labResult : sourceResults) {
            String resultProp;
            if (labResult.getOrigin() == null) {
                labResult.setOrigin(source.getLabor());
            }
            if ((resultProp = labResult.get("reffemale")) == null || resultProp.isEmpty()) {
                labResult.setRefFemale(source.getRefW());
            }
            if ((resultProp = labResult.get("refmale")) == null || resultProp.isEmpty()) {
                labResult.setRefMale(source.getRefM());
            }
            if ((resultProp = labResult.get("unit")) == null || resultProp.isEmpty()) {
                labResult.setUnit(source.get(UNIT));
            }
            labResult.set("ItemID", this.getId());
        }
    }

    public String getReferenceMale() {
        return this.getRefM();
    }

    public void setReferenceMale(String value) {
        this.setRefM(value);
    }

    public String getReferenceFemale() {
        return this.getRefW();
    }

    public void setReferenceFemale(String value) {
        this.setRefW(value);
    }

    public String getPriority() {
        return this.getPrio();
    }

    public void setPriority(String value) {
        this.setPrio(value);
    }

    public String getUnit() {
        return this.getEinheit();
    }

    public void setUnit(String value) {
        this.setEinheit(value);
    }

    public boolean isNoReferenceValueItem() {
        String[] values = this.get(true, REF_MALE, REF_FEMALE_OR_TEXT);
        return REFVAL_INCONCLUSIVE.equals(values[0]) && REFVAL_INCONCLUSIVE.equals(values[1]);
    }
}

