/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.interfaces.IOutputter;
import ch.elexis.core.data.util.BriefExternUtil;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.OutputLog;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Person;
import ch.rgw.compress.CompEx;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Optional;
import org.slf4j.LoggerFactory;

public class Brief
extends PersistentObject {
    public static final String FLD_MIME_TYPE = "MimeType";
    public static final String FLD_DATE_MODIFIED = "modifiziert";
    public static final String FLD_DATE = "Datum";
    public static final String FLD_TYPE = "Typ";
    public static final String FLD_KONSULTATION_ID = "BehandlungsID";
    public static final String FLD_DESTINATION_ID = "DestID";
    public static final String FLD_SENDER_ID = "AbsenderID";
    public static final String FLD_PATIENT_ID = "PatientID";
    public static final String FLD_SUBJECT = "Betreff";
    public static final String FLD_NOTE = "note";
    public static final String FLD_GELOESCHT = "geloescht";
    public static final String TABLENAME = "BRIEFE";
    public static final String TEMPLATE = "Vorlagen";
    public static final String AUZ = "AUF-Zeugnis";
    public static final String RP = "Rezept";
    public static final String UNKNOWN = "Allg.";
    public static final String LABOR = "Labor";
    public static final String BESTELLUNG = "Bestellung";
    public static final String RECHNUNG = "Rechnung";
    public static final String MIMETYPE_OO2 = "application/vnd.oasis.opendocument.text";
    public static final String SYS_TEMPLATE = "SYS";
    public static final String DONT_ASK_FOR_ADDRESS_STICKER = "brief_dontaskforaddressee-*-&";

    static {
        Brief.addMapping(TABLENAME, FLD_SUBJECT, FLD_PATIENT_ID, "Datum=S:D:Datum", FLD_SENDER_ID, FLD_DESTINATION_ID, FLD_KONSULTATION_ID, FLD_TYPE, "modifiziert=S:D:modifiziert", FLD_GELOESCHT, FLD_MIME_TYPE, "gedruckt=S:D:gedruckt", "Path", FLD_NOTE);
    }

    @Override
    protected String getTableName() {
        return TABLENAME;
    }

    protected Brief() {
    }

    protected Brief(String id) {
        super(id);
    }

    public static Brief load(String id) {
        return new Brief(id);
    }

    public Brief(String Betreff, TimeTool Datum, Kontakt Absender, Kontakt dest, Konsultation bh, String typ) {
        try {
            super.create(null);
            if (Datum == null) {
                Datum = new TimeTool();
            }
            String pat = "";
            String bhdl = "";
            if (bh != null) {
                bhdl = bh.getId();
                pat = bh.getFall().getPatient().getId();
            }
            String dst = "";
            if (dest != null) {
                dst = dest.getId();
            }
            String dat = Datum.toString(13);
            this.set(new String[]{FLD_SUBJECT, FLD_PATIENT_ID, FLD_DATE, FLD_SENDER_ID, FLD_DATE_MODIFIED, FLD_DESTINATION_ID, FLD_KONSULTATION_ID, FLD_TYPE, FLD_GELOESCHT}, Betreff, pat, dat, Absender == null ? "" : Absender.getId(), dat, dst, bhdl, typ, "0");
        }
        catch (Throwable ex) {
            ExHandler.handle((Throwable)ex);
        }
    }

    public void setPatient(Person k) {
        this.set(FLD_PATIENT_ID, k.getId());
    }

    public void setTyp(String typ) {
        this.set(FLD_TYPE, typ);
    }

    public String getTyp() {
        String t = this.get(FLD_TYPE);
        if (t == null) {
            return "Brief";
        }
        return t;
    }

    public boolean save(String cnt) {
        Content c = this.getOrCreateContent();
        c.save(cnt);
        this.set(FLD_DATE_MODIFIED, new TimeTool().toString(13));
        return true;
    }

    public boolean save(byte[] in, String mimetype) {
        if (in != null) {
            this.set(FLD_MIME_TYPE, mimetype);
            Content c = this.getOrCreateContent();
            c.save(in);
            this.set(FLD_DATE_MODIFIED, new TimeTool().toString(13));
            return true;
        }
        return false;
    }

    public byte[] loadBinary() {
        Content c = this.getContent().orElse(Content.DUMMY);
        if (c instanceof HeapContent) {
            ((HeapContent)c).setDBConnection(this.getDBConnection());
        }
        return c.getBinary();
    }

    public String read() {
        Content c = this.getContent().orElse(Content.DUMMY);
        return c.read();
    }

    public String getMimeType() {
        String gm = this.get(FLD_MIME_TYPE);
        if (StringTool.isNothing((Object)gm)) {
            return MIMETYPE_OO2;
        }
        return gm;
    }

    public static boolean canHandle(String mimetype) {
        return true;
    }

    @Override
    public boolean delete() {
        Konsultation kons;
        this.getContent().ifPresent(c -> {
            boolean bl = c.delete();
        });
        String konsID = this.get(FLD_KONSULTATION_ID);
        if (!StringTool.isNothing((Object)konsID) && !konsID.equals(SYS_TEMPLATE) && (kons = Konsultation.load(konsID)) != null && kons.exists() && kons.isEditable(false)) {
            kons.removeXRef("ch.elexis.text.DocXRef", this.getId());
        }
        return super.delete();
    }

    public OutputLog logOutput(IOutputter outputter) {
        return new OutputLog(this, outputter);
    }

    public boolean removeContent() {
        Content content = this.getContent().orElse(Content.DUMMY);
        return content.remove();
    }

    public String getBetreff() {
        return Brief.checkNull(this.get(FLD_SUBJECT));
    }

    public void setBetreff(String nBetreff) {
        this.set(FLD_SUBJECT, nBetreff);
    }

    public String getDatum() {
        return new TimeTool(this.get(FLD_DATE)).toString(4);
    }

    public Kontakt getAdressat() {
        String dest = this.get(FLD_DESTINATION_ID);
        return dest == null ? null : Kontakt.load(dest);
    }

    public void setAdressat(String adressatId) {
        this.set(FLD_DESTINATION_ID, adressatId);
    }

    public Person getPatient() {
        Person pat = Person.load(this.get(FLD_PATIENT_ID));
        if (pat != null && pat.state() > 1) {
            return pat;
        }
        return null;
    }

    @Override
    public String getLabel() {
        return String.valueOf(Brief.checkNull(this.get(FLD_DATE))) + " " + Brief.checkNull(this.get(FLD_SUBJECT));
    }

    private Content getOrCreateContent() {
        Optional<Content> existing = this.getContent();
        if (existing.isPresent()) {
            return existing.get();
        }
        if (BriefExternUtil.isExternFile() && this.getPatient() != null) {
            return FileContent.create(this);
        }
        return new HeapContent(this);
    }

    private Optional<Content> getContent() {
        Content ret = null;
        if (BriefExternUtil.isExternFile() && this.getPatient() != null) {
            Optional<File> file = BriefExternUtil.getExternFile(this);
            if (file.isPresent()) {
                ret = new FileContent(file.get());
            } else {
                HeapContent heap = HeapContent.load(this.getId());
                if (heap.isAvailable()) {
                    ret = heap;
                }
            }
        } else {
            HeapContent heap = HeapContent.load(this.getId());
            if (heap.isAvailable()) {
                ret = heap;
            }
        }
        return Optional.ofNullable(ret);
    }

    private static interface Content {
        public static final Content DUMMY = new Content(){

            @Override
            public byte[] getBinary() {
                return new byte[0];
            }

            @Override
            public String read() {
                return "";
            }

            @Override
            public void save(String contents) {
            }

            @Override
            public void save(byte[] contents) {
            }

            @Override
            public boolean delete() {
                return false;
            }

            @Override
            public boolean remove() {
                return false;
            }
        };

        public byte[] getBinary();

        public String read();

        public void save(String var1);

        public void save(byte[] var1);

        public boolean delete();

        public boolean remove();
    }

    private static class FileContent
    implements Content {
        private File file;

        public FileContent(File file) {
            this.file = file;
        }

        public static FileContent create(Brief brief) {
            Optional<File> created = BriefExternUtil.createExternFile(brief);
            return new FileContent(created.get());
        }

        @Override
        public byte[] getBinary() {
            try {
                return Files.toByteArray((File)this.file);
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("Could not access file", (Throwable)e);
                return new byte[0];
            }
        }

        @Override
        public String read() {
            try {
                return Files.toString((File)this.file, (Charset)Charset.defaultCharset());
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("Could not access file", (Throwable)e);
                return new String();
            }
        }

        @Override
        public void save(String contents) {
            try {
                Files.write((CharSequence)contents, (File)this.file, (Charset)Charset.defaultCharset());
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("Could not access file", (Throwable)e);
            }
        }

        @Override
        public void save(byte[] contents) {
            try {
                Files.write((byte[])contents, (File)this.file);
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("Could not access file", (Throwable)e);
            }
        }

        @Override
        public boolean delete() {
            return true;
        }

        @Override
        public boolean remove() {
            return this.file.delete();
        }
    }

    private static class HeapContent
    extends PersistentObject
    implements Content {
        private static final String CONTENTS = "inhalt";
        static final String CONTENT_TABLENAME = "HEAP";

        static {
            HeapContent.addMapping(CONTENT_TABLENAME, CONTENTS);
        }

        private HeapContent(Brief br) {
            this.create(br.getId());
        }

        private HeapContent(String id) {
            super(id);
        }

        @Override
        public byte[] getBinary() {
            System.out.println("Getting binary of " + this.getId());
            return this.getBinary(CONTENTS);
        }

        @Override
        public String read() {
            byte[] raw = this.getBinary();
            if (raw != null) {
                byte[] ret = CompEx.expand((byte[])raw);
                return StringTool.createString((byte[])ret);
            }
            return "";
        }

        @Override
        public void save(String contents) {
            byte[] comp = CompEx.Compress((String)contents, (int)Integer.MIN_VALUE);
            this.setBinary(CONTENTS, comp);
        }

        @Override
        public void save(byte[] contents) {
            System.out.println("Setting binary of " + this.getId() + " " + contents.length);
            this.setBinary(CONTENTS, contents);
        }

        @Override
        public String getLabel() {
            return this.getId();
        }

        static HeapContent load(String id) {
            return new HeapContent(id);
        }

        @Override
        protected String getTableName() {
            return CONTENT_TABLENAME;
        }

        @Override
        public boolean remove() {
            try {
                HeapContent.getConnection().exec("DELETE FROM HEAP WHERE ID=" + this.getWrappedId());
            }
            catch (Throwable ex) {
                ExHandler.handle((Throwable)ex);
                return false;
            }
            return true;
        }

        @Override
        public boolean delete() {
            HeapContent.getConnection().exec("UPDATE HEAP SET deleted='1' WHERE ID=" + this.getWrappedId());
            return true;
        }
    }
}

