/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.model.ch.BillingLaw;
import ch.elexis.data.Fall;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Messages;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.StringTool;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BillingSystem {
    private static Logger log = LoggerFactory.getLogger(BillingSystem.class);
    public static final String CFG_BILLINGLAW = "defaultBillingLaw";
    public static final String CFG_NOCOSTBEARER = "noCostBearer";
    public static final String KVG_NAME = Messages.Fall_KVG_Name;
    public static final String UVG_NAME = Messages.Fall_UVG_Name;
    public static final String MV_NAME = Messages.Fall_MV_Name;
    public static final String IV_NAME = Messages.Fall_IV_Name;
    private static final String KVG_REQUIREMENTS = Messages.Fall_KVGRequirements;
    public static final String UVG_REQUIREMENTS = Messages.Fall_UVGRequirements;
    public static final String CONST_TARMED_DRUCKER = Messages.Fall_TarmedPrinter;
    public static final String CONST_TARMED_LEISTUNG = Messages.Fall_TarmedLeistung;
    public static final String VVG_NAME = Messages.Fall_VVG_Name;
    public static final String PRIVATE_NAME = Messages.Fall_Private_Name;

    public static String getConfigurationValue(String billingSystemName, String attributeName, String defaultIfNotDefined) {
        String ret = CoreHub.globalCfg.get("billing/systems/" + billingSystemName + "/" + attributeName, defaultIfNotDefined);
        return ret;
    }

    public static void setConfigurationValue(String billingSystemName, String attributeName, String attributeValue) {
        String key = "billing/systems/" + billingSystemName;
        CoreHub.globalCfg.set(String.valueOf(key) + "/" + attributeName, attributeValue);
    }

    public static boolean isDisabled(String billingSystemName) {
        String ret = CoreHub.globalCfg.get("billing/systems/" + billingSystemName + "/disabled", "0");
        return !ret.equalsIgnoreCase("0");
    }

    public static String getUnused(String billingSystem) {
        String ret = CoreHub.globalCfg.get("billing/systems/" + billingSystem + "/unused", null);
        return ret;
    }

    public static String getOptionals(String billingSystem) {
        String ret = CoreHub.globalCfg.get("billing/systems/" + billingSystem + "/fakultativ", null);
        return ret;
    }

    public static String getRequirements(String billingSystem) {
        String ret = CoreHub.globalCfg.get("billing/systems/" + billingSystem + "/bedingungen", null);
        return ret;
    }

    public static String[] getBillingSystemConstants(String billingSystem) {
        String bc = CoreHub.globalCfg.get("billing/systems/" + billingSystem + "/constants", null);
        if (bc == null) {
            return new String[0];
        }
        return bc.split("#");
    }

    public static String getBillingSystemConstant(String billingSystem, String constant) {
        String[] c;
        String[] stringArray = c = BillingSystem.getBillingSystemConstants(billingSystem);
        int n = c.length;
        int n2 = 0;
        while (n2 < n) {
            String bc = stringArray[n2];
            String[] val = bc.split("=");
            if (val[0].equalsIgnoreCase(constant)) {
                return val[1];
            }
            ++n2;
        }
        return "";
    }

    public static void addBillingSystemConstant(String billingSystem, String constant) {
        if (constant.indexOf(61) != -1) {
            String bc = CoreHub.globalCfg.get("billing/systems/" + billingSystem + "/constants", null);
            bc = bc != null ? String.valueOf(bc) + "#" + constant : constant;
            CoreHub.globalCfg.set("billing/systems/" + billingSystem + "/constants", bc);
        }
    }

    public static void removeBillingSystemConstant(String billingSystem, String constant) {
        String key = "billing/systems/" + billingSystem + "/constants";
        String bc = CoreHub.globalCfg.get(key, null);
        if (bc != null) {
            bc = bc.replaceAll(constant, "");
            bc = bc.replaceAll("##", "#");
            bc = bc.replaceFirst("#$", "");
            bc = bc.replaceFirst("^#", "");
            CoreHub.globalCfg.set("billing/systems/" + billingSystem + "/constants", bc);
        } else {
            log.error("[" + key + "] is null");
        }
    }

    public static boolean isCostBearerDisabled(String billingSystemName) {
        return Boolean.valueOf(BillingSystem.getConfigurationValue(billingSystemName, CFG_NOCOSTBEARER, Boolean.FALSE.toString()));
    }

    public static String[] getAbrechnungsSysteme() {
        String[] ret = CoreHub.globalCfg.nodes("billing/systems");
        if (ret == null || ret.length == 0) {
            List<IConfigurationElement> list = Extensions.getExtensions("ch.elexis.core.data.RechnungsManager");
            for (IConfigurationElement ic : list) {
                if (!ic.getAttribute("name").startsWith("Tarmed")) continue;
                CoreHub.globalCfg.set("billing/systems/KVG/name", KVG_NAME);
                CoreHub.globalCfg.set("billing/systems/KVG/leistungscodes", CONST_TARMED_LEISTUNG);
                CoreHub.globalCfg.set("billing/systems/KVG/standardausgabe", CONST_TARMED_DRUCKER);
                CoreHub.globalCfg.set("billing/systems/KVG/bedingungen", KVG_REQUIREMENTS);
                BillingSystem.setConfigurationValue("KVG", CFG_BILLINGLAW, BillingLaw.KVG.name());
                CoreHub.globalCfg.set("billing/systems/UVG/name", UVG_NAME);
                CoreHub.globalCfg.set("billing/systems/UVG/leistungscodes", CONST_TARMED_LEISTUNG);
                CoreHub.globalCfg.set("billing/systems/UVG/standardausgabe", CONST_TARMED_DRUCKER);
                CoreHub.globalCfg.set("billing/systems/UVG/bedingungen", UVG_REQUIREMENTS);
                BillingSystem.setConfigurationValue("UVG", CFG_BILLINGLAW, BillingLaw.UVG.name());
                CoreHub.globalCfg.set("billing/systems/IV/name", IV_NAME);
                CoreHub.globalCfg.set("billing/systems/IV/leistungscodes", CONST_TARMED_LEISTUNG);
                CoreHub.globalCfg.set("billing/systems/IV/standardausgabe", CONST_TARMED_DRUCKER);
                CoreHub.globalCfg.set("billing/systems/IV/bedingungen", "Fallnummer:T");
                BillingSystem.setConfigurationValue("IV", CFG_BILLINGLAW, BillingLaw.IVG.name());
                CoreHub.globalCfg.set("billing/systems/MV/name", MV_NAME);
                CoreHub.globalCfg.set("billing/systems/MV/leistungscodes", CONST_TARMED_LEISTUNG);
                CoreHub.globalCfg.set("billing/systems/MV/standardausgabe", CONST_TARMED_DRUCKER);
                BillingSystem.setConfigurationValue("MV", CFG_BILLINGLAW, BillingLaw.MVG.name());
                CoreHub.globalCfg.set("billing/systems/privat/name", PRIVATE_NAME);
                CoreHub.globalCfg.set("billing/systems/privat/leistungscodes", CONST_TARMED_LEISTUNG);
                CoreHub.globalCfg.set("billing/systems/privat/standardausgabe", CONST_TARMED_DRUCKER);
                BillingSystem.setConfigurationValue("privat", CFG_BILLINGLAW, BillingLaw.VVG.name());
                BillingSystem.setConfigurationValue("privat", CFG_NOCOSTBEARER, "1");
                CoreHub.globalCfg.set("billing/systems/VVG/name", VVG_NAME);
                CoreHub.globalCfg.set("billing/systems/VVG/leistungscodes", CONST_TARMED_LEISTUNG);
                CoreHub.globalCfg.set("billing/systems/VVG/standardausgabe", CONST_TARMED_DRUCKER);
                CoreHub.globalCfg.set("billing/systems/VVG/bedingungen", KVG_REQUIREMENTS);
                BillingSystem.setConfigurationValue("VVG", CFG_BILLINGLAW, BillingLaw.VVG.name());
                PersistentObject.getConnection().exec("UPDATE VK_PREISE set typ='UVG' WHERE typ='ch.elexis.data.TarmedLeistungUVG'");
                PersistentObject.getConnection().exec("UPDATE VK_PREISE set typ='KVG' WHERE typ='ch.elexis.data.TarmedLeistungKVG'");
                PersistentObject.getConnection().exec("UPDATE VK_PREISE set typ='IV' WHERE typ='ch.elexis.data.TarmedLeistungIV'");
                PersistentObject.getConnection().exec("UPDATE VK_PREISE set typ='MV' WHERE typ='ch.elexis.data.TarmedLeistungMV'");
                BillingSystem.update();
                break;
            }
            ret = CoreHub.globalCfg.nodes("billing/systems");
            if (ret == null) {
                return new String[]{Messages.Fall_Undefined};
            }
        }
        return ret;
    }

    private static void update() {
        Query qbe = new Query(Fall.class);
        for (Fall fall : qbe.execute()) {
            if (fall.getInfoString("Kostentr\u00e4ger").equals("")) {
                fall.setInfoString("Kostentr\u00e4ger", PersistentObject.checkNull(fall.get("Kostentraeger")));
            }
            if (fall.getInfoString("Rechnungsempf\u00e4nger").equals("")) {
                fall.setInfoString("Rechnungsempf\u00e4nger", PersistentObject.checkNull(fall.get("GarantID")));
            }
            if (fall.getInfoString("Versicherungsnummer").equals("")) {
                fall.setInfoString("Versicherungsnummer", PersistentObject.checkNull(fall.get("VersNummer")));
            }
            if (fall.getInfoString("Fallnummer").equals("")) {
                fall.setInfoString("Fallnummer", PersistentObject.checkNull(fall.get("FallNummer")));
            }
            if (!fall.getInfoString("Unfallnummer").equals("")) continue;
            fall.setInfoString("Unfallnummer", PersistentObject.checkNull(fall.get("FallNummer")));
        }
    }

    public static void createAbrechnungssystem(String systemname, String codesystem, String ausgabe, String ... requirements) {
        String key = "billing/systems/" + systemname;
        CoreHub.globalCfg.set(String.valueOf(key) + "/name", systemname);
        CoreHub.globalCfg.set(String.valueOf(key) + "/leistungscodes", codesystem);
        CoreHub.globalCfg.set(String.valueOf(key) + "/standardausgabe", ausgabe);
        CoreHub.globalCfg.set(String.valueOf(key) + "/bedingungen", StringTool.join((String[])requirements, (String)";"));
    }

    public static void removeAbrechnungssystem(String systemName) {
        CoreHub.globalCfg.remove("billing/systems/" + systemName);
        CoreHub.globalCfg.flush();
    }

    public static String getCodeSystem(String billingSystem) {
        String ret = CoreHub.globalCfg.get("billing/systems/" + billingSystem + "/leistungscodes", null);
        if (ret == null) {
            BillingSystem.getAbrechnungsSysteme();
            ret = CoreHub.globalCfg.get("billing/systems/" + billingSystem + "/leistungscodes", "?");
        }
        return ret;
    }

    public static String getDefaultPrintSystem(String billingSystem) {
        String ret = CoreHub.globalCfg.get("billing/systems/" + billingSystem + "/standardausgabe", null);
        if (ret == null) {
            BillingSystem.getAbrechnungsSysteme();
            ret = CoreHub.globalCfg.get("billing/systems/" + billingSystem + "/standardausgabe", "?");
        }
        return ret;
    }

    public static String getRequirementsBySystem(String abrechnungsSystem) {
        String req = BillingSystem.getRequirements(abrechnungsSystem);
        return req == null ? "" : req;
    }

    public static void moveCostBearerFromExtinfoToDBRow(String billingSystem, String fieldName) {
        Query qre = new Query(Fall.class, "Gesetz", billingSystem);
        qre.clear(true);
        List qbe = qre.execute();
        for (Fall fall : qbe) {
            String contactId = (String)fall.getExtInfoStoredObjectByKey(fieldName);
            if (contactId == null) continue;
            log.info("Moving Fall [{}] ExtInfo key [{}] value [{}] to db table", new Object[]{fall.getId(), fieldName, contactId});
            Kontakt costBearer = Kontakt.load(contactId);
            if (costBearer.isAvailable()) {
                fall.setCostBearer(costBearer);
                fall.setExtInfoStoredObjectByKey(fieldName, null);
                continue;
            }
            log.warn("Fall [{}] could not load cost bearer [{}], skipping", (Object)fall.getId(), (Object)contactId);
        }
    }

    public static void removeExtInfoValueForAllFaelleOfBillingSystem(String billingSystem, List<String> fieldNames) {
        Query qre = new Query(Fall.class, "Gesetz", billingSystem);
        qre.clear(true);
        List qbe = qre.execute();
        for (Fall fall : qbe) {
            log.info("Removing Fall [{}] ExtInfo keys [{}]", (Object)fall.getId(), fieldNames);
            for (String fieldName : fieldNames) {
                fall.setExtInfoStoredObjectByKey(fieldName, null);
            }
        }
    }
}

