/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.util;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.LoggerFactory;

public class MultiplikatorList {
    private List<MultiplikatorInfo> list;
    private String typ;
    private String table;

    public MultiplikatorList(String table, String typ) {
        this.typ = typ;
        this.table = table;
    }

    private void fetchResultSet() {
        block15: {
            JdbcLink.Stm statement = PersistentObject.getConnection().getStatement();
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT * FROM ").append(this.table).append(" WHERE TYP=").append(JdbcLink.wrap((String)this.typ));
            ResultSet res = statement.query(sql.toString());
            try {
                try {
                    this.list = new ArrayList<MultiplikatorInfo>();
                    while (res.next()) {
                        this.list.add(new MultiplikatorInfo(res.getString("DATUM_VON"), res.getString("DATUM_BIS"), res.getString("MULTIPLIKATOR")));
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    if (statement != null) {
                        PersistentObject.getConnection().releaseStatement(statement);
                    }
                    if (res == null) break block15;
                    try {
                        res.close();
                        res = null;
                    }
                    catch (SQLException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (statement != null) {
                    PersistentObject.getConnection().releaseStatement(statement);
                }
                if (res != null) {
                    try {
                        res.close();
                        res = null;
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public void insertMultiplikator(TimeTool dateFrom, String value) {
        TimeTool dateTo = null;
        JdbcLink.Stm statement = PersistentObject.getConnection().getStatement();
        try {
            TimeTool fromDate;
            this.fetchResultSet();
            for (MultiplikatorInfo info : this.list) {
                TimeTool newToDate;
                StringBuilder sql;
                fromDate = new TimeTool(info.validFrom);
                TimeTool toDate = new TimeTool(info.validTo);
                if (dateFrom.isAfter(fromDate) && dateFrom.isBefore(toDate)) {
                    sql = new StringBuilder();
                    newToDate = new TimeTool(dateFrom);
                    newToDate.addDays(-1);
                    sql.append("UPDATE ").append(this.table).append(" SET DATUM_BIS=" + JdbcLink.wrap((String)newToDate.toString(9)) + " WHERE DATUM_VON=" + JdbcLink.wrap((String)fromDate.toString(9)) + " AND TYP=" + JdbcLink.wrap((String)this.typ));
                    statement.exec(sql.toString());
                    dateTo = new TimeTool(toDate);
                    continue;
                }
                if (!dateFrom.isEqual(fromDate)) continue;
                sql = new StringBuilder();
                newToDate = new TimeTool(dateFrom);
                newToDate.addDays(-1);
                sql.append("UPDATE ").append(this.table).append(" SET MULTIPLIKATOR=" + JdbcLink.wrap((String)value) + " WHERE DATUM_VON=" + JdbcLink.wrap((String)fromDate.toString(9)) + " AND TYP=" + JdbcLink.wrap((String)this.typ));
                statement.exec(sql.toString());
                return;
            }
            if (dateTo == null) {
                this.fetchResultSet();
                Iterator<MultiplikatorInfo> iter = this.list.iterator();
                dateTo = new TimeTool("99991231");
                while (iter.hasNext()) {
                    MultiplikatorInfo info;
                    info = iter.next();
                    fromDate = new TimeTool(info.validFrom);
                    if (!fromDate.isBefore(dateTo)) continue;
                    dateTo.set(fromDate);
                    dateTo.addDays(-1);
                }
            }
            StringBuilder sql = new StringBuilder();
            sql.append("INSERT INTO ").append(this.table).append(" (ID,DATUM_VON,DATUM_BIS,MULTIPLIKATOR,TYP) VALUES (" + JdbcLink.wrap((String)StringTool.unique((String)"prso")) + "," + JdbcLink.wrap((String)dateFrom.toString(9)) + "," + JdbcLink.wrap((String)dateTo.toString(9)) + "," + JdbcLink.wrap((String)value) + "," + JdbcLink.wrap((String)this.typ) + ");");
            statement.exec(sql.toString());
        }
        finally {
            PersistentObject.getConnection().releaseStatement(statement);
        }
    }

    public void removeMultiplikator(TimeTool dateFrom, String value) {
        PreparedStatement statement = PersistentObject.getDefaultConnection().getPreparedStatement(this.getPreparedStatementSql());
        try {
            try {
                statement.setString(1, value);
                statement.setString(2, dateFrom.toString(9));
                statement.setString(3, this.typ);
                statement.execute();
            }
            catch (SQLException e) {
                LoggerFactory.getLogger(this.getClass()).error("Could not delete multiplikator", (Throwable)e);
                PersistentObject.getDefaultConnection().releasePreparedStatement(statement);
            }
        }
        finally {
            PersistentObject.getDefaultConnection().releasePreparedStatement(statement);
        }
    }

    private String getPreparedStatementSql() {
        return "DELETE FROM " + this.table + " WHERE MULTIPLIKATOR=? AND DATUM_VON=? AND TYP=?";
    }

    public synchronized double getMultiplikator(TimeTool date) {
        this.fetchResultSet();
        for (MultiplikatorInfo info : this.list) {
            String value;
            TimeTool fromDate = new TimeTool(info.validFrom);
            TimeTool toDate = new TimeTool(info.validTo);
            if (!date.isAfterOrEqual(fromDate) || !date.isBeforeOrEqual(toDate) || (value = info.multiplikator) == null || value.isEmpty()) continue;
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException nfe) {
                ExHandler.handle((Throwable)nfe);
                return 0.0;
            }
        }
        return 1.0;
    }

    private static String[] getEigenleistungUseMultiSystems() {
        String systems = CoreHub.globalCfg.get("billing/eigenleistung/usemultiplier/systems", "");
        return systems.split("\\|\\|");
    }

    public static boolean isEigenleistungUseMulti(String system) {
        String[] systems;
        String[] stringArray = systems = MultiplikatorList.getEigenleistungUseMultiSystems();
        int n = systems.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (system.equals(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void setEigenleistungUseMulti(String system) {
        String systems = CoreHub.globalCfg.get("billing/eigenleistung/usemultiplier/systems", "");
        if (!systems.isEmpty()) {
            systems = systems.concat("||");
        }
        systems = systems.concat(system);
        CoreHub.globalCfg.set("billing/eigenleistung/usemultiplier/systems", systems);
        CoreHub.globalCfg.flush();
    }

    public static void removeEigenleistungUseMulti(String system) {
        String[] systems = MultiplikatorList.getEigenleistungUseMultiSystems();
        StringBuilder sb = new StringBuilder();
        String[] stringArray = systems;
        int n = systems.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (!system.equals(string)) {
                if (sb.length() != 0) {
                    sb.append("||");
                }
                sb.append(string);
            }
            ++n2;
        }
        CoreHub.globalCfg.set("billing/eigenleistung/usemultiplier/systems", sb.toString());
        CoreHub.globalCfg.flush();
    }

    private static class MultiplikatorInfo {
        String validFrom;
        String validTo;
        String multiplikator;

        MultiplikatorInfo(String validFrom, String validTo, String multiplikator) {
            this.validFrom = validFrom;
            this.validTo = validTo;
            this.multiplikator = multiplikator;
        }
    }
}

