/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.util;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.JdbcLink;
import java.util.HashMap;
import java.util.Optional;

public class LocalLock {
    private static HashMap<Object, LocalLock> managedLocks = new HashMap();
    private String lockString;
    private Object lockObject;

    public LocalLock(Object object) {
        this.lockObject = object;
        if (object instanceof IPersistentObject) {
            this.lockString = "local_" + ((IPersistentObject)object).storeToString() + "_lock";
        } else if (object instanceof String) {
            this.lockString = "local_" + (String)object + "_lock";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean tryLock() {
        Class<LocalLock> clazz = LocalLock.class;
        synchronized (LocalLock.class) {
            JdbcLink.Stm statement = PersistentObject.getDefaultConnection().getStatement();
            try {
                String existing = statement.queryString("SELECT wert FROM CONFIG WHERE param=" + JdbcLink.wrap((String)this.lockString));
                if (existing != null && !existing.isEmpty()) {
                    // ** MonitorExit[clazz] (shouldn't be in output)
                    return false;
                }
                StringBuilder sb = new StringBuilder();
                sb.append("INSERT INTO CONFIG (param,wert) VALUES (").append(JdbcLink.wrap((String)this.lockString)).append(",").append(JdbcLink.wrap((String)("[" + CoreHub.actUser.getLabel() + "]@" + System.currentTimeMillis()))).append(")");
                statement.exec(sb.toString());
                managedLocks.put(this.lockObject, this);
                // ** MonitorExit[clazz] (shouldn't be in output)
                return true;
            }
            finally {
                PersistentObject.getDefaultConnection().releaseStatement(statement);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasLock(String userName) {
        Class<LocalLock> clazz = LocalLock.class;
        synchronized (LocalLock.class) {
            JdbcLink.Stm statement = PersistentObject.getDefaultConnection().getStatement();
            try {
                String existing = statement.queryString("SELECT wert FROM CONFIG WHERE param=" + JdbcLink.wrap((String)this.lockString));
                if (existing != null && !existing.isEmpty()) {
                    boolean bl = existing.startsWith("[" + userName + "]@");
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return bl;
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            finally {
                PersistentObject.getDefaultConnection().releaseStatement(statement);
            }
        }
    }

    public void unlock() {
        JdbcLink.Stm statement = PersistentObject.getDefaultConnection().getStatement();
        try {
            statement.exec("DELETE FROM CONFIG WHERE param=" + JdbcLink.wrap((String)this.lockString));
            managedLocks.remove(this.lockObject);
        }
        finally {
            PersistentObject.getDefaultConnection().releaseStatement(statement);
        }
    }

    public String getLockMessage() {
        JdbcLink.Stm statement = PersistentObject.getDefaultConnection().getStatement();
        try {
            String[] parts;
            String existing = statement.queryString("SELECT wert FROM CONFIG WHERE param=" + JdbcLink.wrap((String)this.lockString));
            if (existing != null && !existing.isEmpty() && (parts = existing.split("@")).length > 0) {
                String string = parts[0];
                return string;
            }
        }
        finally {
            PersistentObject.getDefaultConnection().releaseStatement(statement);
        }
        return "?";
    }

    public long getLockCurrentMillis() {
        JdbcLink.Stm statement = PersistentObject.getDefaultConnection().getStatement();
        try {
            String[] parts;
            String existing = statement.queryString("SELECT wert FROM CONFIG WHERE param=" + JdbcLink.wrap((String)this.lockString));
            if (existing != null && !existing.isEmpty() && (parts = existing.split("@")).length > 1) {
                long l = Long.parseLong(parts[1]);
                return l;
            }
        }
        finally {
            PersistentObject.getDefaultConnection().releaseStatement(statement);
        }
        return -1L;
    }

    public static Optional<LocalLock> getManagedLock(Object object) {
        return Optional.ofNullable(managedLocks.get(object));
    }
}

