/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.util;

import ch.elexis.core.data.util.Messages;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.data.Rechnung;
import ch.rgw.tools.ExHandler;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class DatabaseCleaner {
    OutputStream osw;
    ArrayList<PersistentObject> purgeList = new ArrayList(200);
    boolean purge;

    public DatabaseCleaner(OutputStream os, boolean withPurge) {
        this.osw = os;
        this.purge = withPurge;
    }

    public void checkAll() {
        this.checkKonsultationen();
        this.checkRechnungen();
    }

    public void checkKonsultationen() {
        Query qbe = new Query(Konsultation.class);
        List list = qbe.execute();
        for (Konsultation k : list) {
            Fall fall = k.getFall();
            if (fall == null) {
                this.blame(k, Messages.DatabaseCleaner_NoCaseForKons);
                continue;
            }
            Mandant m = k.getMandant();
            if (m != null) continue;
            this.blame(k, Messages.DatabaseCleaner_NoMandatorForKons);
        }
    }

    public void checkRechnungen() {
        Query qbe = new Query(Rechnung.class);
        List list = (List)qbe.queryExpression("SELECT ID FROM RECHNUNGEN WHERE FallID is null", new LinkedList());
        for (Rechnung rn : list) {
            this.blame(rn, Messages.DatabaseCleaner_NoCaseForBill);
            Query qk = new Query(Konsultation.class);
            qk.add("RechnungsID", "=", rn.getId());
            List lk = qk.execute();
            for (Konsultation k : lk) {
                Fall f = k.getFall();
                Patient pat = f.getPatient();
                this.note(String.valueOf(Messages.DatabaseCleaner_concerning) + pat.getLabel() + ", " + f.getLabel() + ", " + k.getLabel());
            }
            if (!this.purge) continue;
            PersistentObject.getConnection().exec("UPDATE BEHANDLUNGEN SET RECHNUNGSID=NULL WHERE RECHNUNGSID=" + rn.getWrappedId());
        }
    }

    void blame(PersistentObject o, String msg2) {
        try {
            this.osw.write(("\r\n" + msg2 + ": " + o.getId() + ", " + o.getLabel() + "\r\n").getBytes("iso-8859-1"));
            this.purgeList.add(o);
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
        }
    }

    void note(String msg2) {
        try {
            this.osw.write(("  -- " + msg2 + "\r\n").getBytes("iso-8859-1"));
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
        }
    }

    void doPurge() {
        if (this.purge) {
            for (PersistentObject o : this.purgeList) {
                o.delete();
            }
        }
    }
}

