/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.util;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.events.MessageEvent;
import ch.elexis.data.Brief;
import ch.elexis.data.Person;
import ch.rgw.tools.MimeTool;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;

public class BriefExternUtil {
    public static boolean isExternFile() {
        if (CoreHub.globalCfg.get("briefe/Textmodul_Extern_File", false)) {
            boolean ret = BriefExternUtil.isValidExternPath(BriefExternUtil.getExternFilePath(), true);
            if (!ret) {
                ElexisEventDispatcher.getInstance().fireMessageEvent(new MessageEvent(MessageEvent.MessageType.WARN, "Brief Extern", "Briefe extern speichern aktiviert, aber Pfad nicht erreichbar."));
            }
            return ret;
        }
        return false;
    }

    public static Optional<File> getExternFile(Brief brief) {
        String path = BriefExternUtil.getExternFilePath();
        if (BriefExternUtil.isValidExternPath(path, true)) {
            File dir = new File(path);
            StringBuilder sb = new StringBuilder();
            Person patient = brief.getPatient();
            if (patient != null) {
                sb.append(patient.get("PatientNr")).append(File.separator).append(brief.getId()).append("." + BriefExternUtil.evaluateExtension(brief.getMimeType()));
                File ret = new File(dir, sb.toString());
                if (ret.exists() && ret.isFile()) {
                    return Optional.of(ret);
                }
                LoggerFactory.getLogger(BriefExternUtil.class).warn("File [" + ret.getAbsolutePath() + "] not valid e=" + ret.exists() + " f=" + ret.isFile());
            } else {
                LoggerFactory.getLogger(BriefExternUtil.class).warn("No patient for [" + brief.getId() + "]");
            }
        }
        return Optional.empty();
    }

    public static Optional<File> createExternFile(Brief brief) {
        String path = BriefExternUtil.getExternFilePath();
        if (BriefExternUtil.isValidExternPath(path, true)) {
            File dir = new File(path);
            Person patient = brief.getPatient();
            if (patient != null) {
                File ret;
                File patPath = new File(dir, patient.get("PatientNr"));
                if (!patPath.exists()) {
                    patPath.mkdirs();
                }
                if (!(ret = new File(patPath, String.valueOf(brief.getId()) + "." + BriefExternUtil.evaluateExtension(brief.getMimeType()))).exists()) {
                    try {
                        ret.createNewFile();
                    }
                    catch (IOException e) {
                        LoggerFactory.getLogger(BriefExternUtil.class).error("Error creating file", (Throwable)e);
                        return Optional.empty();
                    }
                }
                return Optional.of(ret);
            }
            LoggerFactory.getLogger(BriefExternUtil.class).warn("No patient for [" + brief.getId() + "]");
        }
        return Optional.empty();
    }

    public static String getExternFilePath() {
        return BriefExternUtil.getAsExternFilePath(CoreHub.globalCfg.get("briefe/Textmodul_Extern_File_Path", null));
    }

    public static String getAsExternFilePath(String path) {
        if (path != null && path.contains("[home]")) {
            path = path.replace("[home]", CoreHub.getWritableUserDir().getAbsolutePath());
            LoggerFactory.getLogger(BriefExternUtil.class).warn("Replaced [home] -> [" + CoreHub.getWritableUserDir().getAbsolutePath() + "] in extern file path result is [" + path + "]");
        }
        return path;
    }

    private static String evaluateExtension(String input) {
        String ext = MimeTool.getExtension((String)input);
        if (StringUtils.isEmpty((String)ext) && StringUtils.isEmpty((String)(ext = FilenameUtils.getExtension((String)input)))) {
            ext = input;
        }
        return ext;
    }

    public static boolean isValidExternPath(String path, boolean log) {
        if (path != null) {
            File dir = new File(path);
            if (dir.exists() && dir.isDirectory() && dir.canWrite()) {
                return true;
            }
            if (log) {
                LoggerFactory.getLogger(BriefExternUtil.class).warn("Configured path [" + path + "] not valid e=" + dir.exists() + " d=" + dir.isDirectory() + " w=" + dir.canWrite());
            }
        } else if (log) {
            LoggerFactory.getLogger(BriefExternUtil.class).warn("No path configured");
        }
        return false;
    }

    public static boolean exportToExtern(Brief brief) {
        if (brief != null && brief.getPatient() != null && BriefExternUtil.isExternFile()) {
            Optional<File> existing = BriefExternUtil.getExternFile(brief);
            if (existing.isPresent()) {
                return true;
            }
            byte[] content = brief.loadBinary();
            brief.removeContent();
            brief.save(content, brief.getMimeType());
            return true;
        }
        return false;
    }
}

