/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.ssl;

import ch.elexis.core.jdt.Nullable;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.slf4j.LoggerFactory;

public class CompositeX509KeyManager
implements X509KeyManager {
    private KeyStore defaultStore;
    private final HashMap<KeyStore, List<X509KeyManager>> keyManagers = new HashMap();

    public CompositeX509KeyManager() {
        try {
            this.defaultStore = KeyStore.getInstance(KeyStore.getDefaultType());
        }
        catch (KeyStoreException e) {
            LoggerFactory.getLogger(this.getClass()).error("Could not instantiate default store", (Throwable)e);
        }
    }

    @Override
    @Nullable
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        for (List<X509KeyManager> keyManagers : this.keyManagers.values()) {
            for (X509KeyManager x509KeyManager : keyManagers) {
                String alias = x509KeyManager.chooseClientAlias(keyType, issuers, socket);
                if (alias == null) continue;
                return alias;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        for (List<X509KeyManager> keyManagers : this.keyManagers.values()) {
            for (X509KeyManager x509KeyManager : keyManagers) {
                String alias = x509KeyManager.chooseServerAlias(keyType, issuers, socket);
                if (alias == null) continue;
                return alias;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public PrivateKey getPrivateKey(String alias) {
        for (List<X509KeyManager> keyManagers : this.keyManagers.values()) {
            for (X509KeyManager x509KeyManager : keyManagers) {
                PrivateKey privateKey = x509KeyManager.getPrivateKey(alias);
                if (privateKey == null) continue;
                return privateKey;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public X509Certificate[] getCertificateChain(String alias) {
        for (List<X509KeyManager> keyManagers : this.keyManagers.values()) {
            for (X509KeyManager x509KeyManager : keyManagers) {
                X509Certificate[] chain = x509KeyManager.getCertificateChain(alias);
                if (chain == null || chain.length <= 0) continue;
                return chain;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        ArrayList<String> ret = new ArrayList<String>();
        for (List<X509KeyManager> keyManagers : this.keyManagers.values()) {
            for (X509KeyManager x509KeyManager : keyManagers) {
                ret.addAll(Arrays.asList(x509KeyManager.getClientAliases(keyType, issuers)));
            }
        }
        return ret.toArray(new String[ret.size()]);
    }

    @Override
    @Nullable
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        ArrayList<String> ret = new ArrayList<String>();
        for (List<X509KeyManager> keyManagers : this.keyManagers.values()) {
            for (X509KeyManager x509KeyManager : keyManagers) {
                ret.addAll(Arrays.asList(x509KeyManager.getServerAliases(keyType, issuers)));
            }
        }
        return ret.toArray(new String[ret.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKeyStore(KeyStore keyStore, String keystorePass) {
        HashMap<KeyStore, List<X509KeyManager>> hashMap = this.keyManagers;
        synchronized (hashMap) {
            try {
                KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                factory.init(keyStore, keystorePass.toCharArray());
                KeyManager[] managers = factory.getKeyManagers();
                ArrayList<X509KeyManager> typedManagers = new ArrayList<X509KeyManager>();
                KeyManager[] keyManagerArray = managers;
                int n = managers.length;
                int n2 = 0;
                while (n2 < n) {
                    KeyManager keyManager = keyManagerArray[n2];
                    if (keyManager instanceof X509KeyManager) {
                        typedManagers.add((X509KeyManager)keyManager);
                    }
                    ++n2;
                }
                this.keyManagers.put(keyStore, typedManagers);
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                LoggerFactory.getLogger(this.getClass()).error("Could not add trust store", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKeyStore(KeyStore keyStore) {
        HashMap<KeyStore, List<X509KeyManager>> hashMap = this.keyManagers;
        synchronized (hashMap) {
            this.keyManagers.remove(keyStore);
        }
    }

    public void addKeyManager(X509KeyManager keyManager) {
        List<X509KeyManager> defaultManagers = this.keyManagers.get(this.defaultStore);
        if (defaultManagers == null) {
            defaultManagers = new ArrayList<X509KeyManager>();
        }
        defaultManagers.add(keyManager);
        this.keyManagers.put(this.defaultStore, defaultManagers);
    }
}

