/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.service.internal;

import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.exceptions.PersistenceException;
import ch.elexis.core.model.ICategory;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.model.ITag;
import ch.elexis.core.services.IDocumentStore;
import ch.elexis.data.Brief;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Query;
import ch.elexis.data.dto.BriefDocumentDTO;
import ch.elexis.data.dto.CategoryDocumentDTO;
import ch.rgw.tools.TimeTool;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class BriefDocumentStore
implements IDocumentStore {
    private static final String STORE_ID = "ch.elexis.data.store.brief";
    private static Logger log = LoggerFactory.getLogger(BriefDocumentStore.class);

    public String getId() {
        return STORE_ID;
    }

    public String getName() {
        return "Briefe";
    }

    public List<IDocument> getDocuments(String patientId, String authorId, ICategory category, List<ITag> tag) {
        Query query = new Query(Brief.class);
        query.add("PatientID", "=", patientId);
        if (authorId != null) {
            query.add("AbsenderID", "=", authorId);
        }
        if (category != null && category.getName() != null) {
            query.add("Typ", "=", category.getName());
        }
        List briefe = query.execute();
        ArrayList<IDocument> results = new ArrayList<IDocument>();
        for (Brief brief : briefe) {
            results.add(new BriefDocumentDTO(brief, STORE_ID));
        }
        return results;
    }

    public List<ICategory> getCategories() {
        ArrayList<ICategory> categories = new ArrayList<ICategory>();
        categories.add(new CategoryDocumentDTO("Vorlagen"));
        categories.add(new CategoryDocumentDTO("AUF-Zeugnis"));
        categories.add(new CategoryDocumentDTO("Rezept"));
        categories.add(new CategoryDocumentDTO("Allg."));
        categories.add(new CategoryDocumentDTO("Labor"));
        categories.add(new CategoryDocumentDTO("Bestellung"));
        categories.add(new CategoryDocumentDTO("Rechnung"));
        return categories;
    }

    public void removeDocument(IDocument document) {
        Brief brief = Brief.load(document.getId());
        if (brief.exists()) {
            brief.delete();
        }
    }

    public IDocument saveDocument(IDocument document) throws ElexisException {
        return this.save(document, null);
    }

    public IDocument saveDocument(IDocument document, InputStream content) throws ElexisException {
        return this.save(document, content);
    }

    private IDocument save(IDocument document, InputStream content) throws ElexisException {
        try {
            Brief brief = Brief.load(document.getId());
            if (brief.exists()) {
                String category = document.getCategory() != null ? document.getCategory().getName() : null;
                String[] fetch = new String[]{"PatientID", "AbsenderID", "note", "Betreff", "MimeType", "Typ"};
                String[] data = new String[]{document.getPatientId(), document.getAuthorId(), document.getDescription(), document.getTitle(), document.getMimeType(), category};
                brief.set(fetch, data);
            } else {
                brief = new Brief(document.getTitle(), document.getCreated() != null ? new TimeTool(document.getCreated()) : null, Kontakt.load(document.getAuthorId()), null, null, document.getCategory().getName());
                brief.set(new String[]{"PatientID", "MimeType", "note"}, document.getPatientId(), document.getMimeType(), document.getDescription());
            }
            if (content != null) {
                brief.save(IOUtils.toByteArray((InputStream)content), document.getMimeType());
            }
            BriefDocumentDTO briefDocumentDTO = new BriefDocumentDTO(brief, STORE_ID);
            return briefDocumentDTO;
        }
        catch (PersistenceException | IOException e) {
            throw new ElexisException("cannot save", e);
        }
        finally {
            if (content != null) {
                IOUtils.closeQuietly((InputStream)content);
            }
        }
    }

    public Optional<IDocument> loadDocument(String id) {
        Brief brief = Brief.load(id);
        if (brief.exists()) {
            return Optional.of(new BriefDocumentDTO(brief, STORE_ID));
        }
        return Optional.empty();
    }

    public Optional<InputStream> loadContent(IDocument document) {
        Brief brief = Brief.load(document.getId());
        if (brief.exists()) {
            byte[] contents = brief.loadBinary();
            if (contents == null) {
                contents = new byte[]{};
            }
            return Optional.of(new ByteArrayInputStream(contents));
        }
        return Optional.empty();
    }

    public boolean isAllowed(IDocumentStore.Capability restricted) {
        if (IDocumentStore.Capability.CATEGORY.equals((Object)restricted) || IDocumentStore.Capability.KEYWORDS.equals((Object)restricted)) {
            return false;
        }
        return super.isAllowed(restricted);
    }

    public IDocument createDocument(String patientId, String title, String categoryName) {
        BriefDocumentDTO briefDocumentDTO = new BriefDocumentDTO(STORE_ID);
        briefDocumentDTO.setTitle(title);
        briefDocumentDTO.setPatientId(patientId);
        CategoryDocumentDTO iCategory = categoryName != null ? new CategoryDocumentDTO(categoryName) : this.getCategoryDefault();
        briefDocumentDTO.setCategory(iCategory);
        return briefDocumentDTO;
    }

    public ICategory getCategoryDefault() {
        return new CategoryDocumentDTO("Allg.");
    }

    public Optional<IPersistentObject> getPersistenceObject(IDocument iDocument) {
        return Optional.of(Brief.load(iDocument.getId()));
    }

    public ICategory createCategory(String name) {
        throw new UnsupportedOperationException();
    }

    public void removeCategory(IDocument iDocument, String newCategory) throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public void renameCategory(ICategory category, String newCategory) {
        throw new UnsupportedOperationException();
    }
}

