/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.service;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.model.IStock;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.model.article.IArticle;
import ch.elexis.core.services.IStockService;
import ch.elexis.data.Artikel;
import ch.elexis.data.DBConnection;
import ch.elexis.data.Mandant;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.data.Stock;
import ch.elexis.data.StockEntry;
import ch.rgw.tools.ExHandler;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StockService
implements IStockService {
    private static Logger log = LoggerFactory.getLogger(StockService.class);
    private static final String PS_SUM_CURRENT = "SELECT SUM(CURRENT) FROM STOCK_ENTRY WHERE ARTICLE_ID = ? AND ARTICLE_TYPE = ? AND DELETED = '0'";
    private static final String PS_AVAIL_CURRENT = "SELECT MAX(CASE WHEN CURRENT <= 0 THEN 0 WHEN (ABS(MIN)-CURRENT) >=0 THEN 1 ELSE 2 END) FROM STOCK_ENTRY WHERE ARTICLE_ID = ? AND ARTICLE_TYPE = ? AND DELETED = '0'";
    private static final String PS_AVAIL_CURRENT_BELOW = "SELECT MAX(CASE WHEN CURRENT <= 0 THEN 0 WHEN (ABS(MIN)-CURRENT) >0 THEN 1 ELSE 2 END) FROM STOCK_ENTRY WHERE ARTICLE_ID = ? AND ARTICLE_TYPE = ? AND DELETED = '0'";

    public Integer getCumulatedStockForArticle(IArticle article) {
        Artikel art = (Artikel)article;
        DBConnection dbConnection = PersistentObject.getDefaultConnection();
        PreparedStatement ps = dbConnection.getPreparedStatement(PS_SUM_CURRENT);
        try {
            Object object;
            ps.setString(1, art.getId());
            ps.setString(2, art.getClass().getName());
            ResultSet res = ps.executeQuery();
            Integer ret = null;
            if (res.next() && (object = res.getObject(1)) != null) {
                ret = res.getInt(1);
            }
            res.close();
            Integer n = ret;
            return n;
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            return null;
        }
        finally {
            try {
                ps.close();
            }
            catch (SQLException sQLException) {}
            dbConnection.releasePreparedStatement(ps);
        }
    }

    public void performSingleDisposal(IArticle article, int count) {
        Mandant mandator = ElexisEventDispatcher.getSelectedMandator();
        this.performSingleDisposal(article, count, mandator != null ? mandator.getId() : null);
    }

    public IStatus performSingleDisposal(IArticle article, int count, String mandatorId) {
        if (article == null) {
            return new Status(4, "ch.elexis.core.data", "Article is null");
        }
        IStockEntry se = this.findPreferredStockEntryForArticle(((Artikel)article).storeToString(), mandatorId);
        if (se == null) {
            return new Status(2, "ch.elexis.core.data", "No stock entry for article found");
        }
        if (se.getStock().isCommissioningSystem()) {
            boolean performPartialOutlay;
            boolean isPartialUnitOutput;
            int sellingUnit = article.getSellingUnit();
            boolean bl = isPartialUnitOutput = sellingUnit > 0 && sellingUnit < article.getPackageUnit();
            if (isPartialUnitOutput && !(performPartialOutlay = CoreHub.globalCfg.get("inventory/machineOutlayPartialPackages", false))) {
                return Status.OK_STATUS;
            }
            return CoreHub.getStockCommissioningSystemService().performArticleOutlay(se, count, null);
        }
        LockResponse lr = CoreHub.getLocalLockService().acquireLockBlocking((IPersistentObject)((StockEntry)se), 1, (IProgressMonitor)new NullProgressMonitor());
        if (lr.isOk()) {
            int fractionUnits = se.getFractionUnits();
            int ve = article.getSellingUnit();
            int vk = article.getPackageUnit();
            if (vk == 0 && ve != 0) {
                vk = ve;
            }
            if (ve == 0 && vk != 0) {
                ve = vk;
            }
            int num = count * ve;
            int cs = se.getCurrentStock();
            if (vk == ve) {
                se.setCurrentStock(cs - count);
            } else {
                int rest = fractionUnits - num;
                while (rest < 0) {
                    rest += vk;
                    se.setCurrentStock(cs - 1);
                }
                se.setFractionUnits(rest);
            }
            CoreHub.getLocalLockService().releaseLock((IPersistentObject)((StockEntry)se));
            return Status.OK_STATUS;
        }
        return new Status(2, "ch.elexis.core.data", "Could not acquire lock");
    }

    public void performSingleReturn(IArticle article, int count) {
        Mandant mandator = ElexisEventDispatcher.getSelectedMandator();
        this.performSingleReturn(article, count, mandator != null ? mandator.getId() : null);
    }

    public IStatus performSingleReturn(IArticle article, int count, String mandatorId) {
        if (article == null) {
            return new Status(4, "ch.elexis.core.data", "Article is null");
        }
        IStockEntry se = this.findPreferredStockEntryForArticle(((Artikel)article).storeToString(), null);
        if (se == null) {
            return new Status(2, "ch.elexis.core.data", "No stock entry for article found");
        }
        if (se.getStock().isCommissioningSystem()) {
            return Status.OK_STATUS;
        }
        LockResponse lr = CoreHub.getLocalLockService().acquireLockBlocking((IPersistentObject)((StockEntry)se), 1, (IProgressMonitor)new NullProgressMonitor());
        if (lr.isOk()) {
            int fractionUnits = se.getFractionUnits();
            int ve = article.getSellingUnit();
            int vk = article.getPackageUnit();
            if (vk == 0 && ve != 0) {
                vk = ve;
            }
            if (ve == 0 && vk != 0) {
                ve = vk;
            }
            int num = count * ve;
            int cs = se.getCurrentStock();
            if (vk == ve) {
                se.setCurrentStock(cs + count);
            } else {
                int rest = fractionUnits + num;
                while (rest > vk) {
                    rest -= vk;
                    se.setCurrentStock(cs + 1);
                }
                se.setFractionUnits(rest);
            }
            CoreHub.getLocalLockService().releaseLock((IPersistentObject)((StockEntry)se));
            return Status.OK_STATUS;
        }
        return new Status(2, "ch.elexis.core.data", "Could not acquire lock");
    }

    private static boolean isTriggerStockAvailabilityOnBelow() {
        int trigger = CoreHub.globalCfg.get("inventory/order_trigger", 0);
        return trigger == 0;
    }

    public IStockService.Availability getCumulatedAvailabilityForArticle(IArticle article) {
        Artikel art = (Artikel)article;
        DBConnection dbConnection = PersistentObject.getDefaultConnection();
        PreparedStatement ps = dbConnection.getPreparedStatement(StockService.isTriggerStockAvailabilityOnBelow() ? PS_AVAIL_CURRENT_BELOW : PS_AVAIL_CURRENT);
        try {
            Object object;
            ps.setString(1, art.getId());
            ps.setString(2, art.getClass().getName());
            ResultSet res = ps.executeQuery();
            if (res.next() && (object = res.getObject(1)) != null) {
                int value = res.getInt(1);
                if (value > 1) {
                    IStockService.Availability availability = IStockService.Availability.IN_STOCK;
                    return availability;
                }
                if (value == 1) {
                    IStockService.Availability availability = IStockService.Availability.CRITICAL_STOCK;
                    return availability;
                }
                IStockService.Availability availability = IStockService.Availability.OUT_OF_STOCK;
                return availability;
            }
            res.close();
            return null;
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            return null;
        }
        finally {
            try {
                ps.close();
            }
            catch (SQLException sQLException) {}
            dbConnection.releasePreparedStatement(ps);
        }
    }

    public static IStockService.Availability determineAvailability(IStockEntry se) {
        String[] values = ((StockEntry)se).get(false, "MIN", "CURRENT");
        int min = Integer.valueOf(values[0]);
        int current = Integer.valueOf(values[1]);
        return IStockService.determineAvailability((int)current, (int)min, (boolean)StockService.isTriggerStockAvailabilityOnBelow());
    }

    public List<StockEntry> getAllStockEntries() {
        return new Query(StockEntry.class).execute();
    }

    public IStockEntry findPreferredStockEntryForArticle(String storeToString, String mandatorId) {
        List<? extends IStockEntry> entries = this.findAllStockEntriesForArticle(storeToString);
        int val = Integer.MAX_VALUE;
        IStockEntry ret = null;
        for (IStockEntry iStockEntry : entries) {
            Mandant owner;
            Stock stock = (Stock)iStockEntry.getStock();
            Integer priority = stock.getPriority();
            if (priority < val) {
                val = priority;
                ret = iStockEntry;
            }
            if (mandatorId == null || (owner = stock.getOwner()) == null || !owner.getId().equals(mandatorId)) continue;
            return iStockEntry;
        }
        return ret;
    }

    private Artikel loadArticle(String article) {
        if (article == null) {
            log.warn("performSingleReturn for null article", new Throwable("Diagnosis"));
            return null;
        }
        PersistentObject po = CoreHub.poFactory.createFromString(article);
        if (po != null && po instanceof Artikel) {
            return (Artikel)po;
        }
        return null;
    }

    public List<Stock> getAllStocks(boolean includeCommissioningSystems) {
        Query qbe = new Query(Stock.class);
        if (!includeCommissioningSystems) {
            qbe.add("DRIVER_UUID", "=", null);
        }
        qbe.orderBy(false, "PRIORITY");
        return qbe.execute();
    }

    public IStockService.Availability getArticleAvailabilityForStock(IStock stock, String article) {
        IStockEntry se = this.findStockEntryForArticleInStock(stock, article);
        return IStockService.determineAvailability((int)se.getCurrentStock(), (int)se.getMinimumStock(), (boolean)StockService.isTriggerStockAvailabilityOnBelow());
    }

    public IStockEntry findStockEntryForArticleInStock(IStock iStock, String storeToString) {
        Stock stock = (Stock)iStock;
        String[] vals = storeToString.split("::");
        Query qre = new Query(StockEntry.class);
        qre.add("STOCK", "=", stock.getId());
        qre.add("ARTICLE_TYPE", "=", vals[0]);
        qre.add("ARTICLE_ID", "=", vals[1]);
        List qbe = qre.execute();
        if (qbe.isEmpty()) {
            return null;
        }
        return (IStockEntry)qbe.get(0);
    }

    public IStockEntry storeArticleInStock(IStock stock, String article) {
        IStockEntry stockEntry = this.findStockEntryForArticleInStock((Stock)stock, article);
        if (stockEntry != null) {
            return stockEntry;
        }
        Artikel loadArticle = this.loadArticle(article);
        if (loadArticle == null) {
            return null;
        }
        StockEntry se = new StockEntry((Stock)stock, loadArticle);
        CoreHub.getLocalLockService().acquireLock((IPersistentObject)se);
        CoreHub.getLocalLockService().releaseLock((IPersistentObject)se);
        return se;
    }

    public void unstoreArticleFromStock(IStock stock, String article) {
        IStockEntry stockEntry = this.findStockEntryForArticleInStock((Stock)stock, article);
        if (stockEntry != null) {
            LockResponse lr = CoreHub.getLocalLockService().acquireLockBlocking((IPersistentObject)((StockEntry)stockEntry), 1, (IProgressMonitor)new NullProgressMonitor());
            if (lr.isOk()) {
                ((StockEntry)stockEntry).delete();
                CoreHub.getLocalLockService().releaseLock((IPersistentObject)((StockEntry)stockEntry));
            } else {
                log.warn("Could not unstore article [{}]", (Object)article);
            }
        }
    }

    public List<? extends IStockEntry> findAllStockEntriesForArticle(String storeToString) {
        String[] vals = storeToString.split("::");
        Query qre = new Query(StockEntry.class);
        qre.add("ARTICLE_TYPE", "=", vals[0]);
        qre.add("ARTICLE_ID", "=", vals[1]);
        return qre.execute();
    }

    public List<? extends IStockEntry> findAllStockEntriesForStock(IStock stock) {
        return null;
    }
}

