/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.server;

import ch.elexis.core.common.ElexisEvent;
import ch.elexis.core.data.server.ElexisServerClientConfig;
import ch.elexis.core.server.IEventService;
import com.eclipsesource.jaxrs.consumer.ConsumerFactory;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElexisServerEventService {
    private Logger log = LoggerFactory.getLogger(ElexisServerEventService.class);
    private IEventService eventService = new NoRemoteEventService();

    public void reconfigure() {
        String restUrl = System.getProperty("elexisServerUrl");
        if (restUrl != null && restUrl.length() > 0) {
            this.log.info("Operating against elexis-server instance on " + restUrl);
            this.eventService = (IEventService)ConsumerFactory.createConsumer((String)restUrl, (Configuration)new ElexisServerClientConfig(), IEventService.class);
        } else {
            this.eventService = new NoRemoteEventService();
        }
    }

    public IStatus postEvent(ElexisEvent elexisEvent) {
        if (this.eventService != null) {
            try {
                this.eventService.postEvent(elexisEvent);
                return Status.OK_STATUS;
            }
            catch (Exception e) {
                return new Status(4, "ch.elexis.core.data", e.getMessage(), (Throwable)e);
            }
        }
        return new Status(4, "ch.elexis.core.data", "No EventService available");
    }

    public boolean deliversRemoteEvents() {
        return !(this.eventService instanceof NoRemoteEventService);
    }

    private class NoRemoteEventService
    implements IEventService {
        private final Response OK = Response.ok().build();

        private NoRemoteEventService() {
        }

        public Response postEvent(ElexisEvent elexisEvent) {
            return this.OK;
        }
    }
}

