/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.extension;

import ch.elexis.core.interfaces.AbstractReferenceDataImporter;
import ch.elexis.core.jdt.NonNull;
import ch.elexis.core.jdt.Nullable;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.RegistryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceDataImporterExtensionPoint {
    private static Logger log = LoggerFactory.getLogger((String)ReferenceDataImporterExtensionPoint.class.getName());
    private static final String CLASS_PROPERTY = "class";
    private static final String ATTRIBUTE_REFDATA_ID = "referenceDataId";
    private static HashMap<String, AbstractReferenceDataImporter> importers;

    @Nullable
    public static AbstractReferenceDataImporter getReferenceDataImporterByReferenceDataId(@NonNull String refDataId) {
        if (importers == null) {
            ReferenceDataImporterExtensionPoint.initialize();
        }
        return importers.get(refDataId);
    }

    private static void initialize() {
        try {
            IConfigurationElement[] extensionPoints;
            importers = new HashMap();
            IExtensionPoint refDataExtensionPoint = RegistryFactory.getRegistry().getExtensionPoint("ch.elexis.core.data.referenceDataImporter");
            IConfigurationElement[] iConfigurationElementArray = extensionPoints = refDataExtensionPoint.getConfigurationElements();
            int n = extensionPoints.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement ePoint = iConfigurationElementArray[n2];
                Object o = ePoint.createExecutableExtension(CLASS_PROPERTY);
                String refDataId = ePoint.getAttribute(ATTRIBUTE_REFDATA_ID);
                if (o instanceof AbstractReferenceDataImporter) {
                    AbstractReferenceDataImporter importer = (AbstractReferenceDataImporter)o;
                    importers.put(refDataId, importer);
                    log.debug("Added ReferenceDataImporter for... " + refDataId);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            log.error("Exception occured trying to load ReferenceDataImporter ExtensionPoints", (Throwable)e);
        }
    }
}

