/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.extension;

import ch.elexis.core.data.extension.AbstractCoreOperationAdvisor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreOperationExtensionPoint {
    private static Logger log = LoggerFactory.getLogger((String)CoreOperationExtensionPoint.class.getName());
    private AbstractCoreOperationAdvisor coa = null;
    private static CoreOperationExtensionPoint instance = null;

    private CoreOperationExtensionPoint() {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor("ch.elexis.core.data.coreOperation");
        if (config.length != 1) {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement ic = iConfigurationElementArray[n2];
                log.error("CoreOperationExtensionPoint contribution in " + ic.getNamespaceIdentifier() + "." + ic.getName());
                ++n2;
            }
            throw new Error("Error at CoreOperationExtensionPoint initialization, not exactly one, but " + config.length + " extension point contributions found. See log file. Exiting.");
        }
        try {
            IConfigurationElement e = config[0];
            Object o = e.createExecutableExtension("advisor");
            if (o instanceof AbstractCoreOperationAdvisor) {
                this.coa = (AbstractCoreOperationAdvisor)o;
                log.debug("CoreOperationExtensionPoint found @ " + e.getContributor().getName() + ": " + o.getClass().getName());
            }
            return;
        }
        catch (CoreException ex) {
            log.error("Error at CoreOperationExtensionPoint extension initialization", (Throwable)ex);
            return;
        }
    }

    public static AbstractCoreOperationAdvisor getCoreOperationAdvisor() {
        if (instance == null) {
            instance = new CoreOperationExtensionPoint();
        }
        if (CoreOperationExtensionPoint.instance.coa == null) {
            throw new Error("Error at CoreOperationExtensionPoint initialization, no extension point found. Exiting.");
        }
        return CoreOperationExtensionPoint.instance.coa;
    }
}

