/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.events;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.data.Anwender;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;

public final class ElexisEvent
implements Comparable<ElexisEvent> {
    public static final int EVENT_CREATE = 1;
    public static final int EVENT_DELETE = 2;
    public static final int EVENT_UPDATE = 4;
    public static final int EVENT_RELOAD = 8;
    public static final int EVENT_SELECTED = 16;
    public static final int EVENT_DESELECTED = 32;
    public static final int EVENT_USER_CHANGED = 64;
    public static final int EVENT_MANDATOR_CHANGED = 128;
    public static final int EVENT_ELEXIS_STATUS = 256;
    public static final int EVENT_OPERATION_PROGRESS = 512;
    public static final int EVENT_NOTIFICATION = 1024;
    public static final int EVENT_LOCK_AQUIRED = 4096;
    public static final int EVENT_LOCK_PRERELEASE = 8192;
    public static final int EVENT_LOCK_RELEASED = 16384;
    public static final int PRIORITY_SYNC = 1;
    public static final int PRIORITY_HIGH = 1000;
    public static final int PRIORITY_NORMAL = 10000;
    private final PersistentObject obj;
    private final Object genericObject;
    private final Class<?> objClass;
    final int type;
    private final int priority;
    private final String updatedAttribute;

    public ElexisEvent(IPersistentObject o, Class<?> c, int type) {
        this((Object)o, c, type, 10000);
    }

    public ElexisEvent(IPersistentObject o, Class<?> c, int type, @Nullable String updatedAttribute) {
        this(o, c, type, 10000, updatedAttribute);
    }

    public ElexisEvent(Object genericObject, Class<?> c, int type, int priority) {
        this(genericObject, c, type, priority, null);
    }

    public ElexisEvent(Object genericObject, Class<?> c, int type, int priority, @Nullable String updatedAttribute) {
        if (genericObject instanceof PersistentObject) {
            this.obj = (PersistentObject)genericObject;
            this.genericObject = null;
        } else {
            this.genericObject = genericObject;
            this.obj = null;
        }
        this.objClass = c;
        this.type = type;
        this.priority = priority;
        this.updatedAttribute = updatedAttribute;
    }

    public PersistentObject getObject() {
        return this.obj;
    }

    public Class<?> getObjectClass() {
        if (this.objClass == null && this.obj != null) {
            return this.obj.getClass();
        }
        return this.objClass;
    }

    public Object getGenericObject() {
        return this.genericObject;
    }

    public int getType() {
        return this.type;
    }

    @Nullable
    public String getUpdatedAttribute() {
        return this.updatedAttribute;
    }

    boolean matches(ElexisEvent event) {
        if (this.getObject() != null && event.getObject() != null && !this.getObject().getId().equals(event.getObject().getId())) {
            return false;
        }
        if (this.getObjectClass() != null && event.getObjectClass() != null && !this.getObjectClass().equals(event.getObjectClass())) {
            return false;
        }
        return event.getType() == 0 || (this.type & event.getType()) != 0;
    }

    boolean isSame(ElexisEvent other) {
        if (other == null) {
            return false;
        }
        return other.obj == null ? this.obj == null && other.objClass != null && other.objClass.equals(this.objClass) && other.type == this.type : other.obj.equals(this.obj) && other.type == this.type;
    }

    public static ElexisEvent createUserEvent() {
        return new ElexisEvent(CoreHub.actUser, Anwender.class, 64);
    }

    public static ElexisEvent createPatientEvent() {
        return new ElexisEvent(ElexisEventDispatcher.getSelectedPatient(), Patient.class, 16);
    }

    @Override
    public int compareTo(ElexisEvent o) {
        return this.priority - o.priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public String toString() {
        return "ElexisEvent [obj=" + this.obj + ", genericObject=" + this.genericObject + ", objClass=" + this.objClass + ", type=" + this.type + ", priority=" + this.priority + ", updatedAttribute=" + this.updatedAttribute + "]";
    }
}

