/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.activator;

import ch.elexis.Desk;
import ch.elexis.admin.AbstractAccessControl;
import ch.elexis.admin.RoleBasedAccessControl;
import ch.elexis.core.data.activator.CoreHubHelper;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.Heartbeat;
import ch.elexis.core.data.events.PatientEventListener;
import ch.elexis.core.data.interfaces.ShutdownJob;
import ch.elexis.core.data.interfaces.events.MessageEvent;
import ch.elexis.core.data.interfaces.scripting.Interpreter;
import ch.elexis.core.data.lock.LocalLockService;
import ch.elexis.core.data.preferences.CorePreferenceInitializer;
import ch.elexis.core.data.server.ElexisServerEventService;
import ch.elexis.core.data.service.OrderService;
import ch.elexis.core.data.service.StockCommissioningSystemService;
import ch.elexis.core.data.service.StockService;
import ch.elexis.core.lock.ILocalLockService;
import ch.elexis.core.services.IOrderService;
import ch.elexis.core.services.IStockCommissioningSystemService;
import ch.elexis.data.Anwender;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.PersistentObjectFactory;
import ch.elexis.data.Query;
import ch.elexis.data.User;
import ch.rgw.io.LockFile;
import ch.rgw.io.Settings;
import ch.rgw.io.SqlSettings;
import ch.rgw.io.SysSettings;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.VersionInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;
import org.eclipse.equinox.internal.app.CommandLineArgs;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreHub
implements BundleActivator {
    public static final String PLUGIN_ID = "ch.elexis.core.data";
    public static String Version = "3.7.0.qualifier";
    public static final String APPLICATION_NAME = "Elexis Ungrad";
    static final String neededJRE = "1.8.0";
    public static final String DBVersion = "3.7.0";
    protected static Logger log = LoggerFactory.getLogger((String)CoreHub.class.getName());
    private static String LocalCfgFile = null;
    private static String elexis_version = null;
    private BundleContext context;
    public static CoreHub plugin;
    private static List<ShutdownJob> shutdownJobs;
    public static final PersistentObjectFactory poFactory;
    public static Heartbeat heart;
    static File userDir;
    public static Settings globalCfg;
    public static Settings localCfg;
    public static Settings userCfg;
    public static Settings mandantCfg;
    public static Anwender actUser;
    @Deprecated
    public static Mandant actMandant;
    private static boolean tooManyInstances;
    public static final CorePreferenceInitializer pin;
    public static final AbstractAccessControl acl;
    private static ILocalLockService localLockService;
    private static final StockService stockService;
    private static final IOrderService orderService;
    private static ElexisServerEventService elexisServerEventService;
    private static final IStockCommissioningSystemService stockCommissioningSystemService;
    private final PatientEventListener eeli_pat = new PatientEventListener();

    static {
        shutdownJobs = new LinkedList<ShutdownJob>();
        poFactory = new PersistentObjectFactory();
        pin = new CorePreferenceInitializer();
        acl = new RoleBasedAccessControl();
        stockService = new StockService();
        orderService = new OrderService();
        stockCommissioningSystemService = new StockCommissioningSystemService();
    }

    public static boolean isTooManyInstances() {
        return tooManyInstances;
    }

    public static String getBasePath() {
        return FrameworkUtil.getBundle(CoreHub.class).getEntry("/").toString();
    }

    public static File getTempDir() {
        File ret = null;
        String temp = System.getProperty("java.io.tmpdir");
        if (!StringTool.isNothing((Object)temp)) {
            ret = new File(temp);
            if (ret.exists() && ret.isDirectory()) {
                return ret;
            }
            if (ret.mkdirs()) {
                return ret;
            }
        }
        return CoreHub.getWritableUserDir();
    }

    public static File getWritableUserDir() {
        if (userDir == null) {
            String userhome = null;
            if (localCfg != null) {
                userhome = localCfg.get("elexis-userDir", null);
            }
            if (userhome == null) {
                userhome = System.getProperty("user.home");
            }
            if (StringTool.isNothing(userhome)) {
                userhome = System.getProperty("java.io.tempdir");
            }
            userDir = new File(userhome, "elexis");
        }
        if (!userDir.exists() && !userDir.mkdirs()) {
            System.err.print("fatal: could not create Userdir");
            MessageEvent.fireLoggedError("Panic exit", "could not create userdir " + userDir.getAbsolutePath());
            System.exit(-5);
        }
        return userDir;
    }

    public void start(BundleContext context) throws Exception {
        this.context = context;
        log.debug("Starting " + CoreHub.class.getName());
        plugin = this;
        localLockService = new LocalLockService();
        elexisServerEventService = new ElexisServerEventService();
        this.startUpBundle();
        this.setUserDir(userDir);
        heart = Heartbeat.getInstance();
        ElexisEventDispatcher.getInstance().addListeners(this.eeli_pat);
        Interpreter.classLoaders.add(CoreHub.class.getClassLoader());
        if (!"RunFromScratch".equals(System.getProperty("elexis-run-mode"))) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    SysSettings localCfg = (SysSettings)CoreHub.localCfg;
                    localCfg.write_xml(LocalCfgFile);
                }
            });
        }
    }

    public static String readElexisBuildVersion() {
        if (elexis_version != null) {
            return elexis_version;
        }
        Properties prop = new Properties();
        String url_name = "platform:/plugin/ch.elexis.core.data/rsc/version.properties";
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream inputStream = new URL(url_name).openConnection().getInputStream();){
                if (inputStream != null) {
                    prop.load(inputStream);
                    elexis_version = prop.getProperty("elexis.version").replace("-SNAPSHOT", "");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            elexis_version = Version;
        }
        return elexis_version;
    }

    public void stop(BundleContext context) throws Exception {
        log.debug("Stopping " + CoreHub.class.getName());
        CoreHub.getLocalLockService().releaseAllLocks();
        CoreHub.getLocalLockService().shutdown();
        CoreHub.logoffAnwender();
        PersistentObject.disconnect();
        ElexisEventDispatcher.getInstance().removeListeners(this.eeli_pat);
        ElexisEventDispatcher.getInstance().dump();
        globalCfg = null;
        heart.stop();
        plugin = null;
        this.context = null;
    }

    private void startUpBundle() {
        String[] args = CommandLineArgs.getApplicationArgs();
        String config = "default";
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.startsWith("--use-config=")) {
                String[] c = s.split("=");
                config = c[1];
            }
            ++n2;
        }
        if ("RunFromScratch".equals(System.getProperty("elexis-run-mode"))) {
            config = UUID.randomUUID().toString();
        }
        this.loadLocalCfg(config);
        userCfg = localCfg;
        mandantCfg = localCfg;
        VersionInfo vI = new VersionInfo(System.getProperty("java.version", "0.0.0"));
        log.info(String.valueOf(CoreHub.getId()) + "; Java: " + vI.version() + "\nencoding: " + System.getProperty("file.encoding"));
        if (vI.isOlder(neededJRE)) {
            MessageEvent.fireLoggedError("Invalid Java version", "Your Java version is older than 1.8.0, please update.");
        }
        log.info("Basepath: " + CoreHub.getBasePath());
        pin.initializeDefaultPreferences();
        heart = Heartbeat.getInstance();
        CoreHub.initializeLock();
    }

    private static void initializeLock() {
        int timeoutSeconds = 600;
        try {
            final LockFile lockfile = new LockFile(userDir, "elexislock", 4, 600);
            final int n = lockfile.lock();
            if (n == 0) {
                MessageEvent.fireLoggedError("Too many instances", "Too many concurrent instances of Elexis running. Check elexislock files in " + userDir);
                tooManyInstances = true;
            } else {
                tooManyInstances = false;
                Heartbeat.HeartListener lockListener = new Heartbeat.HeartListener(){
                    long timeSet;

                    @Override
                    public void heartbeat() {
                        long now = System.currentTimeMillis();
                        if (now - this.timeSet > 600L) {
                            lockfile.updateLock(n);
                            this.timeSet = now;
                        }
                    }
                };
                heart.addListener(lockListener, 3);
            }
        }
        catch (IOException ex) {
            log.error("Can not aquire lock file in " + userDir + "; " + ex.getMessage());
        }
    }

    public static String getId() {
        StringBuilder sb = new StringBuilder();
        sb.append(APPLICATION_NAME).append(" v.").append(Version).append("\n").append(CoreHubHelper.getRevision(true, plugin)).append("\n").append(System.getProperty("os.name")).append("/").append(System.getProperty("os.version")).append("/").append(System.getProperty("os.arch"));
        return sb.toString();
    }

    private void loadLocalCfg(String branch) {
        LocalCfgFile = CoreHubHelper.getWritableUserDir() + "/localCfg_" + branch + ".xml";
        String msg2 = "loadLocalCfg: Loading branch " + branch + " from " + LocalCfgFile;
        System.out.println(msg2);
        log.debug(msg2);
        SysSettings cfg = new SysSettings(0, Desk.class);
        cfg.read_xml(LocalCfgFile);
        localCfg = cfg;
    }

    public static void setMandant(Mandant newMandant) {
        if (actMandant != null && mandantCfg != null) {
            mandantCfg.flush();
        }
        mandantCfg = newMandant == null ? userCfg : CoreHub.getUserSetting(newMandant);
        actMandant = newMandant;
        ElexisEventDispatcher.getInstance().fire(new ElexisEvent(newMandant, Mandant.class, 128));
    }

    public static Settings getUserSetting(Kontakt user) {
        if ("1".equals(user.get("istAnwender"))) {
            SqlSettings settings = new SqlSettings(PersistentObject.getConnection(), "USERCONFIG", "Param", "Value", "UserID=" + user.getWrappedId());
            return settings;
        }
        return null;
    }

    public Bundle getBundle() {
        return this.context.getBundle();
    }

    public static List<Mandant> getMandantenList() {
        Query qbe = new Query(Mandant.class);
        return qbe.execute().parallelStream().filter(m -> !m.isInactive()).collect(Collectors.toList());
    }

    public static List<Anwender> getUserList() {
        Query qbe = new Query(Anwender.class);
        return qbe.execute();
    }

    public static String getCfgVariant() {
        String config = System.getProperty("config");
        return config == null ? "default" : config;
    }

    public void setUserDir(File dir) {
        userDir = dir;
        localCfg.set("elexis-userDir", dir.getAbsolutePath());
    }

    public static void addShutdownJob(ShutdownJob job) {
        if (!shutdownJobs.contains(job)) {
            shutdownJobs.add(job);
        }
    }

    public static int getSystemLogLevel() {
        return localCfg.get("ablauf/LogLevel", 2);
    }

    public static void logoffAnwender() {
        if (actUser == null) {
            return;
        }
        if (userCfg != null) {
            userCfg.flush();
        }
        CoreHub.getLocalLockService().releaseAllLocks();
        CoreHub.setMandant(null);
        heart.suspend();
        actUser = null;
        ElexisEventDispatcher.getInstance().fire(new ElexisEvent(null, Anwender.class, 64));
        ElexisEventDispatcher.getInstance().fire(new ElexisEvent(null, User.class, 32));
        userCfg = localCfg;
    }

    public static ILocalLockService getLocalLockService() {
        return localLockService;
    }

    public static StockService getStockService() {
        return stockService;
    }

    public static IStockCommissioningSystemService getStockCommissioningSystemService() {
        return stockCommissioningSystemService;
    }

    public static IOrderService getOrderService() {
        return orderService;
    }

    public static ElexisServerEventService getElexisServerEventService() {
        return elexisServerEventService;
    }
}

