/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.admin;

import ch.elexis.admin.IACLContributor;
import ch.elexis.admin.Messages;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.jdt.NonNull;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.data.Query;
import ch.elexis.data.Right;
import ch.elexis.data.Role;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACE
implements Serializable {
    private static final long serialVersionUID = 34320020090119L;
    public static final String ACE_ROOT_LITERAL = "root";
    public static final ACE ACE_ROOT = new ACE(null, "root", Messages.ACE_root);
    public static final ACE ACE_IMPLICIT = new ACE(ACE_ROOT, "implicit", Messages.ACE_implicit);
    private static Map<String, ACE> allDefinedACEs;
    private static Logger log;
    private final String name;
    private String localizedName;
    private final ACE parent;
    private List<ACE> children = new ArrayList<ACE>();

    static {
        log = LoggerFactory.getLogger(ACE.class);
    }

    private static void initAllDefinedACEs() {
        if (allDefinedACEs != null) {
            return;
        }
        List temp = ACE.getACLContributionExtensions().stream().flatMap(acl -> Arrays.asList(acl.getACL()).stream()).collect(Collectors.toList());
        allDefinedACEs = temp.stream().collect(Collectors.toMap(a -> a.getCanonicalName(), a -> a));
    }

    public static void initializeACEDefaults(boolean reset) {
        if (reset) {
            Query arq = new Query(Role.class);
            List allRoles = arq.execute();
            for (Role role : allRoles) {
                role.revokeAllRightsForRole();
            }
            Right.resetTable();
        }
        List<IACLContributor> aclContributionExtensions = ACE.getACLContributionExtensions();
        for (IACLContributor iaclContributor : aclContributionExtensions) {
            try {
                iaclContributor.initializeDefaults(CoreHub.acl);
            }
            catch (Exception e) {
                log.warn("Problem initializing defaults for [{}]", (Object)iaclContributor.getClass().getName(), (Object)e);
            }
        }
    }

    private static List<IACLContributor> getACLContributionExtensions() {
        return Extensions.getClasses("ch.elexis.core.data.ACLContribution", "ACLContributor");
    }

    public ACE(ACE parent, String name, String localizedName) {
        this.parent = parent;
        this.name = name;
        this.localizedName = localizedName;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    private void addChild(ACE ace) {
        this.children.add(ace);
    }

    public ACE(ACE parent, String name) {
        this(parent, name, name);
    }

    public String getName() {
        return this.name;
    }

    public String getLocalizedName() {
        return this.localizedName;
    }

    public ACE getParent() {
        return this.parent;
    }

    public List<ACE> getChildren(boolean deep) {
        if (deep) {
            return this.getChildrenRecursive();
        }
        return new ArrayList<ACE>(this.children);
    }

    private List<ACE> getChildrenRecursive() {
        ArrayList<ACE> ret = new ArrayList<ACE>();
        ret.add(this);
        for (ACE ace : this.children) {
            ret.addAll(ace.getChildrenRecursive());
        }
        return ret;
    }

    public void setLocalizedName(String lName) {
        this.localizedName = lName;
    }

    String getCanonicalName() {
        StringBuilder sp = new StringBuilder();
        sp.append(this.getName());
        ACE parent = this.getParent();
        while (parent != null && !parent.equals(ACE_ROOT)) {
            sp.insert(0, String.valueOf(parent.getName()) + "/");
            parent = parent.getParent();
        }
        return sp.toString();
    }

    public String getUniqueHashFromACE() {
        if (ACE_ROOT.equals(this)) {
            return ACE_ROOT_LITERAL;
        }
        int valCan = Math.abs(this.getCanonicalName().hashCode());
        int valNam = Math.abs(this.getName().hashCode());
        BigInteger valI = new BigInteger(String.valueOf(valCan) + valNam);
        return valI.toString(16);
    }

    @NonNull
    public static List<ACE> getAllDefinedACElements() {
        ACE.initAllDefinedACEs();
        return new ArrayList<ACE>(allDefinedACEs.values());
    }

    @NonNull
    public static ACE[] getAllDefinedRootACElements() {
        return (ACE[])ACE.getAllDefinedACElements().stream().filter(p -> ACE_ROOT.equals(p.getParent())).toArray(ACE[]::new);
    }

    public List<ACE> getParentChainIncludingSelf() {
        ArrayList<ACE> aces = new ArrayList<ACE>();
        aces.add(this);
        if (this.equals(ACE_ROOT)) {
            return aces;
        }
        ACE parent = this.getParent();
        while (parent != ACE_ROOT) {
            aces.add(parent);
            parent = parent.getParent();
        }
        return aces;
    }

    public String toString() {
        return String.valueOf(this.getUniqueHashFromACE()) + " " + this.getName() + " " + this.getCanonicalName();
    }

    @Nullable
    public static ACE getACEByCanonicalName(String canonicalName) {
        ACE.initAllDefinedACEs();
        return allDefinedACEs.get(canonicalName);
    }
}

