/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data.service.internal;

import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.model.ICategory;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.services.IDocumentStore;
import ch.elexis.core.types.DocumentStatus;
import ch.elexis.data.dto.BriefDocumentDTO;
import ch.elexis.data.dto.CategoryDocumentDTO;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class BriefDocumentStoreTest {
    static IDocumentStore iDocumentStore;

    @BeforeClass
    public static void beforeClass() {
        BundleContext context = FrameworkUtil.getBundle(BriefDocumentStoreTest.class).getBundleContext();
        ServiceReference reference = context.getServiceReference(IDocumentStore.class);
        iDocumentStore = (IDocumentStore)context.getService(reference);
    }

    @Test
    public void testCrudAndSearchDocuments() throws IOException, ElexisException {
        BriefDocumentDTO briefDocumentDTO = new BriefDocumentDTO("ch.elexis.data.store.brief");
        briefDocumentDTO.setPatientId("-1");
        briefDocumentDTO.setStatus(DocumentStatus.RECIVED);
        briefDocumentDTO.setDescription("Test desc");
        briefDocumentDTO.setMimeType("docx");
        briefDocumentDTO.setTitle("Test Brief");
        briefDocumentDTO.setCategory((ICategory)new CategoryDocumentDTO("Rechnung"));
        iDocumentStore.saveDocument((IDocument)briefDocumentDTO);
        Assert.assertEquals((long)0L, (long)iDocumentStore.getDocuments("WRONG ID", null, null, null).size());
        List documents = iDocumentStore.getDocuments("-1", null, null, null);
        Assert.assertEquals((long)1L, (long)documents.size());
        IDocument persistedDocument = (IDocument)documents.get(0);
        Assert.assertTrue((persistedDocument.getId() != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)"Test Brief", (Object)persistedDocument.getTitle());
        Assert.assertEquals((Object)"docx", (Object)persistedDocument.getMimeType());
        Assert.assertEquals((Object)"Test desc", (Object)persistedDocument.getDescription());
        Assert.assertEquals((Object)"Rechnung", (Object)persistedDocument.getCategory().getName());
        Assert.assertEquals((Object)DocumentStatus.NEW, (Object)persistedDocument.getStatus());
        iDocumentStore.saveDocument(persistedDocument, IOUtils.toInputStream((String)"test"));
        documents = iDocumentStore.getDocuments("-1", null, (ICategory)new CategoryDocumentDTO("Bestellung"), null);
        Assert.assertEquals((long)0L, (long)documents.size());
        documents = iDocumentStore.getDocuments("-1", null, (ICategory)new CategoryDocumentDTO("Rechnung"), null);
        Assert.assertEquals((long)1L, (long)documents.size());
        persistedDocument = (IDocument)documents.get(0);
        Assert.assertTrue((persistedDocument.getId() != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)"Test Brief", (Object)persistedDocument.getTitle());
        Optional in = iDocumentStore.loadContent(persistedDocument);
        Assert.assertTrue((boolean)in.isPresent());
        String s = IOUtils.toString((InputStream)((InputStream)in.get()));
        Assert.assertEquals((Object)"test", (Object)s);
        Assert.assertEquals((long)1L, (long)iDocumentStore.getDocuments("-1", null, null, null).size());
        iDocumentStore.removeDocument(persistedDocument);
        Assert.assertEquals((long)0L, (long)iDocumentStore.getDocuments("-1", null, null, null).size());
    }
}

