/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.types.AddressType;
import ch.elexis.data.AbstractPersistentObjectTest;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Patient;
import ch.elexis.data.ZusatzAdresse;
import ch.elexis.data.dto.ZusatzAdresseDTO;
import ch.rgw.tools.JdbcLink;
import java.util.List;
import java.util.Locale;
import junit.framework.Assert;
import org.junit.Test;

public class Test_ZusatzAdresse
extends AbstractPersistentObjectTest {
    public Test_ZusatzAdresse(JdbcLink link) {
        super(link);
    }

    @Test(expected=ElexisException.class)
    public void TestZusatzAdresseWithoutKontakt() throws ElexisException {
        ZusatzAdresseDTO zusatzAdresseDTO = new ZusatzAdresseDTO();
        zusatzAdresseDTO.setAddressType(AddressType.ATTACHMENT_FIGURE);
        zusatzAdresseDTO.setCountry("A");
        zusatzAdresseDTO.setStreet1("Teststreet 1");
        zusatzAdresseDTO.setKontaktId("1");
        zusatzAdresseDTO.setZip("1010");
        zusatzAdresseDTO.setPlace("Vienna");
        zusatzAdresseDTO.setStreet2("Teststreet 2");
        zusatzAdresseDTO.setKontaktId(null);
        ZusatzAdresse zusatzAdresse = ZusatzAdresse.load(null);
        zusatzAdresse.persistDTO(zusatzAdresseDTO);
    }

    @Test
    public void TestZusatzAdresseWithKontakt() throws ElexisException {
        Patient patient = new Patient("Mustermann", "Max", "1.1.2000", "m");
        ZusatzAdresseDTO zusatzAdresseDTO = new ZusatzAdresseDTO();
        zusatzAdresseDTO.setAddressType(AddressType.PRISON);
        zusatzAdresseDTO.setCountry("A");
        zusatzAdresseDTO.setStreet1("Teststreet 1");
        zusatzAdresseDTO.setKontaktId("1");
        zusatzAdresseDTO.setZip("1010");
        zusatzAdresseDTO.setPlace("Vienna");
        zusatzAdresseDTO.setStreet2("Teststreet 2");
        zusatzAdresseDTO.setKontaktId(patient.getId());
        ZusatzAdresse zusatzAdresse = ZusatzAdresse.load(null);
        zusatzAdresse.persistDTO(zusatzAdresseDTO);
        List zusatzAdressen = patient.getZusatzAdressen();
        Assert.assertTrue((zusatzAdressen.size() == 1 ? 1 : 0) != 0);
        ZusatzAdresse savedZusatzAdresse = (ZusatzAdresse)zusatzAdressen.get(0);
        Assert.assertEquals((String)AddressType.PRISON.getLiteral(), (String)savedZusatzAdresse.getDTO().getAddressType().getLiteral());
        if (Locale.getDefault().toString().equals("de_CH")) {
            Assert.assertTrue((boolean)savedZusatzAdresse.getLabel().startsWith("Justizanstalt"));
        } else {
            System.out.println(Locale.getDefault().toString());
        }
        if (Locale.getDefault().toString().equals("en_US")) {
            Assert.assertTrue((boolean)savedZusatzAdresse.getLabel().startsWith("prison"));
        }
        Assert.assertTrue((boolean)savedZusatzAdresse.getLabel().startsWith(Messages.AddressType_PRISON));
        Assert.assertNotNull((Object)savedZusatzAdresse.getId());
        Assert.assertEquals((String)"Teststreet 1", (String)savedZusatzAdresse.getDTO().getStreet1());
        Assert.assertEquals((String)"Teststreet 1", (String)savedZusatzAdresse.get("Strasse1"));
        Assert.assertEquals((String)savedZusatzAdresse.getId(), (String)savedZusatzAdresse.getDTO().getId());
        Assert.assertEquals((String)savedZusatzAdresse.get("Kontakt_Id"), (String)savedZusatzAdresse.getDTO().getKontaktId());
    }

    @Test
    public void TestZusatzAdresseWithoutDTOPersisting() throws ElexisException {
        Patient patient = new Patient("Mustermann", "Max", "1.1.2000", "m");
        ZusatzAdresse zusatzAdresse = new ZusatzAdresse((Kontakt)patient);
        zusatzAdresse.set(new String[]{"Strasse1", "Typ"}, new String[]{"Teststreet 2", String.valueOf(AddressType.FAMILY_FRIENDS.getValue())});
        List zusatzAdressen = patient.getZusatzAdressen();
        Assert.assertTrue((zusatzAdressen.size() == 1 ? 1 : 0) != 0);
        ZusatzAdresse savedZusatzAdresse = (ZusatzAdresse)zusatzAdressen.get(0);
        Assert.assertNotNull((Object)savedZusatzAdresse.getId());
        Assert.assertEquals((String)"Teststreet 2", (String)savedZusatzAdresse.getDTO().getStreet1());
        Assert.assertEquals((String)"Teststreet 2", (String)savedZusatzAdresse.get("Strasse1"));
        Assert.assertEquals((String)String.valueOf(AddressType.FAMILY_FRIENDS.getValue()), (String)savedZusatzAdresse.get("Typ"));
        Assert.assertEquals((String)savedZusatzAdresse.getId(), (String)savedZusatzAdresse.getDTO().getId());
        Assert.assertEquals((String)savedZusatzAdresse.get("Kontakt_Id"), (String)savedZusatzAdresse.getDTO().getKontaktId());
    }
}

