/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.data.AbstractPersistentObjectTest;
import ch.elexis.data.Artikel;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.Verrechnet;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.Money;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class Test_Verrechnet
extends AbstractPersistentObjectTest {
    private static Mandant mandant;
    private static Patient patient;
    private static Fall fall;

    public Test_Verrechnet(JdbcLink link) {
        super(link);
    }

    @BeforeClass
    public static void before() {
        mandant = new Mandant("Mandant", "Erwin", "26.07.1979", "m");
        patient = new Patient("Mustermann", "Max", "1.1.2000", "m");
        fall = patient.neuerFall(Fall.getDefaultCaseLabel(), Fall.getDefaultCaseReason(), Fall.getDefaultCaseLaw());
    }

    @Test
    public void changeAnzahlValidated() {
        Artikel art = new Artikel("TestEigenartikel", "Eigenartikel", "0815");
        art.setEKPreis(new Money(14.2));
        art.setVKPreis(new Money(20.1));
        CoreHub.setMandant((Mandant)mandant);
        Konsultation cons = new Konsultation(fall);
        cons.addLeistung((IVerrechenbar)art);
        List leistungen = cons.getLeistungen();
        Assert.assertEquals((long)1L, (long)leistungen.size());
        Verrechnet vr = (Verrechnet)leistungen.get(0);
        Assert.assertEquals((long)1L, (long)vr.getZahl());
        cons.addLeistung((IVerrechenbar)art);
        cons.addLeistung((IVerrechenbar)art);
        leistungen = cons.getLeistungen();
        Assert.assertEquals((long)1L, (long)leistungen.size());
        vr = (Verrechnet)leistungen.get(0);
        Assert.assertEquals((long)3L, (long)vr.getZahl());
        IStatus changeAnzahlValidated = vr.changeAnzahlValidated(2);
        Assert.assertTrue((boolean)changeAnzahlValidated.isOK());
        leistungen = cons.getLeistungen();
        Assert.assertEquals((long)1L, (long)leistungen.size());
        vr = (Verrechnet)leistungen.get(0);
        Assert.assertEquals((long)2L, (long)vr.getZahl());
    }

    @Test
    public void createAndEscapeChars() {
        Artikel art = new Artikel("Vorsorgeuntersuchungen gem\u00e4ss Empfehlungen {SGP}'93, im 1. Monat", "Eigenartikel", "0816");
        art.setEKPreis(new Money(14.2));
        art.setVKPreis(new Money(20.1));
        CoreHub.setMandant((Mandant)mandant);
        Konsultation cons = new Konsultation(fall);
        cons.addLeistung((IVerrechenbar)art);
        List leistungen = cons.getLeistungen();
        Assert.assertEquals((long)1L, (long)leistungen.size());
        Verrechnet vr = (Verrechnet)leistungen.get(0);
        Assert.assertEquals((long)1L, (long)vr.getZahl());
        Assert.assertEquals((Object)"Vorsorgeuntersuchungen gem\u00e4ss Empfehlungen {SGP}'93, im 1. Monat", (Object)vr.getText());
    }
}

