/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.service.StockService;
import ch.elexis.core.model.IStock;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.model.article.IArticle;
import ch.elexis.core.services.IStockService;
import ch.elexis.data.AbstractPersistentObjectTest;
import ch.elexis.data.Artikel;
import ch.elexis.data.Mandant;
import ch.elexis.data.Query;
import ch.elexis.data.Stock;
import ch.elexis.data.StockEntry;
import ch.rgw.tools.JdbcLink;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_StockService
extends AbstractPersistentObjectTest {
    private static Stock defaultStock;
    private static Stock stock_A_5_public;
    private static Stock stock_B_10_private;
    private static Mandant stock_B_10_owner;
    private static Artikel artikel_A;
    private static Artikel artikel_B;
    private static Artikel artikel_C;
    private static StockService stockService;

    static {
        stockService = CoreHub.getStockService();
    }

    public Test_StockService(JdbcLink link) {
        super(link);
    }

    @Before
    public void before() {
        Query qre = new Query(Stock.class);
        qre.add("CODE", "=", "A");
        List execute = qre.execute();
        stock_A_5_public = execute.size() > 0 ? (Stock)execute.get(0) : new Stock("A", 5);
        qre.clear();
        qre.add("CODE", "=", "PRV");
        execute = qre.execute();
        stock_B_10_private = execute.size() > 0 ? (Stock)execute.get(0) : new Stock("PRV", 10);
        stock_B_10_owner = new Mandant("Mandant", "Musterfrau", "26081950", "s");
        stock_B_10_private.setOwner(stock_B_10_owner);
        artikel_A = new Artikel("ArtikelA", "Eigenartikel");
        artikel_B = new Artikel("ArtikelB", "Eigenartikel");
        artikel_C = new Artikel("ArtikelC", "Eigenartikel");
        defaultStock = Stock.load((String)"STD");
        Assert.assertEquals((Object)"STD", (Object)defaultStock.getId());
        IStockEntry stockEntry_A = stockService.storeArticleInStock((IStock)defaultStock, artikel_A.storeToString());
        stockEntry_A.setMinimumStock(5);
        stockEntry_A.setCurrentStock(10);
        stockEntry_A.setMaximumStock(15);
        IStockEntry stockEntry_A_5 = stockService.storeArticleInStock((IStock)stock_A_5_public, artikel_A.storeToString());
        IStockEntry stockEntry_A_PRIV = stockService.storeArticleInStock((IStock)stock_B_10_private, artikel_A.storeToString());
        IStockEntry stockEntry_B = stockService.storeArticleInStock((IStock)defaultStock, artikel_B.storeToString());
        IStockEntry stockEntry_B_5 = stockService.storeArticleInStock((IStock)stock_A_5_public, artikel_B.storeToString());
    }

    @Test
    public void testCreateEditAndDeleteStock() {
        int size = stockService.getAllStocks(true).size();
        Stock stock = new Stock("TMP", 3);
        List allStocks = stockService.getAllStocks(true);
        Assert.assertEquals((long)(size + 1), (long)allStocks.size());
        int i = 0;
        while (i < allStocks.size()) {
            Stock s = (Stock)allStocks.get(i);
            if (i == 0) {
                Assert.assertEquals((Object)"STD", (Object)s.getCode());
                Assert.assertEquals((Object)"STD", (Object)s.getId());
                Assert.assertEquals((Object)0, (Object)s.getPriority());
            } else if (i == 1) {
                Assert.assertEquals((Object)3, (Object)s.getPriority());
                Assert.assertEquals((Object)"TMP", (Object)s.getCode());
            } else if (i == 2) {
                Assert.assertEquals((Object)5, (Object)s.getPriority());
                Assert.assertEquals((Object)"A", (Object)s.getCode().trim());
            } else if (i == 3) {
                Assert.assertEquals((Object)10, (Object)s.getPriority());
                Assert.assertEquals((Object)"PRV", (Object)s.getCode());
                Assert.assertEquals((Object)stock_B_10_owner.getId(), (Object)s.getOwner().getId());
            }
            ++i;
        }
        stock.delete();
        allStocks = stockService.getAllStocks(true);
        Assert.assertEquals((long)size, (long)allStocks.size());
    }

    @Test
    public void testDenyStockDeleteOnExistingStockEntries() {
        Stock stock = new Stock("TMP", 15);
        Artikel artikel = new Artikel("ArtikelC", "Eigenartikel");
        stockService.storeArticleInStock((IStock)stock, artikel.storeToString());
        stock.delete();
    }

    @Test
    public void testStoreUnstoreFindPreferredArticleInStock() {
        List a_entries = stockService.findAllStockEntriesForArticle(artikel_A.storeToString());
        Assert.assertEquals((long)3L, (long)a_entries.size());
        List b_entries = stockService.findAllStockEntriesForArticle(artikel_B.storeToString());
        Assert.assertEquals((long)2L, (long)b_entries.size());
        IStockEntry stockEntry_A_STD = stockService.findStockEntryForArticleInStock((IStock)defaultStock, artikel_A.storeToString());
        Assert.assertEquals((Object)"STD", (Object)stockEntry_A_STD.getStock().getCode());
        IStockEntry stockEntry_A_PUB = stockService.findStockEntryForArticleInStock((IStock)stock_A_5_public, artikel_A.storeToString());
        Assert.assertEquals((Object)"A", (Object)stockEntry_A_PUB.getStock().getCode().trim());
        IStockEntry stockEntry = stockService.findPreferredStockEntryForArticle(artikel_A.storeToString(), stock_B_10_owner.getId());
        Assert.assertEquals((Object)"PRV", (Object)stockEntry.getStock().getCode());
        IStockEntry stockEntry_PUB = stockService.findPreferredStockEntryForArticle(artikel_A.storeToString(), null);
        Assert.assertEquals((Object)"STD", (Object)stockEntry_PUB.getStock().getCode());
        stockService.unstoreArticleFromStock((IStock)stock_B_10_private, artikel_A.storeToString());
        IStockEntry stockEntry_unstoredPriv = stockService.findPreferredStockEntryForArticle(artikel_A.storeToString(), stock_B_10_owner.getId());
        Assert.assertEquals((Object)"STD", (Object)stockEntry_unstoredPriv.getStock().getCode());
    }

    @Test
    public void testStockAvailabilities() {
        IStockService.Availability availability_A = stockService.getCumulatedAvailabilityForArticle((IArticle)artikel_A);
        Assert.assertEquals((Object)IStockService.Availability.IN_STOCK, (Object)availability_A);
        IStockService.Availability availability_B = stockService.getCumulatedAvailabilityForArticle((IArticle)artikel_B);
        Assert.assertEquals((Object)IStockService.Availability.OUT_OF_STOCK, (Object)availability_B);
        Assert.assertEquals((Object)IStockService.Availability.OUT_OF_STOCK, (Object)stockService.getArticleAvailabilityForStock((IStock)stock_A_5_public, artikel_A.storeToString()));
        Assert.assertEquals((Object)IStockService.Availability.IN_STOCK, (Object)stockService.getArticleAvailabilityForStock((IStock)defaultStock, artikel_A.storeToString()));
        Stock stock = new Stock("TMP", 20);
        IStockEntry se = stockService.storeArticleInStock((IStock)stock, artikel_C.storeToString());
        se.setMinimumStock(5);
        se.setCurrentStock(3);
        Assert.assertEquals((Object)IStockService.Availability.CRITICAL_STOCK, (Object)stockService.getCumulatedAvailabilityForArticle((IArticle)artikel_C));
        Assert.assertEquals((Object)IStockService.Availability.CRITICAL_STOCK, (Object)stockService.getArticleAvailabilityForStock((IStock)stock, artikel_C.storeToString()));
        stock.removeFromDatabase();
    }

    @Test
    public void testPerformDisposalAndReturnOfArticle() {
        Stock stock = new Stock("TMP", 20);
        IStockEntry se = stockService.storeArticleInStock((IStock)stock, artikel_C.storeToString());
        se.setMinimumStock(15);
        se.setCurrentStock(13);
        stockService.performSingleDisposal((IArticle)artikel_C, 5);
        IStockEntry prefSE = stockService.findPreferredStockEntryForArticle(artikel_C.storeToString(), null);
        Assert.assertEquals((long)8L, (long)prefSE.getCurrentStock());
        Assert.assertEquals((long)15L, (long)prefSE.getMinimumStock());
        stockService.performSingleReturn((IArticle)artikel_C, 3);
        prefSE = stockService.findPreferredStockEntryForArticle(artikel_C.storeToString(), null);
        Assert.assertEquals((long)11L, (long)prefSE.getCurrentStock());
        Assert.assertEquals((long)15L, (long)prefSE.getMinimumStock());
        stock.removeFromDatabase();
    }

    @Test
    public void testPerformMultipleStoreOnSingleStockForArticle() {
        stockService.storeArticleInStock((IStock)defaultStock, artikel_C.storeToString());
        Assert.assertEquals((long)1L, (long)stockService.findAllStockEntriesForArticle(artikel_C.storeToString()).size());
        stockService.storeArticleInStock((IStock)defaultStock, artikel_C.storeToString());
        Assert.assertEquals((long)1L, (long)stockService.findAllStockEntriesForArticle(artikel_C.storeToString()).size());
    }

    @Test
    public void testQueryMappedExpressionNumeric() {
        Stock stock = new Stock("TST", 20);
        Artikel art = new Artikel("TestARtikel", "Eigenartikel");
        Artikel art2 = new Artikel("TestARtikel2", "Eigenartikel");
        Artikel art3 = new Artikel("TestARtikel3", "Eigenartikel");
        IStockEntry se = CoreHub.getStockService().storeArticleInStock((IStock)stock, art.storeToString());
        se.setCurrentStock(12);
        se.setMaximumStock(10);
        se.setMinimumStock(5);
        se = CoreHub.getStockService().storeArticleInStock((IStock)stock, art2.storeToString());
        se.setCurrentStock(12);
        se.setMaximumStock(12);
        se.setMinimumStock(5);
        se = CoreHub.getStockService().storeArticleInStock((IStock)stock, art3.storeToString());
        se.setCurrentStock(4);
        se.setMaximumStock(12);
        se.setMinimumStock(5);
        Query qbe = new Query(StockEntry.class);
        qbe.add("STOCK", "=", stock.getId());
        qbe.add("CURRENT", "<=", "MIN");
        List execute = qbe.execute();
        Assert.assertEquals((long)1L, (long)execute.size());
        stock.removeFromDatabase();
    }
}

