/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.data.AbstractPersistentObjectTest;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Mandant;
import ch.elexis.data.Messages;
import ch.elexis.data.Patient;
import ch.elexis.data.Rechnung;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.Money;
import org.junit.Assert;
import org.junit.Test;

public class Test_Rechnung
extends AbstractPersistentObjectTest {
    public Test_Rechnung(JdbcLink link) {
        super(link);
    }

    @Test
    public void testRemoveOpenReminders() {
        Mandant mandant = new Mandant("TestMandant", "TestMandant", "01.01.70", "w");
        Patient patient = new Patient("TestPatient", "TestPatient", "01.01.70", "w");
        Konsultation kons = patient.createFallUndKons();
        Fall fall = kons.getFall();
        CoreHub.globalCfg.set("rechnung/reminder/removeopen", true);
        Rechnung rechnung = new Rechnung("1", mandant, fall, kons.getDatum(), kons.getDatum(), new Money(10000), 4);
        rechnung.setStatus(6);
        rechnung.addZahlung(new Money(10).multiply(-1.0), Messages.Rechnung_Mahngebuehr1, null);
        Assert.assertTrue((rechnung.getStatus() == 6 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rechnung.hasReminders());
        rechnung.addZahlung(new Money(10000), "initial amount", null);
        Assert.assertTrue((rechnung.getStatus() == 16 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)rechnung.hasReminders());
        rechnung = new Rechnung("2", mandant, fall, kons.getDatum(), kons.getDatum(), new Money(10000), 4);
        rechnung.setStatus(6);
        rechnung.addZahlung(new Money(10).multiply(-1.0), Messages.Rechnung_Mahngebuehr1, null);
        Assert.assertTrue((rechnung.getStatus() == 6 ? 1 : 0) != 0);
        rechnung.setStatus(8);
        rechnung.addZahlung(new Money(10).multiply(-1.0), Messages.Rechnung_Mahngebuehr2, null);
        Assert.assertTrue((rechnung.getStatus() == 8 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rechnung.hasReminders());
        rechnung.addZahlung(new Money(5000), "partial amount", null);
        Assert.assertTrue((rechnung.getStatus() == 15 ? 1 : 0) != 0);
        rechnung.addZahlung(new Money(5000), "partial amount", null);
        Assert.assertTrue((rechnung.getStatus() == 16 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)rechnung.hasReminders());
    }

    @Test
    public void testDontRemoveOpenReminders() {
        Mandant mandant = new Mandant("TestMandant", "TestMandant", "01.01.70", "w");
        Patient patient = new Patient("TestPatient", "TestPatient", "01.01.70", "w");
        Konsultation kons = patient.createFallUndKons();
        Fall fall = kons.getFall();
        CoreHub.globalCfg.set("rechnung/reminder/removeopen", false);
        Rechnung rechnung = new Rechnung("1", mandant, fall, kons.getDatum(), kons.getDatum(), new Money(10000), 4);
        rechnung.setStatus(6);
        rechnung.addZahlung(new Money(10).multiply(-1.0), Messages.Rechnung_Mahngebuehr1, null);
        Assert.assertTrue((rechnung.getStatus() == 6 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rechnung.hasReminders());
        rechnung.addZahlung(new Money(10000), "initial amount", null);
        Assert.assertFalse((rechnung.getStatus() == 16 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)rechnung.hasReminders());
    }
}

