/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.model.IPersistentObject;
import ch.elexis.data.AbstractPersistentObjectTest;
import ch.elexis.data.Artikel;
import ch.elexis.data.Patient;
import ch.elexis.data.Prescription;
import ch.elexis.data.Rezept;
import ch.rgw.tools.JdbcLink;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class Test_Prescription
extends AbstractPersistentObjectTest {
    private List<TestItem> testItems = new ArrayList<TestItem>();
    private List<TestItem> itemsMayNotThrowExecptions = new ArrayList<TestItem>();

    public Test_Prescription(JdbcLink link) {
        super(link);
    }

    private void initializeTestItems() {
        ArrayList empty = new ArrayList();
        this.itemsMayNotThrowExecptions.add(new TestItem("bis 06.07.14: 0.5-0-0-1", Arrays.asList(Float.valueOf(0.5f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f))));
        this.itemsMayNotThrowExecptions.add(new TestItem("1 Amp 3 monatlich", empty));
        this.itemsMayNotThrowExecptions.add(new TestItem("1 MAT/72 h", Arrays.asList(Float.valueOf(1.0f))));
        this.itemsMayNotThrowExecptions.add(new TestItem("1 So", Arrays.asList(Float.valueOf(1.0f))));
        this.itemsMayNotThrowExecptions.add(new TestItem("1 1/2-0-0", Arrays.asList(Float.valueOf(1.5f))));
        this.itemsMayNotThrowExecptions.add(new TestItem("1 /3Tg", Arrays.asList(Float.valueOf(1.0f))));
        this.itemsMayNotThrowExecptions.add(new TestItem("1-0-0-0 (bis 08/15)", Arrays.asList(Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f))));
        this.itemsMayNotThrowExecptions.add(new TestItem("0-0- 1/2", Arrays.asList(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.5f))));
        this.itemsMayNotThrowExecptions.add(new TestItem("0-0- 1/4-1/2", Arrays.asList(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.25f), Float.valueOf(0.5f))));
        this.itemsMayNotThrowExecptions.add(new TestItem("0-0- 1/8", Arrays.asList(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.125f))));
        this.itemsMayNotThrowExecptions.add(new TestItem("0-0-0- 40E", Arrays.asList(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(40.0f))));
        this.testItems.add(new TestItem("1/2", Arrays.asList(Float.valueOf(0.5f))));
        this.testItems.add(new TestItem("7/8", Arrays.asList(Float.valueOf(0.875f))));
        this.testItems.add(new TestItem("~1", empty));
        this.testItems.add(new TestItem("~1/2", Arrays.asList(Float.valueOf(0.5f))));
        this.testItems.add(new TestItem("~1/2 tgl", Arrays.asList(Float.valueOf(0.5f))));
        this.testItems.add(new TestItem("1 (ev 2)", empty));
        this.testItems.add(new TestItem("-8 tgl", Arrays.asList(Float.valueOf(8.0f))));
        this.testItems.add(new TestItem("1 3-mtl", Arrays.asList(Float.valueOf(1.0f), Float.valueOf(3.0f))));
        this.testItems.add(new TestItem("1 3-tgl", Arrays.asList(Float.valueOf(1.0f), Float.valueOf(3.0f))));
        this.testItems.add(new TestItem("1 3-t\u00e4gl", Arrays.asList(Float.valueOf(1.0f), Float.valueOf(3.0f))));
        this.testItems.add(new TestItem("0.5/-/-", Arrays.asList(Float.valueOf(0.0f))));
        this.testItems.add(new TestItem("(1)-0-1", Arrays.asList(Float.valueOf(0.0f), Float.valueOf(1.0f))));
        this.testItems.add(new TestItem(".5", empty));
        this.testItems.add(new TestItem("", empty));
        this.testItems.add(new TestItem("iR od 1", empty));
        this.testItems.add(new TestItem("(Abg.Apoth", empty));
        this.testItems.add(new TestItem("(ca 5*10E)", empty));
        this.testItems.add(new TestItem("(gel)", empty));
        this.testItems.add(new TestItem("-", empty));
        this.testItems.add(new TestItem("nur nach Verordnung", empty));
        this.testItems.add(new TestItem("~6-4-2", Arrays.asList(Float.valueOf(6.0f), Float.valueOf(4.0f), Float.valueOf(2.0f))));
        this.testItems.add(new TestItem("1-1-1-0 (KoGu erhalten)", Arrays.asList(Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(0.0f))));
        this.testItems.add(new TestItem("1-0-0-0 (STOPP 8.1.14)", Arrays.asList(Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f))));
        this.testItems.add(new TestItem("1-0-0-0 jeden 2. Tag", Arrays.asList(Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f))));
        this.testItems.add(new TestItem("1-0-0-0, Sa+So 1.5-0-0", Arrays.asList(Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f))));
        this.testItems.add(new TestItem("0-0-1-0 bis INR2x therapeutisch", Arrays.asList(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f))));
        this.testItems.add(new TestItem(".5-.5-1", Arrays.asList(Float.valueOf(0.5f), Float.valueOf(0.5f), Float.valueOf(1.0f))));
        this.testItems.add(new TestItem("0-0-*-0", Arrays.asList(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f))));
        this.testItems.add(new TestItem("0 (bis 08", empty));
        this.testItems.add(new TestItem("\u00bd", Arrays.asList(Float.valueOf(0.5f))));
        this.testItems.add(new TestItem("\u00bc", Arrays.asList(Float.valueOf(0.25f))));
        this.testItems.add(new TestItem("1\u00bd", Arrays.asList(Float.valueOf(1.5f))));
        this.testItems.add(new TestItem("1", Arrays.asList(Float.valueOf(1.0f))));
        this.testItems.add(new TestItem("0", Arrays.asList(Float.valueOf(0.0f))));
        this.testItems.add(new TestItem("1-1-1-1", Arrays.asList(Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f))));
        this.testItems.add(new TestItem("0-0-0-1", Arrays.asList(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f))));
        this.testItems.add(new TestItem("\u00bd-0-0-0", Arrays.asList(Float.valueOf(0.5f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f))));
        this.testItems.add(new TestItem("\u00bc-0-0-0", Arrays.asList(Float.valueOf(0.25f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f))));
        this.testItems.add(new TestItem("1\u00bd-0-0-0", Arrays.asList(Float.valueOf(1.5f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f))));
        this.testItems.add(new TestItem("0.5-1-1-", Arrays.asList(Float.valueOf(0.5f), Float.valueOf(1.0f), Float.valueOf(1.0f))));
        this.testItems.add(new TestItem("0-0-0-1/2-1", Arrays.asList(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.5f))));
        this.testItems.add(new TestItem("0-0-0-1-2", Arrays.asList(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f))));
        this.testItems.add(new TestItem("2/0.5/0.5/0.5/0.5/2", Arrays.asList(Float.valueOf(2.0f), Float.valueOf(0.5f), Float.valueOf(0.5f), Float.valueOf(0.5f))));
        this.testItems.add(new TestItem("0-0-0-3-4", Arrays.asList(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(3.0f))));
        this.testItems.add(new TestItem("1/0.5/1/0.5/1", Arrays.asList(Float.valueOf(1.0f), Float.valueOf(0.5f), Float.valueOf(1.0f), Float.valueOf(0.5f))));
        this.testItems.add(new TestItem("0--0-1-0", Arrays.asList(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f))));
    }

    @Test
    public void testExampleDoseAsFloats() {
        ArrayList res = Prescription.getDoseAsFloats((String)"1-1-1-1");
        assert (res != null);
        Assert.assertEquals((long)4L, (long)res.size());
        List<Float> oneLiner = Arrays.asList(Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f));
        Assert.assertEquals((long)oneLiner.size(), (long)res.size());
        int j = 0;
        while (j < oneLiner.size()) {
            System.out.println("Testing " + oneLiner.get(j));
            Assert.assertEquals((Object)oneLiner.get(j), res.get(j));
            ++j;
        }
        res = Prescription.getDoseAsFloats((String)"1-0-0-0 (bis 08/15)");
        assert (res != null);
        Assert.assertEquals((long)4L, (long)res.size());
        Assert.assertEquals(Arrays.asList(Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)), (Object)res);
    }

    @Test
    public void testGetSignatureAsStringArray() {
        String[] res = Prescription.getSignatureAsStringArray((String)"1-1-1-1");
        assert (res != null);
        Assert.assertEquals((long)4L, (long)res.length);
        Assert.assertEquals((Object)"1", (Object)res[0]);
        Assert.assertFalse((boolean)res[1].isEmpty());
        res = Prescription.getSignatureAsStringArray((String)"1-0-0-0 (bis 08/15)");
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((long)4L, (long)res.length);
        Assert.assertEquals((Object)"1-0-0-0 (bis 08/15)", (Object)res[0]);
        Assert.assertTrue((boolean)res[1].isEmpty());
        res = Prescription.getSignatureAsStringArray((String)"1/2-0-0-0-0-0");
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((long)4L, (long)res.length);
        Assert.assertEquals((Object)"1/2-0-0-0-0-0", (Object)res[0]);
        Assert.assertTrue((boolean)res[1].isEmpty());
    }

    private boolean testOneDoses(TestItem item2test) {
        String test_line = item2test.getDose();
        ArrayList res = Prescription.getDoseAsFloats((String)item2test.getDose());
        List<Float> expected = item2test.getAsFloats();
        assert (res != null);
        if (expected.size() != res.size()) {
            System.out.println("Testing size: " + res.size() + " != " + expected.size() + " dose '" + item2test.getDose() + "' " + res);
            return false;
        }
        int j = 0;
        while (j < expected.size()) {
            float expect = expected.get(j).floatValue();
            if (j >= res.size()) {
                System.out.println("Testing element : " + j + " of dose: " + test_line + " failed");
                return false;
            }
            float actual = ((Float)res.get(j)).floatValue();
            if (Math.abs(expect - actual) > 0.01f) {
                System.out.println("Testing element : " + j + " of dose: " + test_line + " failed " + expect + " != " + actual);
                return false;
            }
            ++j;
        }
        return true;
    }

    @Test
    public void testDoseAsFloats() {
        int nr_failures = 0;
        int nr_successes = 0;
        this.initializeTestItems();
        System.out.println("Testing " + this.testItems.size() + " and " + this.itemsMayNotThrowExecptions.size());
        for (TestItem item2test : this.testItems) {
            if (!this.testOneDoses(item2test)) {
                ++nr_failures;
                continue;
            }
            ++nr_successes;
        }
        System.out.println("Found failures " + nr_failures + " and " + nr_successes + " nr_successes");
        Assert.assertEquals((long)0L, (long)nr_failures);
    }

    @Test
    public void testDoseThatCouldThrow() {
        int nr_failures = 0;
        int nr_successes = 0;
        this.initializeTestItems();
        for (TestItem item2test : this.itemsMayNotThrowExecptions) {
            if (!this.testOneDoses(item2test) || item2test.getAsFloats().isEmpty()) continue;
            System.out.println("itemsMayNotThrowExecptions matches expectations. Why? was: " + item2test.getDose() + " expected " + item2test.getAsFloats());
        }
        System.out.println("Found failures " + nr_failures + " and " + nr_successes + " nr_successes");
        Assert.assertEquals((long)0L, (long)nr_failures);
    }

    @Test
    public void testGetLastDisposed() {
        Artikel artikel = new Artikel("TestArtikel", "TestArtikel");
        Patient patient = new Patient("Maria", "Musterfrau", "17051966", "F");
        Prescription prescription = new Prescription(artikel, patient, "0-8-15", "blalba");
        IPersistentObject lastDisposed = prescription.getLastDisposed();
        Assert.assertNull((Object)lastDisposed);
        Rezept rezept = new Rezept(patient);
        rezept.addPrescription(prescription);
        lastDisposed = prescription.getLastDisposed();
        Assert.assertEquals((Object)rezept, (Object)lastDisposed);
    }

    private class TestItem {
        private String dose = "";
        private List<Float> asFloats = Arrays.asList(new Float[0]);

        private TestItem(String string, List<Float> asList) {
            this.setDose(string);
            this.setAsFloats(asList);
        }

        public List<Float> getAsFloats() {
            return this.asFloats;
        }

        public void setAsFloats(List<Float> asFloats) {
            this.asFloats = asFloats;
        }

        public String getDose() {
            return this.dose;
        }

        public void setDose(String dose) {
            this.dose = dose;
        }
    }
}

