/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.exceptions.PersistenceException;
import ch.elexis.core.model.ISticker;
import ch.elexis.core.model.IXid;
import ch.elexis.data.AbstractPersistentObjectTest;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Sticker;
import ch.elexis.data.Xid;
import ch.elexis.data.po.InvalidPersistentObjectImpl;
import ch.elexis.data.po.OtherJointPersistentObject;
import ch.elexis.data.po.OtherListPersistentObject;
import ch.elexis.data.po.PersistentObjectImpl;
import ch.rgw.io.Settings;
import ch.rgw.tools.JdbcLink;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class Test_PersistentObject
extends AbstractPersistentObjectTest {
    public Test_PersistentObject(JdbcLink link) {
        super(link);
        PersistentObjectImpl.initTable();
        OtherJointPersistentObject.initTable();
    }

    @Ignore(value="Needs fixing, breaks PersistentObject connection link")
    public void testConnectFail() {
        try {
            PersistentObject.connect((Settings)CoreHub.localCfg);
        }
        catch (PersistenceException persistenceException) {
            // empty catch block
        }
    }

    @Test
    public void testState() {
        PersistentObjectImpl impl = new PersistentObjectImpl(false);
        int ret = impl.state();
        Assert.assertEquals((long)0L, (long)ret);
        impl = new PersistentObjectImpl();
        ret = impl.state();
        Assert.assertEquals((long)3L, (long)ret);
        boolean delete = impl.delete();
        Assert.assertTrue((boolean)delete);
        ret = impl.state();
        Assert.assertEquals((long)2L, (long)ret);
    }

    @Test
    public void testDelete() throws InterruptedException {
        PersistentObjectImpl impl = new PersistentObjectImpl();
        long lastUpdate = impl.getLastUpdate();
        Assert.assertNotSame((Object)0L, (Object)lastUpdate);
        Assert.assertFalse((boolean)impl.getBoolean("deleted"));
        Thread.sleep(1L);
        impl.delete();
        Assert.assertTrue((boolean)impl.getBoolean("deleted"));
        Assert.assertTrue((impl.getLastUpdate() > lastUpdate ? 1 : 0) != 0);
    }

    @Test
    public void testStoreToString() {
        PersistentObjectImpl impl = new PersistentObjectImpl();
        String ret = impl.storeToString();
        Assert.assertNotNull((Object)ret);
        Assert.assertTrue((boolean)ret.startsWith(PersistentObjectImpl.class.getName()));
    }

    @Test
    public void testGet() {
        PersistentObjectImpl impl = new PersistentObjectImpl();
        String ret = impl.get("TestGet");
        Assert.assertNotNull((Object)ret);
        Assert.assertEquals((Object)"", (Object)ret);
    }

    @Test
    public void testGetFail() {
        InvalidPersistentObjectImpl impl = new InvalidPersistentObjectImpl();
        String ret = impl.get("");
        Assert.assertNotNull((Object)ret);
        Assert.assertEquals((Object)"**ERROR:**", (Object)ret);
    }

    @Test
    public void testSet() throws InterruptedException {
        PersistentObjectImpl impl = new PersistentObjectImpl();
        long lastUpdate = impl.getLastUpdate();
        Assert.assertNotSame((Object)0L, (Object)lastUpdate);
        Thread.sleep(1L);
        impl.set("Test", "Blafooo");
        Assert.assertTrue((impl.getLastUpdate() > lastUpdate ? 1 : 0) != 0);
    }

    @Test(expected=PersistenceException.class)
    public void testSetFail() {
        PersistentObjectImpl impl = new PersistentObjectImpl();
        impl.set("DOESNOTEXIST", "Nonsense");
    }

    @Test
    public void testAddRemoveToJoint() throws InterruptedException {
        PersistentObjectImpl impl = new PersistentObjectImpl();
        OtherJointPersistentObject opo = new OtherJointPersistentObject();
        long lastUpdate = impl.getLastUpdate();
        Assert.assertNotSame((Object)0L, (Object)lastUpdate);
        Thread.sleep(2L);
        int retVal = impl.addToList("OtherJoint", opo.getId(), new String[0]);
        Assert.assertNotSame((Object)0, (Object)retVal);
        Assert.assertEquals((long)1L, (long)impl.getList("OtherJoint", new String[0]).size());
        Assert.assertTrue((impl.getLastUpdate() > lastUpdate ? 1 : 0) != 0);
        Thread.sleep(2L);
        impl.removeFromList("OtherJoint", opo.getId());
        Assert.assertEquals((long)0L, (long)impl.getList("OtherJoint", new String[0]).size());
        Assert.assertTrue((impl.getLastUpdate() > lastUpdate ? 1 : 0) != 0);
    }

    @Ignore
    public void testAddRemoveToList() throws InterruptedException {
        PersistentObjectImpl impl = new PersistentObjectImpl();
        OtherListPersistentObject opo = new OtherListPersistentObject();
        long lastUpdate = impl.getLastUpdate();
        Assert.assertNotSame((Object)0L, (Object)lastUpdate);
        Thread.sleep(2L);
        int retVal = impl.addToList("OtherList", opo.getId(), new String[0]);
        Assert.assertNotSame((Object)0, (Object)retVal);
        Assert.assertEquals((long)1L, (long)impl.getList("OtherList", new String[0]).size());
        Assert.assertTrue((impl.getLastUpdate() > lastUpdate ? 1 : 0) != 0);
        Thread.sleep(2L);
        impl.removeFromList("OtherList", opo.getId());
        Assert.assertEquals((long)0L, (long)impl.getList("OtherList", new String[0]).size());
        Assert.assertTrue((impl.getLastUpdate() > lastUpdate ? 1 : 0) != 0);
    }

    @Test
    public void testTableWideLastUpdate() throws InterruptedException {
        long highestLastUpdate = PersistentObjectImpl.getHighestLastUpdate();
        Thread.sleep(1L);
        PersistentObjectImpl impl = new PersistentObjectImpl();
        long highestLastUpdate2 = PersistentObjectImpl.getHighestLastUpdate();
        Assert.assertTrue((highestLastUpdate2 > highestLastUpdate ? 1 : 0) != 0);
        Thread.sleep(1L);
        impl.delete();
        highestLastUpdate = PersistentObjectImpl.getHighestLastUpdate();
        Assert.assertTrue((highestLastUpdate > highestLastUpdate2 ? 1 : 0) != 0);
        Assert.assertEquals((long)impl.getLastUpdate(), (long)highestLastUpdate);
    }

    @Test
    public void testGetXid() {
        PersistentObjectImpl impl = new PersistentObjectImpl();
        IXid ret = impl.getXid();
        Assert.assertNotNull((Object)ret);
    }

    @Test
    public void testAddXid() {
        PersistentObjectImpl impl = new PersistentObjectImpl();
        Xid.localRegisterXIDDomain((String)"test", (String)"test", (int)1);
        boolean ret = impl.addXid("test", "addXid", false);
        Assert.assertTrue((boolean)ret);
        IXid id = impl.getXid();
        Assert.assertNotNull((Object)id);
    }

    @Test
    public void testTableExists() {
        Assert.assertTrue((boolean)PersistentObject.tableExists((String)"CONFIG"));
        Assert.assertTrue((boolean)PersistentObject.tableExists((String)"KONTAKT"));
        Assert.assertEquals((Object)false, (Object)PersistentObject.tableExists((String)"THIS_TABLE_SHOULD_NOT_EXISTS"));
    }

    @Test
    public void testCreateOrModifyTable() {
        String version = "1.0.0";
        String createTable = "CREATE TABLE Dummy(ID VARCHAR(25) primary key,lastupdate BIGINT,deleted CHAR(1) default '0',PatientID VARCHAR(25),Title      VARCHAR(50),FunFactor VARCHAR(6),BoreFactor\tVARCHAR(6),Date\t\tCHAR(8),Remarks\tTEXT,FunnyStuff BLOB);CREATE INDEX idx1 on Dummy (FunFactor);INSERT INTO Dummy (ID, Title) VALUES ('VERSION'," + JdbcLink.wrap((String)version) + ");";
        String modifyTable = "ALTER TABLE Dummy MODIFY BoreFactor VARCHAR(12);";
        PersistentObject.createOrModifyTable((String)createTable);
        PersistentObject.createOrModifyTable((String)modifyTable);
        JdbcLink.Stm statement = this.getLink().getStatement();
        statement.exec("INSERT INTO Dummy (ID, BoreFactor) VALUES ('TEST', '1234567890');");
        this.getLink().releaseStatement(statement);
    }

    @Test
    public void testAddRemoveSticker() {
        Sticker sticker = new Sticker("TestSticker", "fg", "bg");
        sticker.setClassForSticker(PersistentObject.class);
        sticker.setWert(100);
        Sticker sticker200 = new Sticker("TestSticker200", "fg", "bg");
        sticker200.setClassForSticker(PersistentObject.class);
        sticker200.setWert(200);
        PersistentObjectImpl impl = new PersistentObjectImpl();
        impl.addSticker((ISticker)sticker200);
        impl.addSticker((ISticker)sticker);
        impl.addSticker((ISticker)sticker);
        Assert.assertTrue((boolean)impl.getStickers().contains(sticker));
        Assert.assertEquals((long)200L, (long)((ISticker)impl.getStickers().get(0)).getWert());
        Assert.assertEquals((long)100L, (long)((ISticker)impl.getStickers().get(1)).getWert());
        impl.removeSticker((ISticker)sticker);
        Assert.assertFalse((boolean)impl.getStickers().contains(sticker));
    }
}

