/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.service.StockService;
import ch.elexis.core.model.IOrder;
import ch.elexis.core.model.IOrderEntry;
import ch.elexis.core.model.IStock;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.services.IOrderService;
import ch.elexis.data.AbstractPersistentObjectTest;
import ch.elexis.data.Artikel;
import ch.elexis.data.Bestellung;
import ch.elexis.data.BestellungEntry;
import ch.elexis.data.Stock;
import ch.elexis.data.StockEntry;
import ch.rgw.tools.JdbcLink;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class Test_OrderService
extends AbstractPersistentObjectTest {
    private static IOrderService orderService = CoreHub.getOrderService();
    private static Stock stock_A_5_order;
    private static Artikel artikel_A;
    private static StockEntry stockEntry;
    private static StockService stockService;

    static {
        stockService = CoreHub.getStockService();
    }

    public Test_OrderService(JdbcLink link) {
        super(link);
    }

    @BeforeClass
    public static void init() {
        stock_A_5_order = new Stock("AOD", 5);
        artikel_A = new Artikel("ArtikelAOrder", "Eigenartikel");
        stockEntry = (StockEntry)stockService.storeArticleInStock((IStock)stock_A_5_order, artikel_A.storeToString());
        stockEntry.setMinimumStock(5);
        stockEntry.setCurrentStock(10);
        stockEntry.setMaximumStock(15);
    }

    @AfterClass
    public static void afterClass() {
        stock_A_5_order.removeFromDatabase();
    }

    @Test
    public void testAddRefillForStockEntryToOrderAndFindOpenOrder() {
        Bestellung b = new Bestellung("TestBestellung", CoreHub.actUser);
        orderService.addRefillForStockEntryToOrder((IStockEntry)stockEntry, (IOrder)b);
        Assert.assertEquals((long)1L, (long)b.getEntries().size());
        Assert.assertEquals((long)5L, (long)((BestellungEntry)b.getEntries().get(0)).getCount());
        IOrderEntry ioe = orderService.findOpenOrderEntryForStockEntry((IStockEntry)stockEntry);
        Assert.assertNotNull((Object)ioe);
    }
}

