/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.types.LabItemTyp;
import ch.elexis.data.AbstractPersistentObjectTest;
import ch.elexis.data.Kontakt;
import ch.elexis.data.LabItem;
import ch.elexis.data.LabResult;
import ch.elexis.data.Organisation;
import ch.elexis.data.Patient;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.TimeTool;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_LabItem
extends AbstractPersistentObjectTest {
    private Organisation org;
    private Patient formulaPat;
    private LabResult formulaResult;
    private LabItem formulaItem;
    private static final String REF_ITEM_KUERZEL = "kuerzel";
    private static final String REF_ITEM_NAME = "testname";
    private static final String REF_ITEM_UNIT = "mg/dl";
    private static final String REF_ITEM_REFM = "0-1";
    private static final String REF_ITEM_REFW = "0-2";
    private static final String REF_ITEM_GROUP = "G gruppe";
    private LabItem currentLabItem;

    public Test_LabItem(JdbcLink link) {
        super(link);
    }

    @Before
    public void setUp() {
        this.org = new Organisation("orgname", "orgzusatz1");
        this.currentLabItem = new LabItem(REF_ITEM_KUERZEL, REF_ITEM_NAME, (Kontakt)this.org, REF_ITEM_REFM, REF_ITEM_REFW, REF_ITEM_UNIT, LabItemTyp.NUMERIC, REF_ITEM_GROUP, "0");
    }

    @After
    public void after() {
        this.currentLabItem.delete();
        this.org.delete();
    }

    @Test
    public void testGetLabItems() {
        List items = LabItem.getLabItems();
        Assert.assertEquals((long)1L, (long)items.size());
    }

    @Test
    public void testGetLabItemsSelective() {
        LabItem item = new LabItem("kuerzel1", "testname1", (Kontakt)this.org, REF_ITEM_REFM, REF_ITEM_REFW, REF_ITEM_UNIT, LabItemTyp.NUMERIC, "gruppe", "0");
        Assert.assertEquals((Object)"1", (Object)item.get("visible"));
        List items = LabItem.getLabItems((String)this.org.getId(), (String)"kuerzel1", (String)REF_ITEM_REFM, (String)REF_ITEM_REFW, (String)REF_ITEM_UNIT);
        Assert.assertEquals((long)1L, (long)items.size());
        Assert.assertEquals((Object)item.getId(), (Object)((LabItem)items.get(0)).getId());
        items = LabItem.getLabItems((String)this.org.getId(), null, (String)REF_ITEM_REFM, (String)REF_ITEM_REFW, (String)REF_ITEM_UNIT);
        Assert.assertEquals((long)2L, (long)items.size());
        items = LabItem.getLabItems((String)this.org.getId(), null, null, null, null);
        Assert.assertEquals((long)2L, (long)items.size());
        items = LabItem.getLabItems((String)this.org.getId(), (String)REF_ITEM_KUERZEL, null, null, null);
        Assert.assertEquals((long)1L, (long)items.size());
        items = LabItem.getLabItems((String)this.org.getId(), (String)"kuerzel_dummy", null, null, null);
        Assert.assertEquals((long)0L, (long)items.size());
        item.delete();
    }

    @Test
    public void testGetEinheit() {
        List items = LabItem.getLabItems();
        Assert.assertEquals((long)1L, (long)items.size());
        LabItem loc = (LabItem)items.get(0);
        Assert.assertEquals((Object)REF_ITEM_UNIT, (Object)loc.getEinheit());
    }

    @Test
    public void testSetEinheit() {
        List items = LabItem.getLabItems();
        Assert.assertEquals((long)1L, (long)items.size());
        LabItem loc = (LabItem)items.get(0);
        loc.setEinheit("l");
        Assert.assertEquals((Object)"l", (Object)loc.getEinheit());
    }

    @Test
    public void testGetGroup() {
        List items = LabItem.getLabItems();
        Assert.assertEquals((long)1L, (long)items.size());
        LabItem loc = (LabItem)items.get(0);
        Assert.assertEquals((Object)REF_ITEM_GROUP, (Object)loc.getGroup());
    }

    @Test
    public void testGetRefM() {
        List items = LabItem.getLabItems();
        Assert.assertEquals((long)1L, (long)items.size());
        LabItem loc = (LabItem)items.get(0);
        Assert.assertEquals((Object)REF_ITEM_REFM, (Object)loc.getRefM());
    }

    @Test
    public void testSetRefM() {
        List items = LabItem.getLabItems();
        Assert.assertEquals((long)1L, (long)items.size());
        LabItem loc = (LabItem)items.get(0);
        loc.setRefM("1-2");
        Assert.assertEquals((Object)"1-2", (Object)loc.getRefM());
    }

    @Test
    public void testGetRefW() {
        List items = LabItem.getLabItems();
        Assert.assertEquals((long)1L, (long)items.size());
        LabItem loc = (LabItem)items.get(0);
        Assert.assertEquals((Object)REF_ITEM_REFW, (Object)loc.getRefW());
    }

    @Test
    public void testSetRefW() {
        List items = LabItem.getLabItems();
        Assert.assertEquals((long)1L, (long)items.size());
        LabItem loc = (LabItem)items.get(0);
        loc.setRefW("1-2");
        Assert.assertEquals((Object)"1-2", (Object)loc.getRefW());
    }

    @Test
    public void testGetLabor() {
        List items = LabItem.getLabItems();
        Assert.assertEquals((long)1L, (long)items.size());
        LabItem loc = (LabItem)items.get(0);
        Assert.assertEquals((Object)this.org, (Object)loc.getLabor());
    }

    @Test
    public void testGetLabel() {
        List items = LabItem.getLabItems();
        Assert.assertEquals((long)1L, (long)items.size());
        LabItem loc = (LabItem)items.get(0);
        Assert.assertNotNull((Object)loc.getLabel());
    }

    @Test
    public void testGetShortLabel() {
        List items = LabItem.getLabItems();
        Assert.assertEquals((long)1L, (long)items.size());
        LabItem loc = (LabItem)items.get(0);
        Assert.assertNotNull((Object)loc.getShortLabel());
    }

    @Test
    public void testGetTyp() {
        List items = LabItem.getLabItems();
        Assert.assertEquals((long)1L, (long)items.size());
        LabItem loc = (LabItem)items.get(0);
        Assert.assertEquals((Object)LabItemTyp.NUMERIC, (Object)loc.getTyp());
    }

    public void testSetFormula() {
        this.createFormulaEnv();
        Assert.assertEquals((Object)"G_1*2", (Object)this.formulaItem.getFormula());
    }

    public void testEvaluate() {
        this.createFormulaEnv();
        try {
            this.formulaItem.evaluate(this.formulaPat, new TimeTool("01.01.00"));
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ElexisException e) {
            Assert.fail();
        }
    }

    private void createFormulaEnv() {
        LabItem item = new LabItem("kuerzel1", "testname1", (Kontakt)this.org, REF_ITEM_REFM, REF_ITEM_REFW, REF_ITEM_UNIT, LabItemTyp.NUMERIC, REF_ITEM_GROUP, "1");
        this.formulaItem = new LabItem("formula", "formulatest", (Kontakt)this.org, REF_ITEM_REFW, "0-4", REF_ITEM_UNIT, LabItemTyp.FORMULA, REF_ITEM_GROUP, "2");
        this.formulaPat = new Patient("testName", "testVorname", "01.01.79", "m");
        this.formulaResult = new LabResult(this.formulaPat, new TimeTool("01.01.00"), item, "0.5", "comment");
        this.formulaItem.setFormula("G_1*2");
    }
}

