/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.model.IDiagnose;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.model.ch.BillingLaw;
import ch.elexis.data.AbstractPersistentObjectTest;
import ch.elexis.data.Fall;
import ch.elexis.data.FreeTextDiagnose;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.User;
import ch.rgw.tools.JdbcLink;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test_Konsultation
extends AbstractPersistentObjectTest {
    private static Patient pat;
    private static Fall fall;
    private static Konsultation kons;

    public Test_Konsultation(JdbcLink link) {
        super(link);
    }

    @Before
    public void before() {
        User user = User.load((String)this.testUserName);
        ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent((IPersistentObject)user, User.class, 16)});
        Mandant m = new Mandant("Mandant", "Erwin", "26.07.1979", "m");
        CoreHub.setMandant((Mandant)m);
        pat = new Patient("Name", "Vorname", "26.8.2011", "m");
        fall = new Fall(pat.getId(), "Bezeichnung", "Grund", "KVG");
        Assert.assertEquals((Object)BillingLaw.KVG, (Object)fall.getConfiguredBillingSystemLaw());
        kons = new Konsultation(fall);
        FreeTextDiagnose.checkInitTable();
    }

    @After
    public void after() {
        kons.delete();
        fall.delete();
        pat.delete();
    }

    @Test
    public void testConsultationCreation() {
        FreeTextDiagnose ftd = new FreeTextDiagnose("TextDefault", true);
        CoreHub.userCfg.set("fall/std_diagnose", ftd.storeToString());
        Konsultation kons = new Konsultation(fall);
        Assert.assertEquals((long)1L, (long)kons.getDiagnosen().size());
        Assert.assertEquals((Object)ftd.getId(), (Object)((IDiagnose)kons.getDiagnosen().get(0)).getId());
        CoreHub.userCfg.set("fall/std_diagnose", "");
    }

    @Test
    public void testConsultationOrderingDateTime() throws InterruptedException {
        Konsultation kons = new Konsultation(fall);
        Thread.sleep(1050L);
        Konsultation kons2 = new Konsultation(fall);
        Assert.assertTrue((boolean)kons2.getDateTime().isAfter(kons.getDateTime()));
        Assert.assertEquals((long)1L, (long)kons2.compareTo(kons));
    }

    @Test
    public void testDiagnosisCreation() {
        long currentTimeMillis = System.currentTimeMillis();
        FreeTextDiagnose ftd = new FreeTextDiagnose("Text", true);
        kons.addDiagnose((IDiagnose)ftd);
        kons.addDiagnose((IDiagnose)ftd);
        Assert.assertEquals((long)1L, (long)kons.getDiagnosen().size());
        String count = ftd.getDBConnection().queryString("SELECT COUNT(*) FROM DIAGNOSEN WHERE KLASSE=" + JdbcLink.wrap((String)ftd.getClass().getName()) + " AND DG_CODE=" + JdbcLink.wrap((String)ftd.getCode()));
        Assert.assertEquals((Object)Integer.toString(1), (Object)count);
        String lastUpdateSet = ftd.getDBConnection().queryString("SELECT LASTUPDATE FROM DIAGNOSEN WHERE KLASSE=" + JdbcLink.wrap((String)ftd.getClass().getName()) + " AND DG_CODE=" + JdbcLink.wrap((String)ftd.getCode()));
        Assert.assertTrue((currentTimeMillis <= Long.valueOf(lastUpdateSet) ? 1 : 0) != 0);
        kons.removeDiagnose((IDiagnose)ftd);
        Assert.assertEquals((long)0L, (long)kons.getDiagnosen().size());
    }
}

