/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.admin;

import ch.elexis.admin.ACE;
import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.admin.RoleBasedAccessControl;
import ch.elexis.admin.RoleBasedAccessControlTestACLContribution;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.data.AbstractPersistentObjectTest;
import ch.elexis.data.Anwender;
import ch.elexis.data.Query;
import ch.elexis.data.Right;
import ch.elexis.data.Role;
import ch.elexis.data.User;
import ch.rgw.tools.JdbcLink;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RoleBasedAccessControlTest
extends AbstractPersistentObjectTest {
    private User user;

    public RoleBasedAccessControlTest(JdbcLink link) {
        super(link);
    }

    @Before
    public void before() throws Exception {
        this.user = (User)ElexisEventDispatcher.getSelected(User.class);
        Assert.assertNotNull((Object)this.user);
    }

    @Test
    public void testInitialState() {
        User user = User.load((String)"Administrator");
        Assert.assertNotNull((String)"User Administrator is null", (Object)user);
        Anwender assignedContact = user.getAssignedContact();
        Assert.assertNotNull((String)"No contact assoaciated to user administrator", (Object)assignedContact);
        boolean queryRightForUser = CoreHub.acl.request(user, AccessControlDefaults.AC_LOGIN);
        Assert.assertTrue((String)"Administrator is denied login", (boolean)queryRightForUser);
        List rights = new Query(Right.class).execute();
        System.out.println("Rights set: " + rights.stream().map(r -> r.getLabel()).collect(Collectors.joining(",")));
        Assert.assertTrue((rights.size() >= 40 ? 1 : 0) != 0);
        List roles = new Query(Role.class).execute();
        Assert.assertEquals((long)8L, (long)roles.size());
        Role ur = Role.load((String)"user");
        ACE[] assignedUserRights = ur.getAssignedAccessRights();
        Assert.assertEquals((long)55L, (long)assignedUserRights.length);
    }

    @Test
    public void testUserAddWithOKRight() {
        Role ur = Role.load((String)"user");
        Assert.assertNotNull((Object)ur);
        List assignedRoles = this.user.getAssignedRoles();
        boolean userHasRole = false;
        for (Role role : assignedRoles) {
            if (!ur.getId().equals(role.getId())) continue;
            userHasRole = true;
        }
        Assert.assertTrue((boolean)userHasRole);
        boolean roleHasRight = RoleBasedAccessControl.queryRightForRole((Role)ur, (ACE)AccessControlDefaults.AC_EXIT);
        Assert.assertTrue((boolean)roleHasRight);
        boolean userHasRight = RoleBasedAccessControl.queryRightForUser((User)this.user, (ACE)AccessControlDefaults.AC_EXIT);
        Assert.assertTrue((boolean)userHasRight);
    }

    @Test
    public void testUserAddWithNonOKRight() {
        boolean rightFalse = RoleBasedAccessControl.queryRightForUser((User)this.user, (ACE)AccessControlDefaults.ADMIN_ACE);
        Assert.assertFalse((boolean)rightFalse);
    }

    @Test
    public void testUserAddAndRevokeParentRightInvolvesChildRights() {
        Role userRole = Role.load((String)"user");
        userRole.grantAccessRight(RoleBasedAccessControlTestACLContribution.parent);
        boolean rightTrue = RoleBasedAccessControl.queryRightForUser((User)this.user, (ACE)RoleBasedAccessControlTestACLContribution.child1child1);
        Assert.assertTrue((boolean)rightTrue);
        userRole.revokeAccessRight(RoleBasedAccessControlTestACLContribution.parent);
        boolean rightFalse = RoleBasedAccessControl.queryRightForUser((User)this.user, (ACE)RoleBasedAccessControlTestACLContribution.child1child1);
        Assert.assertFalse((boolean)rightFalse);
    }

    @Test
    public void testUserLock() {
        this.user.setActive(false);
        CoreHub.logoffAnwender();
        boolean rightFalse = Anwender.login((String)this.testUserName, (String)"password");
        Assert.assertFalse((boolean)rightFalse);
        this.user.setActive(true);
    }
}

