/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.builder;

import ca.uhn.hl7v2.validation.ValidationException;
import ca.uhn.hl7v2.validation.builder.Predicate;
import ca.uhn.hl7v2.validation.builder.PredicateRuleSupport;
import ca.uhn.hl7v2.validation.impl.AbstractPrimitiveTypeRule;
import java.util.regex.Pattern;

public class PredicatePrimitiveTypeRule
extends AbstractPrimitiveTypeRule
implements PredicateRuleSupport<String> {
    private static final Pattern LEADING_WHITESPACE = Pattern.compile("^\\s+");
    private static final Pattern TRAILING_WHITESPACE = Pattern.compile("\\s+$");
    private Predicate predicate;
    private Trimmer trimmer;

    public PredicatePrimitiveTypeRule(Predicate predicate) {
        this(predicate, Trimmer.NONE);
    }

    public PredicatePrimitiveTypeRule(Predicate predicate, Trimmer trimmer) {
        this.predicate = predicate;
        this.trimmer = trimmer;
        this.setDescription("Primitive value '%s' requires to be " + predicate.getDescription());
    }

    @Override
    public Predicate getPredicate() {
        return this.predicate;
    }

    @Override
    public String correct(String value) {
        return this.trimmer.trim(value);
    }

    @Override
    public boolean test(String value) {
        try {
            return this.getPredicate().evaluate(value);
        }
        catch (ValidationException e) {
            return false;
        }
    }

    @Override
    public ValidationException[] apply(String value) {
        try {
            return this.result(this.getPredicate().evaluate(this.correct(value)), value);
        }
        catch (ValidationException e) {
            return this.failed(e);
        }
    }

    public String toString() {
        return this.getDescription();
    }

    public static enum Trimmer {
        LEFT{

            @Override
            public String trim(String source) {
                return this.trimPattern(LEADING_WHITESPACE, source);
            }
        }
        ,
        RIGHT{

            @Override
            public String trim(String source) {
                return this.trimPattern(TRAILING_WHITESPACE, source);
            }
        }
        ,
        NONE{

            @Override
            public String trim(String source) {
                return source;
            }
        }
        ,
        ALL{

            @Override
            public String trim(String source) {
                return source == null ? null : source.trim();
            }
        };


        public abstract String trim(String var1);

        protected String trimPattern(Pattern pattern, String source) {
            if (source == null || pattern == null) {
                return source;
            }
            return pattern.matcher(source).replaceAll("");
        }
    }
}

