/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.parser;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.Version;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.parser.AbstractModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomModelClassFactory
extends AbstractModelClassFactory {
    private static final long serialVersionUID = 1L;
    private static Logger LOG = LoggerFactory.getLogger(CustomModelClassFactory.class);
    private final ModelClassFactory delegate;
    private Map<String, String[]> customModelClasses;
    private ConcurrentMap<String, Class> cache = new ConcurrentHashMap<String, Class>();

    public CustomModelClassFactory() {
        this((Map<String, String[]>)null);
    }

    public CustomModelClassFactory(String packageName) {
        this(new HashMap<String, String[]>());
        if (!packageName.endsWith(".")) {
            packageName = packageName + ".";
        }
        for (Version v : Version.values()) {
            this.addModel(v.getVersion(), new String[]{packageName + v.getPackageVersion()});
        }
    }

    public CustomModelClassFactory(Map<String, String[]> map) {
        this(new DefaultModelClassFactory(), map);
    }

    public CustomModelClassFactory(ModelClassFactory defaultFactory, Map<String, String[]> map) {
        this.delegate = defaultFactory;
        this.customModelClasses = map;
    }

    @Override
    public Class<? extends Message> getMessageClass(String name, String version, boolean isExplicit) throws HL7Exception {
        String key;
        Class<Object> retVal;
        if (!isExplicit) {
            name = this.getMessageStructureForEvent(name, Version.versionOf(version));
        }
        if ((retVal = (Class)this.cache.get(key = "message" + name + version)) != null) {
            return retVal;
        }
        retVal = this.findClass("message", name, version);
        if (retVal == null) {
            retVal = this.delegate.getMessageClass(name, version, isExplicit);
        }
        if (retVal != null) {
            this.cache.putIfAbsent(key, retVal);
        }
        return retVal;
    }

    @Override
    public Class<? extends Group> getGroupClass(String name, String version) throws HL7Exception {
        String key = "group" + name + version;
        Class<Object> retVal = (Class)this.cache.get(key);
        if (retVal != null) {
            return retVal;
        }
        retVal = this.findClass("group", name, version);
        if (retVal == null) {
            retVal = this.delegate.getGroupClass(name, version);
        }
        if (retVal != null) {
            this.cache.putIfAbsent(key, retVal);
        }
        return retVal;
    }

    @Override
    public Class<? extends Segment> getSegmentClass(String name, String version) throws HL7Exception {
        String key = "segment" + name + version;
        Class<Object> retVal = (Class)this.cache.get(key);
        if (retVal != null) {
            return retVal;
        }
        retVal = this.findClass("segment", name, version);
        if (retVal == null) {
            retVal = this.delegate.getSegmentClass(name, version);
        }
        if (retVal != null) {
            this.cache.putIfAbsent(key, retVal);
        }
        return retVal;
    }

    @Override
    public Class<? extends Type> getTypeClass(String name, String version) throws HL7Exception {
        String key = "datatype" + name + version;
        Class<Object> retVal = (Class)this.cache.get(key);
        if (retVal != null) {
            return retVal;
        }
        retVal = this.findClass("datatype", name, version);
        if (retVal == null) {
            retVal = this.delegate.getTypeClass(name, version);
        }
        if (retVal != null) {
            this.cache.putIfAbsent(key, retVal);
        }
        return retVal;
    }

    protected <T> Class<T> findClass(String subpackage, String name, String version) throws HL7Exception {
        Class<?> classLoaded = null;
        if (this.customModelClasses != null && this.customModelClasses.containsKey(version)) {
            for (String next : this.customModelClasses.get(version)) {
                if (!next.endsWith(".")) {
                    next = next + ".";
                }
                String fullyQualifiedName = next + subpackage + '.' + name;
                try {
                    classLoaded = Class.forName(fullyQualifiedName);
                    LOG.debug("Found " + fullyQualifiedName + " in custom HL7 model");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        return classLoaded;
    }

    @Override
    public Class<? extends Message> getMessageClassInASpecificPackage(String theName, String theVersion, boolean theIsExplicit, String thePackageName) throws HL7Exception {
        return this.delegate.getMessageClassInASpecificPackage(theName, theVersion, theIsExplicit, thePackageName);
    }

    public Map<String, String[]> getCustomModelClasses() {
        return this.customModelClasses;
    }

    public void addModels(Map<String, String[]> addedModelClasses) {
        if (this.customModelClasses == null) {
            this.customModelClasses = new HashMap<String, String[]>();
        }
        for (Map.Entry<String, String[]> entry : addedModelClasses.entrySet()) {
            this.addModel(entry.getKey(), entry.getValue());
        }
    }

    private void addModel(String version, String[] newPackageNames) {
        if (this.customModelClasses.containsKey(version)) {
            String[] existingPackageNames = this.customModelClasses.get(version);
            this.customModelClasses.put(version, StringUtil.concatenate(existingPackageNames, newPackageNames));
        } else {
            this.customModelClasses.put(version, newPackageNames);
        }
    }

    @Override
    public String getMessageStructureForEvent(String eventName, Version version) throws HL7Exception {
        String structure = super.getMessageStructureForEvent(eventName, version);
        if (structure != null) {
            return structure;
        }
        structure = this.delegate.getMessageStructureForEvent(eventName, version);
        return structure != null ? structure : eventName;
    }
}

