/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CNE;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.DTM;
import ca.uhn.hl7v2.model.v26.datatype.EI;
import ca.uhn.hl7v2.model.v26.datatype.ID;
import ca.uhn.hl7v2.model.v26.datatype.NM;
import ca.uhn.hl7v2.model.v26.datatype.ST;
import ca.uhn.hl7v2.model.v26.datatype.TQ;
import ca.uhn.hl7v2.model.v26.datatype.XPN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class GOL
extends AbstractSegment {
    public GOL(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ID.class, true, 1, 2, new Object[]{this.getMessage(), new Integer(287)}, "Action Code");
            this.add(DTM.class, true, 1, 24, new Object[]{this.getMessage()}, "Action Date/Time");
            this.add(CWE.class, true, 1, 705, new Object[]{this.getMessage()}, "Goal ID");
            this.add(EI.class, true, 1, 60, new Object[]{this.getMessage()}, "Goal Instance ID");
            this.add(EI.class, false, 1, 60, new Object[]{this.getMessage()}, "Episode of Care ID");
            this.add(NM.class, false, 1, 60, new Object[]{this.getMessage()}, "Goal List Priority");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Goal Established Date/Time");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Expected Goal Achieve Date/Time");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Goal Classification");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Goal Management Discipline");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Current Goal Review Status");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Current Goal Review Date/Time");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Next Goal Review Date/Time");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Previous Goal Review Date/Time");
            this.add(TQ.class, false, 1, 200, new Object[]{this.getMessage()}, "Goal Review Interval");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Goal Evaluation");
            this.add(ST.class, false, 0, 300, new Object[]{this.getMessage()}, "Goal Evaluation Comment");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Goal Life Cycle Status");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Goal Life Cycle Status Date/Time");
            this.add(CWE.class, false, 0, 705, new Object[]{this.getMessage()}, "Goal Target Type");
            this.add(XPN.class, false, 0, 250, new Object[]{this.getMessage()}, "Goal Target Name");
            this.add(CNE.class, false, 1, 705, new Object[]{this.getMessage()}, "Mood Code");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating GOL - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public ID getActionCode() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getGol1_ActionCode() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public DTM getActionDateTime() {
        DTM retVal = (DTM)this.getTypedField(2, 0);
        return retVal;
    }

    public DTM getGol2_ActionDateTime() {
        DTM retVal = (DTM)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getGoalID() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getGol3_GoalID() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public EI getGoalInstanceID() {
        EI retVal = (EI)this.getTypedField(4, 0);
        return retVal;
    }

    public EI getGol4_GoalInstanceID() {
        EI retVal = (EI)this.getTypedField(4, 0);
        return retVal;
    }

    public EI getEpisodeOfCareID() {
        EI retVal = (EI)this.getTypedField(5, 0);
        return retVal;
    }

    public EI getGol5_EpisodeOfCareID() {
        EI retVal = (EI)this.getTypedField(5, 0);
        return retVal;
    }

    public NM getGoalListPriority() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public NM getGol6_GoalListPriority() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public DTM getGoalEstablishedDateTime() {
        DTM retVal = (DTM)this.getTypedField(7, 0);
        return retVal;
    }

    public DTM getGol7_GoalEstablishedDateTime() {
        DTM retVal = (DTM)this.getTypedField(7, 0);
        return retVal;
    }

    public DTM getExpectedGoalAchieveDateTime() {
        DTM retVal = (DTM)this.getTypedField(8, 0);
        return retVal;
    }

    public DTM getGol8_ExpectedGoalAchieveDateTime() {
        DTM retVal = (DTM)this.getTypedField(8, 0);
        return retVal;
    }

    public CWE getGoalClassification() {
        CWE retVal = (CWE)this.getTypedField(9, 0);
        return retVal;
    }

    public CWE getGol9_GoalClassification() {
        CWE retVal = (CWE)this.getTypedField(9, 0);
        return retVal;
    }

    public CWE getGoalManagementDiscipline() {
        CWE retVal = (CWE)this.getTypedField(10, 0);
        return retVal;
    }

    public CWE getGol10_GoalManagementDiscipline() {
        CWE retVal = (CWE)this.getTypedField(10, 0);
        return retVal;
    }

    public CWE getCurrentGoalReviewStatus() {
        CWE retVal = (CWE)this.getTypedField(11, 0);
        return retVal;
    }

    public CWE getGol11_CurrentGoalReviewStatus() {
        CWE retVal = (CWE)this.getTypedField(11, 0);
        return retVal;
    }

    public DTM getCurrentGoalReviewDateTime() {
        DTM retVal = (DTM)this.getTypedField(12, 0);
        return retVal;
    }

    public DTM getGol12_CurrentGoalReviewDateTime() {
        DTM retVal = (DTM)this.getTypedField(12, 0);
        return retVal;
    }

    public DTM getNextGoalReviewDateTime() {
        DTM retVal = (DTM)this.getTypedField(13, 0);
        return retVal;
    }

    public DTM getGol13_NextGoalReviewDateTime() {
        DTM retVal = (DTM)this.getTypedField(13, 0);
        return retVal;
    }

    public DTM getPreviousGoalReviewDateTime() {
        DTM retVal = (DTM)this.getTypedField(14, 0);
        return retVal;
    }

    public DTM getGol14_PreviousGoalReviewDateTime() {
        DTM retVal = (DTM)this.getTypedField(14, 0);
        return retVal;
    }

    public TQ getGoalReviewInterval() {
        TQ retVal = (TQ)this.getTypedField(15, 0);
        return retVal;
    }

    public TQ getGol15_GoalReviewInterval() {
        TQ retVal = (TQ)this.getTypedField(15, 0);
        return retVal;
    }

    public CWE getGoalEvaluation() {
        CWE retVal = (CWE)this.getTypedField(16, 0);
        return retVal;
    }

    public CWE getGol16_GoalEvaluation() {
        CWE retVal = (CWE)this.getTypedField(16, 0);
        return retVal;
    }

    public ST[] getGoalEvaluationComment() {
        ST[] retVal = (ST[])this.getTypedField(17, new ST[0]);
        return retVal;
    }

    public ST[] getGol17_GoalEvaluationComment() {
        ST[] retVal = (ST[])this.getTypedField(17, new ST[0]);
        return retVal;
    }

    public int getGoalEvaluationCommentReps() {
        return this.getReps(17);
    }

    public ST getGoalEvaluationComment(int rep) {
        ST retVal = (ST)this.getTypedField(17, rep);
        return retVal;
    }

    public ST getGol17_GoalEvaluationComment(int rep) {
        ST retVal = (ST)this.getTypedField(17, rep);
        return retVal;
    }

    public int getGol17_GoalEvaluationCommentReps() {
        return this.getReps(17);
    }

    public ST insertGoalEvaluationComment(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(17, rep);
    }

    public ST insertGol17_GoalEvaluationComment(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(17, rep);
    }

    public ST removeGoalEvaluationComment(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(17, rep);
    }

    public ST removeGol17_GoalEvaluationComment(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(17, rep);
    }

    public CWE getGoalLifeCycleStatus() {
        CWE retVal = (CWE)this.getTypedField(18, 0);
        return retVal;
    }

    public CWE getGol18_GoalLifeCycleStatus() {
        CWE retVal = (CWE)this.getTypedField(18, 0);
        return retVal;
    }

    public DTM getGoalLifeCycleStatusDateTime() {
        DTM retVal = (DTM)this.getTypedField(19, 0);
        return retVal;
    }

    public DTM getGol19_GoalLifeCycleStatusDateTime() {
        DTM retVal = (DTM)this.getTypedField(19, 0);
        return retVal;
    }

    public CWE[] getGoalTargetType() {
        CWE[] retVal = (CWE[])this.getTypedField(20, new CWE[0]);
        return retVal;
    }

    public CWE[] getGol20_GoalTargetType() {
        CWE[] retVal = (CWE[])this.getTypedField(20, new CWE[0]);
        return retVal;
    }

    public int getGoalTargetTypeReps() {
        return this.getReps(20);
    }

    public CWE getGoalTargetType(int rep) {
        CWE retVal = (CWE)this.getTypedField(20, rep);
        return retVal;
    }

    public CWE getGol20_GoalTargetType(int rep) {
        CWE retVal = (CWE)this.getTypedField(20, rep);
        return retVal;
    }

    public int getGol20_GoalTargetTypeReps() {
        return this.getReps(20);
    }

    public CWE insertGoalTargetType(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(20, rep);
    }

    public CWE insertGol20_GoalTargetType(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(20, rep);
    }

    public CWE removeGoalTargetType(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(20, rep);
    }

    public CWE removeGol20_GoalTargetType(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(20, rep);
    }

    public XPN[] getGoalTargetName() {
        XPN[] retVal = (XPN[])this.getTypedField(21, new XPN[0]);
        return retVal;
    }

    public XPN[] getGol21_GoalTargetName() {
        XPN[] retVal = (XPN[])this.getTypedField(21, new XPN[0]);
        return retVal;
    }

    public int getGoalTargetNameReps() {
        return this.getReps(21);
    }

    public XPN getGoalTargetName(int rep) {
        XPN retVal = (XPN)this.getTypedField(21, rep);
        return retVal;
    }

    public XPN getGol21_GoalTargetName(int rep) {
        XPN retVal = (XPN)this.getTypedField(21, rep);
        return retVal;
    }

    public int getGol21_GoalTargetNameReps() {
        return this.getReps(21);
    }

    public XPN insertGoalTargetName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(21, rep);
    }

    public XPN insertGol21_GoalTargetName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(21, rep);
    }

    public XPN removeGoalTargetName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(21, rep);
    }

    public XPN removeGol21_GoalTargetName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(21, rep);
    }

    public CNE getMoodCode() {
        CNE retVal = (CNE)this.getTypedField(22, 0);
        return retVal;
    }

    public CNE getGol22_MoodCode() {
        CNE retVal = (CNE)this.getTypedField(22, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ID(this.getMessage(), new Integer(287));
            }
            case 1: {
                return new DTM(this.getMessage());
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new EI(this.getMessage());
            }
            case 4: {
                return new EI(this.getMessage());
            }
            case 5: {
                return new NM(this.getMessage());
            }
            case 6: {
                return new DTM(this.getMessage());
            }
            case 7: {
                return new DTM(this.getMessage());
            }
            case 8: {
                return new CWE(this.getMessage());
            }
            case 9: {
                return new CWE(this.getMessage());
            }
            case 10: {
                return new CWE(this.getMessage());
            }
            case 11: {
                return new DTM(this.getMessage());
            }
            case 12: {
                return new DTM(this.getMessage());
            }
            case 13: {
                return new DTM(this.getMessage());
            }
            case 14: {
                return new TQ(this.getMessage());
            }
            case 15: {
                return new CWE(this.getMessage());
            }
            case 16: {
                return new ST(this.getMessage());
            }
            case 17: {
                return new CWE(this.getMessage());
            }
            case 18: {
                return new DTM(this.getMessage());
            }
            case 19: {
                return new CWE(this.getMessage());
            }
            case 20: {
                return new XPN(this.getMessage());
            }
            case 21: {
                return new CNE(this.getMessage());
            }
        }
        return null;
    }
}

