/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.DTM;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class CSP
extends AbstractSegment {
    public CSP(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CWE.class, true, 1, 705, new Object[]{this.getMessage()}, "Study Phase Identifier");
            this.add(DTM.class, true, 1, 24, new Object[]{this.getMessage()}, "Date/time Study Phase Began");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "Date/time Study Phase Ended");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage()}, "Study Phase Evaluability");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating CSP - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CWE getStudyPhaseIdentifier() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getCsp1_StudyPhaseIdentifier() {
        CWE retVal = (CWE)this.getTypedField(1, 0);
        return retVal;
    }

    public DTM getDateTimeStudyPhaseBegan() {
        DTM retVal = (DTM)this.getTypedField(2, 0);
        return retVal;
    }

    public DTM getCsp2_DateTimeStudyPhaseBegan() {
        DTM retVal = (DTM)this.getTypedField(2, 0);
        return retVal;
    }

    public DTM getDateTimeStudyPhaseEnded() {
        DTM retVal = (DTM)this.getTypedField(3, 0);
        return retVal;
    }

    public DTM getCsp3_DateTimeStudyPhaseEnded() {
        DTM retVal = (DTM)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getStudyPhaseEvaluability() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getCsp4_StudyPhaseEvaluability() {
        CWE retVal = (CWE)this.getTypedField(4, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CWE(this.getMessage());
            }
            case 1: {
                return new DTM(this.getMessage());
            }
            case 2: {
                return new DTM(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

