/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v251.group.OUL_R24_ORDER;
import ca.uhn.hl7v2.model.v251.group.OUL_R24_PATIENT;
import ca.uhn.hl7v2.model.v251.group.OUL_R24_VISIT;
import ca.uhn.hl7v2.model.v251.segment.DSC;
import ca.uhn.hl7v2.model.v251.segment.MSH;
import ca.uhn.hl7v2.model.v251.segment.NTE;
import ca.uhn.hl7v2.model.v251.segment.SFT;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class OUL_R24
extends AbstractMessage {
    public OUL_R24() {
        this(new DefaultModelClassFactory());
    }

    public OUL_R24(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(NTE.class, false, false);
            this.add(OUL_R24_PATIENT.class, false, false);
            this.add(OUL_R24_VISIT.class, false, false);
            this.add(OUL_R24_ORDER.class, true, true);
            this.add(DSC.class, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OUL_R24 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.5.1";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public NTE getNTE() {
        return this.getTyped("NTE", NTE.class);
    }

    public OUL_R24_PATIENT getPATIENT() {
        return this.getTyped("PATIENT", OUL_R24_PATIENT.class);
    }

    public OUL_R24_VISIT getVISIT() {
        return this.getTyped("VISIT", OUL_R24_VISIT.class);
    }

    public OUL_R24_ORDER getORDER() {
        return this.getTyped("ORDER", OUL_R24_ORDER.class);
    }

    public OUL_R24_ORDER getORDER(int rep) {
        return this.getTyped("ORDER", rep, OUL_R24_ORDER.class);
    }

    public int getORDERReps() {
        return this.getReps("ORDER");
    }

    public List<OUL_R24_ORDER> getORDERAll() throws HL7Exception {
        return this.getAllAsList("ORDER", OUL_R24_ORDER.class);
    }

    public void insertORDER(OUL_R24_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", structure, rep);
    }

    public OUL_R24_ORDER insertORDER(int rep) throws HL7Exception {
        return (OUL_R24_ORDER)super.insertRepetition("ORDER", rep);
    }

    public OUL_R24_ORDER removeORDER(int rep) throws HL7Exception {
        return (OUL_R24_ORDER)super.removeRepetition("ORDER", rep);
    }

    public DSC getDSC() {
        return this.getTyped("DSC", DSC.class);
    }
}

