/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.CE;
import ca.uhn.hl7v2.model.v25.datatype.PL;
import ca.uhn.hl7v2.model.v25.datatype.PLN;
import ca.uhn.hl7v2.model.v25.datatype.TS;
import ca.uhn.hl7v2.model.v25.datatype.XAD;
import ca.uhn.hl7v2.model.v25.datatype.XPN;
import ca.uhn.hl7v2.model.v25.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PRD
extends AbstractSegment {
    public PRD(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CE.class, true, 0, 250, new Object[]{this.getMessage()}, "Provider Role");
            this.add(XPN.class, false, 0, 250, new Object[]{this.getMessage()}, "Provider Name");
            this.add(XAD.class, false, 0, 250, new Object[]{this.getMessage()}, "Provider Address");
            this.add(PL.class, false, 1, 60, new Object[]{this.getMessage()}, "Provider Location");
            this.add(XTN.class, false, 0, 250, new Object[]{this.getMessage()}, "Provider Communication Information");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Preferred Method of Contact");
            this.add(PLN.class, false, 0, 100, new Object[]{this.getMessage()}, "Provider Identifiers");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Effective Start Date of Provider Role");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Effective End Date of Provider Role");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PRD - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CE[] getProviderRole() {
        CE[] retVal = (CE[])this.getTypedField(1, new CE[0]);
        return retVal;
    }

    public CE[] getPrd1_ProviderRole() {
        CE[] retVal = (CE[])this.getTypedField(1, new CE[0]);
        return retVal;
    }

    public int getProviderRoleReps() {
        return this.getReps(1);
    }

    public CE getProviderRole(int rep) {
        CE retVal = (CE)this.getTypedField(1, rep);
        return retVal;
    }

    public CE getPrd1_ProviderRole(int rep) {
        CE retVal = (CE)this.getTypedField(1, rep);
        return retVal;
    }

    public int getPrd1_ProviderRoleReps() {
        return this.getReps(1);
    }

    public CE insertProviderRole(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(1, rep);
    }

    public CE insertPrd1_ProviderRole(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(1, rep);
    }

    public CE removeProviderRole(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(1, rep);
    }

    public CE removePrd1_ProviderRole(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(1, rep);
    }

    public XPN[] getProviderName() {
        XPN[] retVal = (XPN[])this.getTypedField(2, new XPN[0]);
        return retVal;
    }

    public XPN[] getPrd2_ProviderName() {
        XPN[] retVal = (XPN[])this.getTypedField(2, new XPN[0]);
        return retVal;
    }

    public int getProviderNameReps() {
        return this.getReps(2);
    }

    public XPN getProviderName(int rep) {
        XPN retVal = (XPN)this.getTypedField(2, rep);
        return retVal;
    }

    public XPN getPrd2_ProviderName(int rep) {
        XPN retVal = (XPN)this.getTypedField(2, rep);
        return retVal;
    }

    public int getPrd2_ProviderNameReps() {
        return this.getReps(2);
    }

    public XPN insertProviderName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(2, rep);
    }

    public XPN insertPrd2_ProviderName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(2, rep);
    }

    public XPN removeProviderName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(2, rep);
    }

    public XPN removePrd2_ProviderName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(2, rep);
    }

    public XAD[] getProviderAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(3, new XAD[0]);
        return retVal;
    }

    public XAD[] getPrd3_ProviderAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(3, new XAD[0]);
        return retVal;
    }

    public int getProviderAddressReps() {
        return this.getReps(3);
    }

    public XAD getProviderAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(3, rep);
        return retVal;
    }

    public XAD getPrd3_ProviderAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(3, rep);
        return retVal;
    }

    public int getPrd3_ProviderAddressReps() {
        return this.getReps(3);
    }

    public XAD insertProviderAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(3, rep);
    }

    public XAD insertPrd3_ProviderAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(3, rep);
    }

    public XAD removeProviderAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(3, rep);
    }

    public XAD removePrd3_ProviderAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(3, rep);
    }

    public PL getProviderLocation() {
        PL retVal = (PL)this.getTypedField(4, 0);
        return retVal;
    }

    public PL getPrd4_ProviderLocation() {
        PL retVal = (PL)this.getTypedField(4, 0);
        return retVal;
    }

    public XTN[] getProviderCommunicationInformation() {
        XTN[] retVal = (XTN[])this.getTypedField(5, new XTN[0]);
        return retVal;
    }

    public XTN[] getPrd5_ProviderCommunicationInformation() {
        XTN[] retVal = (XTN[])this.getTypedField(5, new XTN[0]);
        return retVal;
    }

    public int getProviderCommunicationInformationReps() {
        return this.getReps(5);
    }

    public XTN getProviderCommunicationInformation(int rep) {
        XTN retVal = (XTN)this.getTypedField(5, rep);
        return retVal;
    }

    public XTN getPrd5_ProviderCommunicationInformation(int rep) {
        XTN retVal = (XTN)this.getTypedField(5, rep);
        return retVal;
    }

    public int getPrd5_ProviderCommunicationInformationReps() {
        return this.getReps(5);
    }

    public XTN insertProviderCommunicationInformation(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(5, rep);
    }

    public XTN insertPrd5_ProviderCommunicationInformation(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(5, rep);
    }

    public XTN removeProviderCommunicationInformation(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(5, rep);
    }

    public XTN removePrd5_ProviderCommunicationInformation(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(5, rep);
    }

    public CE getPreferredMethodOfContact() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getPrd6_PreferredMethodOfContact() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public PLN[] getProviderIdentifiers() {
        PLN[] retVal = (PLN[])this.getTypedField(7, new PLN[0]);
        return retVal;
    }

    public PLN[] getPrd7_ProviderIdentifiers() {
        PLN[] retVal = (PLN[])this.getTypedField(7, new PLN[0]);
        return retVal;
    }

    public int getProviderIdentifiersReps() {
        return this.getReps(7);
    }

    public PLN getProviderIdentifiers(int rep) {
        PLN retVal = (PLN)this.getTypedField(7, rep);
        return retVal;
    }

    public PLN getPrd7_ProviderIdentifiers(int rep) {
        PLN retVal = (PLN)this.getTypedField(7, rep);
        return retVal;
    }

    public int getPrd7_ProviderIdentifiersReps() {
        return this.getReps(7);
    }

    public PLN insertProviderIdentifiers(int rep) throws HL7Exception {
        return (PLN)super.insertRepetition(7, rep);
    }

    public PLN insertPrd7_ProviderIdentifiers(int rep) throws HL7Exception {
        return (PLN)super.insertRepetition(7, rep);
    }

    public PLN removeProviderIdentifiers(int rep) throws HL7Exception {
        return (PLN)super.removeRepetition(7, rep);
    }

    public PLN removePrd7_ProviderIdentifiers(int rep) throws HL7Exception {
        return (PLN)super.removeRepetition(7, rep);
    }

    public TS getEffectiveStartDateOfProviderRole() {
        TS retVal = (TS)this.getTypedField(8, 0);
        return retVal;
    }

    public TS getPrd8_EffectiveStartDateOfProviderRole() {
        TS retVal = (TS)this.getTypedField(8, 0);
        return retVal;
    }

    public TS getEffectiveEndDateOfProviderRole() {
        TS retVal = (TS)this.getTypedField(9, 0);
        return retVal;
    }

    public TS getPrd9_EffectiveEndDateOfProviderRole() {
        TS retVal = (TS)this.getTypedField(9, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CE(this.getMessage());
            }
            case 1: {
                return new XPN(this.getMessage());
            }
            case 2: {
                return new XAD(this.getMessage());
            }
            case 3: {
                return new PL(this.getMessage());
            }
            case 4: {
                return new XTN(this.getMessage());
            }
            case 5: {
                return new CE(this.getMessage());
            }
            case 6: {
                return new PLN(this.getMessage());
            }
            case 7: {
                return new TS(this.getMessage());
            }
            case 8: {
                return new TS(this.getMessage());
            }
        }
        return null;
    }
}

