/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.HD;
import ca.uhn.hl7v2.model.v25.datatype.ID;
import ca.uhn.hl7v2.model.v25.datatype.ST;

public class RP
extends AbstractComposite {
    private Type[] data;

    public RP(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[4];
        this.data[0] = new ST(this.getMessage());
        this.data[1] = new HD(this.getMessage());
        this.data[2] = new ID(this.getMessage(), 191);
        this.data[3] = new ID(this.getMessage(), 291);
    }

    @Override
    public Type[] getComponents() {
        return this.data;
    }

    @Override
    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + this.getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public ST getPointer() {
        return this.getTyped(0, ST.class);
    }

    public ST getRp1_Pointer() {
        return this.getTyped(0, ST.class);
    }

    public HD getApplicationID() {
        return this.getTyped(1, HD.class);
    }

    public HD getRp2_ApplicationID() {
        return this.getTyped(1, HD.class);
    }

    public ID getTypeOfData() {
        return this.getTyped(2, ID.class);
    }

    public ID getRp3_TypeOfData() {
        return this.getTyped(2, ID.class);
    }

    public ID getSubtype() {
        return this.getTyped(3, ID.class);
    }

    public ID getRp4_Subtype() {
        return this.getTyped(3, ID.class);
    }
}

