/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v24.datatype.CE;
import ca.uhn.hl7v2.model.v24.datatype.ID;
import ca.uhn.hl7v2.model.v24.datatype.IS;
import ca.uhn.hl7v2.model.v24.datatype.NM;
import ca.uhn.hl7v2.model.v24.datatype.SI;
import ca.uhn.hl7v2.model.v24.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class AIS
extends AbstractSegment {
    public AIS(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage()}, "Set ID - AIS");
            this.add(ID.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(206)}, "Segment Action Code");
            this.add(CE.class, true, 1, 250, new Object[]{this.getMessage()}, "Universal Service Identifier");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Start Date/Time");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Start Date/Time Offset");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Start Date/Time Offset Units");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Duration");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Duration Units");
            this.add(IS.class, false, 1, 10, new Object[]{this.getMessage(), new Integer(279)}, "Allow Substitution Code");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Filler Status Code");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Placer Supplemental Service Information");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Filler Supplemental Service Information");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating AIS - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDAIS() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getAis1_SetIDAIS() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getSegmentActionCode() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getAis2_SegmentActionCode() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getUniversalServiceIdentifier() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getAis3_UniversalServiceIdentifier() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public TS getStartDateTime() {
        TS retVal = (TS)this.getTypedField(4, 0);
        return retVal;
    }

    public TS getAis4_StartDateTime() {
        TS retVal = (TS)this.getTypedField(4, 0);
        return retVal;
    }

    public NM getStartDateTimeOffset() {
        NM retVal = (NM)this.getTypedField(5, 0);
        return retVal;
    }

    public NM getAis5_StartDateTimeOffset() {
        NM retVal = (NM)this.getTypedField(5, 0);
        return retVal;
    }

    public CE getStartDateTimeOffsetUnits() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getAis6_StartDateTimeOffsetUnits() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public NM getDuration() {
        NM retVal = (NM)this.getTypedField(7, 0);
        return retVal;
    }

    public NM getAis7_Duration() {
        NM retVal = (NM)this.getTypedField(7, 0);
        return retVal;
    }

    public CE getDurationUnits() {
        CE retVal = (CE)this.getTypedField(8, 0);
        return retVal;
    }

    public CE getAis8_DurationUnits() {
        CE retVal = (CE)this.getTypedField(8, 0);
        return retVal;
    }

    public IS getAllowSubstitutionCode() {
        IS retVal = (IS)this.getTypedField(9, 0);
        return retVal;
    }

    public IS getAis9_AllowSubstitutionCode() {
        IS retVal = (IS)this.getTypedField(9, 0);
        return retVal;
    }

    public CE getFillerStatusCode() {
        CE retVal = (CE)this.getTypedField(10, 0);
        return retVal;
    }

    public CE getAis10_FillerStatusCode() {
        CE retVal = (CE)this.getTypedField(10, 0);
        return retVal;
    }

    public CE[] getPlacerSupplementalServiceInformation() {
        CE[] retVal = (CE[])this.getTypedField(11, new CE[0]);
        return retVal;
    }

    public CE[] getAis11_PlacerSupplementalServiceInformation() {
        CE[] retVal = (CE[])this.getTypedField(11, new CE[0]);
        return retVal;
    }

    public int getPlacerSupplementalServiceInformationReps() {
        return this.getReps(11);
    }

    public CE getPlacerSupplementalServiceInformation(int rep) {
        CE retVal = (CE)this.getTypedField(11, rep);
        return retVal;
    }

    public CE getAis11_PlacerSupplementalServiceInformation(int rep) {
        CE retVal = (CE)this.getTypedField(11, rep);
        return retVal;
    }

    public int getAis11_PlacerSupplementalServiceInformationReps() {
        return this.getReps(11);
    }

    public CE insertPlacerSupplementalServiceInformation(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(11, rep);
    }

    public CE insertAis11_PlacerSupplementalServiceInformation(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(11, rep);
    }

    public CE removePlacerSupplementalServiceInformation(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(11, rep);
    }

    public CE removeAis11_PlacerSupplementalServiceInformation(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(11, rep);
    }

    public CE[] getFillerSupplementalServiceInformation() {
        CE[] retVal = (CE[])this.getTypedField(12, new CE[0]);
        return retVal;
    }

    public CE[] getAis12_FillerSupplementalServiceInformation() {
        CE[] retVal = (CE[])this.getTypedField(12, new CE[0]);
        return retVal;
    }

    public int getFillerSupplementalServiceInformationReps() {
        return this.getReps(12);
    }

    public CE getFillerSupplementalServiceInformation(int rep) {
        CE retVal = (CE)this.getTypedField(12, rep);
        return retVal;
    }

    public CE getAis12_FillerSupplementalServiceInformation(int rep) {
        CE retVal = (CE)this.getTypedField(12, rep);
        return retVal;
    }

    public int getAis12_FillerSupplementalServiceInformationReps() {
        return this.getReps(12);
    }

    public CE insertFillerSupplementalServiceInformation(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(12, rep);
    }

    public CE insertAis12_FillerSupplementalServiceInformation(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(12, rep);
    }

    public CE removeFillerSupplementalServiceInformation(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(12, rep);
    }

    public CE removeAis12_FillerSupplementalServiceInformation(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(12, rep);
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(206));
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new TS(this.getMessage());
            }
            case 4: {
                return new NM(this.getMessage());
            }
            case 5: {
                return new CE(this.getMessage());
            }
            case 6: {
                return new NM(this.getMessage());
            }
            case 7: {
                return new CE(this.getMessage());
            }
            case 8: {
                return new IS(this.getMessage(), new Integer(279));
            }
            case 9: {
                return new CE(this.getMessage());
            }
            case 10: {
                return new CE(this.getMessage());
            }
            case 11: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

