/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v24.group.DFT_P11_OBSERVATION;
import ca.uhn.hl7v2.model.v24.group.DFT_P11_ORDER;
import ca.uhn.hl7v2.model.v24.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class DFT_P11_COMMON_ORDER
extends AbstractGroup {
    public DFT_P11_COMMON_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, false, false, false);
            this.add(DFT_P11_ORDER.class, false, false, false);
            this.add(DFT_P11_OBSERVATION.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating DFT_P11_COMMON_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.4";
    }

    public ORC getORC() {
        ORC retVal = this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public DFT_P11_ORDER getORDER() {
        DFT_P11_ORDER retVal = this.getTyped("ORDER", DFT_P11_ORDER.class);
        return retVal;
    }

    public DFT_P11_OBSERVATION getOBSERVATION() {
        DFT_P11_OBSERVATION retVal = this.getTyped("OBSERVATION", DFT_P11_OBSERVATION.class);
        return retVal;
    }

    public DFT_P11_OBSERVATION getOBSERVATION(int rep) {
        DFT_P11_OBSERVATION retVal = this.getTyped("OBSERVATION", rep, DFT_P11_OBSERVATION.class);
        return retVal;
    }

    public int getOBSERVATIONReps() {
        return this.getReps("OBSERVATION");
    }

    public List<DFT_P11_OBSERVATION> getOBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATION", DFT_P11_OBSERVATION.class);
    }

    public void insertOBSERVATION(DFT_P11_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", structure, rep);
    }

    public DFT_P11_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (DFT_P11_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public DFT_P11_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (DFT_P11_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }
}

