/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v231.datatype.CE;
import ca.uhn.hl7v2.model.v231.datatype.TS;

public class DIN
extends AbstractComposite {
    private Type[] data;

    public DIN(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[2];
        this.data[0] = new TS(this.getMessage());
        this.data[1] = new CE(this.getMessage());
    }

    @Override
    public Type[] getComponents() {
        return this.data;
    }

    @Override
    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + this.getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public TS getDate() {
        return this.getTyped(0, TS.class);
    }

    public TS getDin1_Date() {
        return this.getTyped(0, TS.class);
    }

    public CE getInstitutionName() {
        return this.getTyped(1, CE.class);
    }

    public CE getDin2_InstitutionName() {
        return this.getTyped(1, CE.class);
    }
}

