/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v23.group.SIU_S14_PATIENT;
import ca.uhn.hl7v2.model.v23.group.SIU_S14_RESOURCES;
import ca.uhn.hl7v2.model.v23.segment.MSH;
import ca.uhn.hl7v2.model.v23.segment.NTE;
import ca.uhn.hl7v2.model.v23.segment.SCH;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class SIU_S14
extends AbstractMessage {
    public SIU_S14() {
        this(new DefaultModelClassFactory());
    }

    public SIU_S14(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SCH.class, true, false);
            this.add(NTE.class, false, true);
            this.add(SIU_S14_PATIENT.class, false, true);
            this.add(SIU_S14_RESOURCES.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating SIU_S14 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.3";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SCH getSCH() {
        return this.getTyped("SCH", SCH.class);
    }

    public NTE getNTE() {
        return this.getTyped("NTE", NTE.class);
    }

    public NTE getNTE(int rep) {
        return this.getTyped("NTE", rep, NTE.class);
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public SIU_S14_PATIENT getPATIENT() {
        return this.getTyped("PATIENT", SIU_S14_PATIENT.class);
    }

    public SIU_S14_PATIENT getPATIENT(int rep) {
        return this.getTyped("PATIENT", rep, SIU_S14_PATIENT.class);
    }

    public int getPATIENTReps() {
        return this.getReps("PATIENT");
    }

    public List<SIU_S14_PATIENT> getPATIENTAll() throws HL7Exception {
        return this.getAllAsList("PATIENT", SIU_S14_PATIENT.class);
    }

    public void insertPATIENT(SIU_S14_PATIENT structure, int rep) throws HL7Exception {
        super.insertRepetition("PATIENT", structure, rep);
    }

    public SIU_S14_PATIENT insertPATIENT(int rep) throws HL7Exception {
        return (SIU_S14_PATIENT)super.insertRepetition("PATIENT", rep);
    }

    public SIU_S14_PATIENT removePATIENT(int rep) throws HL7Exception {
        return (SIU_S14_PATIENT)super.removeRepetition("PATIENT", rep);
    }

    public SIU_S14_RESOURCES getRESOURCES() {
        return this.getTyped("RESOURCES", SIU_S14_RESOURCES.class);
    }

    public SIU_S14_RESOURCES getRESOURCES(int rep) {
        return this.getTyped("RESOURCES", rep, SIU_S14_RESOURCES.class);
    }

    public int getRESOURCESReps() {
        return this.getReps("RESOURCES");
    }

    public List<SIU_S14_RESOURCES> getRESOURCESAll() throws HL7Exception {
        return this.getAllAsList("RESOURCES", SIU_S14_RESOURCES.class);
    }

    public void insertRESOURCES(SIU_S14_RESOURCES structure, int rep) throws HL7Exception {
        super.insertRepetition("RESOURCES", structure, rep);
    }

    public SIU_S14_RESOURCES insertRESOURCES(int rep) throws HL7Exception {
        return (SIU_S14_RESOURCES)super.insertRepetition("RESOURCES", rep);
    }

    public SIU_S14_RESOURCES removeRESOURCES(int rep) throws HL7Exception {
        return (SIU_S14_RESOURCES)super.removeRepetition("RESOURCES", rep);
    }
}

