/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Variable;
import ca.uhn.hl7v2.model.Varies;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ExtraComponents
implements Serializable {
    private static final long serialVersionUID = -2614683870975956395L;
    private List<Variable> comps = new ArrayList<Variable>();
    private Message message;

    public ExtraComponents(Message message) {
        this.message = message;
    }

    public int numComponents() {
        return this.comps.size();
    }

    public boolean isEmpty() throws HL7Exception {
        for (Variable varies : this.comps) {
            if (varies.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Message getMessage() {
        return this.message;
    }

    public Variable getComponent(int comp) {
        this.ensureComponentAndPredecessorsExist(comp);
        return this.comps.get(comp);
    }

    private void ensureComponentAndPredecessorsExist(int comp) {
        for (int i = this.comps.size(); i <= comp; ++i) {
            this.comps.add(new Varies(this.message));
        }
    }

    void clear() {
        this.comps.clear();
    }

    public String toString() {
        return "ExtraComponents" + this.comps;
    }
}

