/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.conf.classes.abs;

import ca.uhn.hl7v2.conf.classes.abs.Repeatable;
import ca.uhn.hl7v2.conf.classes.exceptions.ConfRepException;
import ca.uhn.hl7v2.conf.classes.exceptions.ConformanceError;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;

public class FiniteList {
    private ArrayList<Repeatable> reps;
    private int maxReps;
    private Class<? extends Repeatable> repType;
    private Object underlyingObject;

    public FiniteList(Class<? extends Repeatable> repType, Object underlyingObject) {
        this.repType = repType;
        this.underlyingObject = underlyingObject;
        Repeatable firstRep = this.createRep(0);
        this.maxReps = firstRep.getMaxReps();
        this.reps = new ArrayList();
        this.reps.add(firstRep);
        this.createNewReps(this.maxReps);
    }

    private void createNewReps(int rep) {
        while (this.reps.size() <= rep) {
            this.reps.add(this.createRep(this.reps.size()));
        }
    }

    private Repeatable createRep(int rep) {
        try {
            Constructor<?> theCon = this.repType.getConstructors()[0];
            Repeatable thisRep = (Repeatable)theCon.newInstance(this.underlyingObject, rep);
            return thisRep;
        }
        catch (InvocationTargetException e) {
            throw new ConformanceError("Error creating underlying repetition. This is a bug.\nError is: " + e.toString() + "\n" + e.getCause().toString());
        }
        catch (Exception e) {
            throw new ConformanceError("Error creating underlying repetition. This is a bug. Error is: " + e.toString());
        }
    }

    public Repeatable getRep(int rep) throws ConfRepException {
        if (rep < 1 || this.maxReps != -1 && this.maxReps < rep) {
            throw new ConfRepException(this.maxReps, rep);
        }
        this.createNewReps(--rep);
        return this.reps.get(rep);
    }
}

