/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swt;

import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.gui.AbstractTableComparatorChooser;
import ca.odell.glazedlists.impl.gui.MouseOnlySortingStrategy;
import ca.odell.glazedlists.impl.gui.SortingStrategy;
import ca.odell.glazedlists.swt.DefaultEventTableViewer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TableComparatorChooser<E>
extends AbstractTableComparatorChooser<E> {
    private final SortingStrategy sortingStrategy;
    private Table table;
    private List<Listener> sortListeners = new ArrayList<Listener>();
    private ColumnListener columnListener = new ColumnListener();

    public TableComparatorChooser(DefaultEventTableViewer<E> eventTableViewer, SortedList<E> sortedList, boolean multipleColumnSort) {
        super(sortedList, eventTableViewer.getTableFormat());
        this.table = eventTableViewer.getTable();
        for (int c = 0; c < this.table.getColumnCount(); ++c) {
            this.table.getColumn(c).addSelectionListener((SelectionListener)this.columnListener);
        }
        this.sortingStrategy = new MouseOnlySortingStrategy(multipleColumnSort);
    }

    public static <E> TableComparatorChooser<E> install(DefaultEventTableViewer<E> eventTableViewer, SortedList<E> sortedList, boolean multipleColumnSort) {
        return new TableComparatorChooser<E>(eventTableViewer, sortedList, multipleColumnSort);
    }

    public void addSortListener(Listener sortListener) {
        this.sortListeners.add(sortListener);
    }

    public void removeSortActionListener(Listener sortListener) {
        Iterator<Listener> i = this.sortListeners.iterator();
        while (i.hasNext()) {
            if (sortListener != i.next()) continue;
            i.remove();
            return;
        }
        throw new IllegalArgumentException("Cannot remove nonexistent listener " + sortListener);
    }

    protected final void updateTableSortColumn() {
        List<Integer> sortedColumns = this.getSortingColumns();
        if (sortedColumns.isEmpty()) {
            this.table.setSortColumn(null);
            this.table.setSortDirection(0);
        } else {
            int primaryColumnIndex = sortedColumns.get(0);
            int sortDirection = this.isColumnReverse(primaryColumnIndex) ? 1024 : 128;
            this.table.setSortColumn(this.table.getColumn(primaryColumnIndex));
            this.table.setSortDirection(sortDirection);
        }
    }

    @Override
    protected final void rebuildComparator() {
        super.rebuildComparator();
        this.updateTableSortColumn();
        Event sortEvent = new Event();
        sortEvent.widget = this.table;
        Iterator<Listener> i = this.sortListeners.iterator();
        while (i.hasNext()) {
            i.next().handleEvent(sortEvent);
        }
    }

    @Override
    public void dispose() {
        for (int c = 0; c < this.table.getColumnCount(); ++c) {
            this.table.getColumn(c).removeSelectionListener((SelectionListener)this.columnListener);
        }
    }

    class ColumnListener
    implements SelectionListener {
        ColumnListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            TableColumn column = (TableColumn)e.widget;
            Table table = column.getParent();
            int columnIndex = table.indexOf(column);
            TableComparatorChooser.this.sortingStrategy.columnClicked(TableComparatorChooser.this.sortingState, columnIndex, 1, false, false);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

