/*
 * Decompiled with CFR 0.152.
 */
package waelti.statistics.views;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import waelti.statistics.actions.ColumnSorterAdapter;
import waelti.statistics.queries.AbstractQuery;

public class TableViewerFactory {
    private Composite parent;
    private AbstractQuery query;

    public TableViewerFactory(Composite parent, AbstractQuery query) {
        this.parent = parent;
        this.query = query;
    }

    public TableViewer createTableViewer() {
        Table table = this.createTable();
        TableViewer viewer = new TableViewer(table);
        viewer.setContentProvider((IContentProvider)this.query.getContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)this.query.getLabelProvider());
        this.addColumnSort(viewer);
        viewer.setInput((Object)"");
        this.packColumns(viewer.getTable());
        return viewer;
    }

    private Table createTable() {
        Table table = new Table(this.parent, 768);
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        this.createColumns(table);
        return table;
    }

    private void packColumns(Table table) {
        TableColumn[] col = table.getColumns();
        int i = 0;
        while (i < col.length) {
            col[i].pack();
            ++i;
        }
    }

    private void createColumns(Table table) {
        for (String text : this.query.getTableHeadings()) {
            TableColumn column = new TableColumn(table, 16384);
            column.setText(text);
            column.setWidth(text.length() * 8);
        }
    }

    private void addColumnSort(TableViewer viewer) {
        TableColumn[] cols = viewer.getTable().getColumns();
        int i = 0;
        while (i < cols.length) {
            cols[i].addSelectionListener((SelectionListener)new ColumnSorterAdapter(viewer, i));
            ++i;
        }
    }

    public AbstractQuery getQuery() {
        return this.query;
    }

    public void setQuery(AbstractQuery query) {
        this.query = query;
    }
}

