/*
 * Decompiled with CFR 0.152.
 */
package waelti.statistics.views;

import ch.elexis.core.ui.util.SWTHelper;
import java.util.Hashtable;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import waelti.statistics.actions.NewQueryAction;
import waelti.statistics.queries.AbstractQuery;
import waelti.statistics.queries.Consultations;
import waelti.statistics.queries.PatientCosts;
import waelti.statistics.views.OptionPanel;

public class QueryInputDialog
extends TitleAreaDialog {
    private Hashtable<String, AbstractQuery> queryTable = new Hashtable();
    private OptionPanel options;
    private Combo combo;
    private Text description;
    private NewQueryAction action;

    public QueryInputDialog(Shell parentShell) {
        super(parentShell);
        this.fillQueryTable();
    }

    private void fillQueryTable() {
        IConfigurationElement[] elements;
        Consultations cons = new Consultations();
        this.queryTable.put(cons.getTitle(), cons);
        PatientCosts patient = new PatientCosts();
        this.queryTable.put(patient.getTitle(), patient);
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("Waelti.Statistics.Query");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                AbstractQuery query = (AbstractQuery)((Object)element.createExecutableExtension("class"));
                this.queryTable.put(query.getTitle(), query);
            }
            catch (CoreException e) {
                System.out.println((Object)e);
            }
            ++n2;
        }
    }

    public QueryInputDialog(Shell shell, NewQueryAction newQueryAction) {
        this(shell);
        this.action = newQueryAction;
    }

    public void create() {
        super.create();
        this.setTitle("Neue Auswertung starten");
        this.setMessage("W\u00e4hlen Sie eine Auswertung aus und definieren Sie die Parameter.");
    }

    public Control createDialogArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        area.setLayout((Layout)layout);
        GridData gridData = SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true);
        gridData.widthHint = this.convertHorizontalDLUsToPixels(350);
        area.setLayoutData((Object)gridData);
        this.initCombo(area);
        this.initDescription(area);
        return area;
    }

    private void initDescription(Composite parent) {
        this.description = new Text(parent, 72);
        this.description.setText("Keine Auswertung ausgew\u00e4hlt. W\u00e4hlen Sie bitte eine Auswertung aus.");
        this.description.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
    }

    private void initCombo(Composite parent) {
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.combo = new Combo(parent, 8);
        this.combo.setLayoutData((Object)gridData);
        Set<String> titleSet = this.queryTable.keySet();
        for (String title : titleSet) {
            this.combo.add(title);
        }
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String text = QueryInputDialog.this.combo.getText();
                AbstractQuery selectedQuery = (AbstractQuery)((Object)QueryInputDialog.this.queryTable.get(text));
                QueryInputDialog.this.updateDescription(selectedQuery);
                if (QueryInputDialog.this.options == null) {
                    QueryInputDialog.this.initOptions(QueryInputDialog.this.combo.getParent());
                }
                QueryInputDialog.this.options.updateContent(selectedQuery);
                QueryInputDialog.this.getShell().pack();
            }
        });
    }

    private void initOptions(Composite parent) {
        this.options = new OptionPanel(parent);
        this.options.setLayoutData(SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
    }

    private void updateDescription(AbstractQuery selectedQuery) {
        this.description.setText(selectedQuery.getDescription());
    }

    protected void okPressed() {
        if (this.createQuery()) {
            super.okPressed();
        }
    }

    private boolean createQuery() {
        try {
            AbstractQuery query = this.options.getQuery();
            this.action.setConfiguredQuery(query);
            return true;
        }
        catch (Exception e) {
            SWTHelper.showError((String)"Input Error", (String)e.getMessage());
            return false;
        }
    }
}

