/*
 * Decompiled with CFR 0.152.
 */
package waelti.statistics.queries;

import ch.rgw.tools.Money;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Scanner;

public class QueryUtil {
    public static int extractYear(String date) {
        if (date.length() != 0) {
            return new Integer(date.substring(6, 10));
        }
        return 0;
    }

    public static List<Object[]> initiateYears(int firstYear, int arraySize) {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        Calendar currentDate = Calendar.getInstance();
        int i = firstYear;
        while (i <= currentDate.get(1)) {
            Object[] row = new Object[arraySize];
            row[0] = i;
            int j = 1;
            while (j < arraySize) {
                row[j] = 0;
                ++j;
            }
            result.add(row);
            ++i;
        }
        return result;
    }

    public static List<Object[]> createCohorts(List<Object[]> list, int intervall) {
        ArrayList<Object[]> newList = new ArrayList<Object[]>(list.size() / intervall + 1);
        Object[] row = new Object[list.get(0).length];
        int i = 0;
        for (Object[] objects : list) {
            int j;
            if (i % intervall == 0) {
                if (i != 0) {
                    newList.add(row);
                }
                row = new Object[list.get(0).length];
                row[0] = QueryUtil.getCohortName(objects[0], intervall);
                j = 1;
                while (j < row.length) {
                    row[j] = new Double(0.0);
                    ++j;
                }
            }
            j = 1;
            while (j < objects.length) {
                Double num = Double.valueOf(objects[j].toString());
                row[j] = (Double)row[j] + num;
                ++j;
            }
            ++i;
        }
        newList.add(row);
        return newList;
    }

    private static Object getCohortName(Object object, int intervall) {
        String name = object.toString();
        name = String.valueOf(name) + " - ";
        Integer lastYear = Integer.valueOf(object.toString());
        lastYear = lastYear + (intervall - 1);
        name = String.valueOf(name) + lastYear;
        return name;
    }

    public static List<String[]> convertToString(List<Object[]> list) {
        assert (list != null);
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (Object[] row : list) {
            String[] newRow = new String[row.length];
            int i = 0;
            while (i < newRow.length) {
                newRow[i] = row[i].toString();
                ++i;
            }
            result.add(newRow);
        }
        return result;
    }

    public static void convertToCurrency(List<Object[]> list, int column) {
        for (Object[] objects : list) {
            Double value = Double.valueOf(objects[column].toString());
            value = value / 100.0;
            objects[column] = new Money(value.doubleValue());
        }
    }

    public static double convertAndRoundMoney(int num) {
        int temp = num;
        if (temp % 5 != 0) {
            int add = 5 - temp % 5;
            temp += add;
        }
        return (double)temp / 100.0;
    }

    public static List<Object[]> addAverage(List<Object[]> list, int InColumn1, int InColumn2, int resultColumn) {
        for (Object[] objects : list) {
            double div = Double.valueOf(objects[InColumn1].toString());
            double div2 = Double.valueOf(objects[InColumn2].toString());
            if (div2 == 0.0) continue;
            objects[resultColumn] = div / div2;
        }
        return list;
    }

    public static Calendar convertToCalendar(String dateString) throws NumberFormatException {
        Calendar cal = Calendar.getInstance();
        cal.setLenient(false);
        Scanner scn = new Scanner(dateString).useDelimiter("\\.");
        int day = new Integer(scn.next());
        int month = new Integer(scn.next()) - 1;
        int year = new Integer(scn.next());
        cal.set(year, month, day);
        return cal;
    }

    public static String convertFromCalendar(Calendar cal) {
        StringBuffer str = new StringBuffer(10);
        str.append(cal.get(5));
        str.append(".");
        str.append(cal.get(2) + 1);
        str.append(".");
        str.append(cal.get(1));
        return str.toString();
    }

    public static void convertDoubleToInteger(List<Object[]> list, int index) {
        for (Object[] objects : list) {
            Double d = (Double)objects[index];
            int i = d.intValue();
            objects[index] = i;
        }
    }
}

